/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jdom.JDOMException;
import uk.ac.reload.moonunit.HelperProfile;
import uk.ac.reload.moonunit.SchemaController;
import uk.ac.reload.moonunit.SchemaHelper;
import uk.ac.reload.moonunit.schema.SchemaException;
import uk.ac.reload.moonunit.vocab.Vocabulary;

public abstract class ProfiledSchemaController
extends SchemaController {
    protected HelperProfile _helperProfile;

    protected ProfiledSchemaController() throws JDOMException, SchemaException, IOException {
        this.loadSchemaModel();
        this.loadHelperProfile(this.getDefaultProfileName());
    }

    public void loadHelperProfile(String profileName) throws JDOMException, IOException {
        File fileProfile = new File(this.getProfileFolder(), profileName + ".xml");
        if (!fileProfile.exists()) {
            throw new FileNotFoundException("Could not load Profile: " + profileName);
        }
        this._helperProfile = HelperProfile.getHelperProfile(fileProfile, this.getVocabFolder(), this.getSchemaHelperFolder());
        this.setVocabulary(Vocabulary.getVocabulary(this._helperProfile.getVocabFile()));
        this.setSchemaHelper(SchemaHelper.getSchemaHelper(this._helperProfile.getSchemaHelperFile()));
    }

    public HelperProfile getHelperProfile() {
        return this._helperProfile;
    }

    public String[] getHelperProfileNames() {
        return HelperProfile.getHelperProfileNames(this.getProfileFolder());
    }

    public abstract File getProfileFolder();

    public abstract String getDefaultProfileName();

    public abstract File getSchemaHelperFolder();

    public abstract File getVocabFolder();
}

