/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import uk.ac.reload.jdom.XMLPath;
import uk.ac.reload.jdom.XMLUtils;
import uk.ac.reload.moonunit.Messages;

public class SchemaHelper {
    public static final String ELEMENT = "element";
    public static final String PATH = "path";
    public static final String FNAME = "fname";
    public static final String TIP = "tip";
    public static final String WIDGET = "widget";
    public static final String MAXLENGTH = "maxLength";
    private Document _docHelper;
    private File _fileHelper;
    private static Hashtable _schemaHelperTable = new Hashtable();

    public static SchemaHelper getSchemaHelper(File fileHelper) throws JDOMException, IOException {
        SchemaHelper schemaHelper = (SchemaHelper)_schemaHelperTable.get(fileHelper);
        if (schemaHelper == null) {
            schemaHelper = new SchemaHelper(fileHelper);
            _schemaHelperTable.put(fileHelper, schemaHelper);
        }
        return schemaHelper;
    }

    public SchemaHelper(File fileHelper) throws JDOMException, IOException {
        this._fileHelper = fileHelper;
        this._docHelper = this.loadSchemaHelperFile(fileHelper);
    }

    protected Document loadSchemaHelperFile(File helperFile) throws JDOMException, IOException {
        return XMLUtils.readXMLFile((File)helperFile);
    }

    protected Document getSchemaHelperDocument() {
        return this._docHelper;
    }

    public String getSchemaHelperName() {
        return this._fileHelper == null ? Messages.getString("uk.ac.reload.moonunit.SchemaHelper.1") : this._fileHelper.getName();
    }

    public String getHelperValue(XMLPath xmlPath, String helperKey) {
        if (this._docHelper != null && this._docHelper.hasRootElement()) {
            String path = xmlPath.getPath();
            Element root = this._docHelper.getRootElement();
            for (Element childElement : root.getChildren(ELEMENT)) {
                String name = childElement.getAttributeValue(PATH);
                if (name == null || !path.equals(name) && !path.endsWith(name)) continue;
                String value = childElement.getAttributeValue(helperKey);
                if (value == null) {
                    Element child = childElement.getChild(helperKey);
                    if (child == null) continue;
                    return child.getText();
                }
                return value;
            }
        }
        return null;
    }

    public File getFile() {
        return this._fileHelper;
    }

    public String toString() {
        return this.getSchemaHelperName();
    }
}

