/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit.contentpackaging;

import java.io.File;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.reload.diva.util.FilePath;
import uk.ac.reload.diva.util.GeneralUtils;
import uk.ac.reload.diva.util.URLPath;
import uk.ac.reload.jdom.XMLDocument;

public class CP_Core {
    public static final String MANIFEST_NAME = "imsmanifest.xml";
    public static final String MANIFEST = "manifest";
    public static final String ORGANIZATIONS = "organizations";
    public static final String RESOURCES = "resources";
    public static final String DEFAULT = "default";
    public static final String ORGANIZATION = "organization";
    public static final String ITEM = "item";
    public static final String PARAMETERS = "parameters";
    public static final String RESOURCE = "resource";
    public static final String BASE = "base";
    public static final String FILE = "file";
    public static final String TYPE = "type";
    public static final String HREF = "href";
    public static final String METADATA = "metadata";
    public static final String IDENTIFIER = "identifier";
    public static final String IDENTIFIERREF = "identifierref";
    public static final String STRUCTURE = "structure";
    public static final String TITLE = "title";
    public static final String DEPENDENCY = "dependency";
    public static final String VERSION = "version";
    public static final String SCHEMA = "schema";
    public static final String SCHEMAVERSION = "schemaversion";
    public static final String ISVISIBLE = "isvisible";
    private XMLDocument _doc;

    public CP_Core(XMLDocument doc) {
        this._doc = doc;
    }

    public File getRootFolder() {
        File file = this._doc.getFile();
        return file == null ? null : file.getParentFile();
    }

    public void destroy() {
        this._doc = null;
    }

    public Element getRootManifestElement() {
        return this._doc.getRootElement();
    }

    public Element getReferencedElement(Element sourceElement) {
        Element manifest;
        String idref = sourceElement.getAttributeValue(IDENTIFIERREF);
        if (idref != null && (manifest = this.getParentManifestElement(sourceElement)) != null) {
            Element[] resources = this.getElementsInManifest(manifest, RESOURCE, this._doc.getRootNamespace());
            for (int i = 0; i < resources.length; ++i) {
                String id = resources[i].getAttributeValue(IDENTIFIER);
                if (id == null || !idref.equals(id)) continue;
                return resources[i];
            }
            Element[] submanifests = this.getElementsInManifest(manifest, MANIFEST, this._doc.getRootNamespace());
            for (int i = 0; i < submanifests.length; ++i) {
                String id = submanifests[i].getAttributeValue(IDENTIFIER);
                if (id == null || !idref.equals(id)) continue;
                return submanifests[i];
            }
        }
        return null;
    }

    public boolean isReferencingElement(Element element) {
        String idref = element.getAttributeValue(IDENTIFIERREF);
        return idref != null && !idref.equals("");
    }

    public String[] getReferencedIdentifersAllowed(Element element) {
        Vector<String> v = new Vector<String>();
        Element[] elements = this.getReferencedElementsAllowed(element);
        for (int i = 0; i < elements.length; ++i) {
            String id = elements[i].getAttributeValue(IDENTIFIER);
            if (id == null || id.equals("")) continue;
            v.add(id);
        }
        Object[] ids = new String[v.size()];
        v.copyInto(ids);
        return ids;
    }

    public Element[] getReferencedElementsAllowed(Element element) {
        Element manifest;
        Vector<Element> v = new Vector<Element>();
        String elementName = element.getName();
        if (elementName.equals(ITEM)) {
            manifest = this.getParentManifestElement(element);
            if (manifest != null) {
                Element[] resources = this.getElementsInManifest(manifest, RESOURCE, this._doc.getRootNamespace());
                for (int i = 0; i < resources.length; ++i) {
                    String id = resources[i].getAttributeValue(IDENTIFIER);
                    if (id == null || id.equals("")) continue;
                    v.add(resources[i]);
                }
                Element[] submanifests = this.getElementsInManifest(manifest, MANIFEST, this._doc.getRootNamespace());
                for (int i = 0; i < submanifests.length; ++i) {
                    String id = submanifests[i].getAttributeValue(IDENTIFIER);
                    if (id == null || id.equals("")) continue;
                    v.add(submanifests[i]);
                }
            }
        } else if (elementName.equals(DEPENDENCY) && (manifest = this.getParentManifestElement(element)) != null) {
            Element[] resources = this.getElementsInManifest(manifest, RESOURCE, this._doc.getRootNamespace());
            for (int i = 0; i < resources.length; ++i) {
                String id = resources[i].getAttributeValue(IDENTIFIER);
                if (id == null || id.equals("") || resources[i].equals((Object)element.getParent())) continue;
                v.add(resources[i]);
            }
        }
        Object[] elements = new Element[v.size()];
        v.copyInto(elements);
        return elements;
    }

    public Element[] getElementsInManifest(Element manifestElement, String elementName, Namespace ns) {
        Vector v = new Vector();
        this._getElementsInManifest(manifestElement, v, elementName, ns);
        Object[] elements = new Element[v.size()];
        v.copyInto(elements);
        return elements;
    }

    private void _getElementsInManifest(Element parent, Vector v, String elementName, Namespace ns) {
        for (Element child : parent.getChildren()) {
            if (child.getName().equals(elementName) && child.getNamespace().equals((Object)ns)) {
                v.add(child);
            }
            this._getElementsInManifest(child, v, elementName, ns);
        }
    }

    public Element getParentManifestElement(Element element) {
        while (!element.getName().equals(MANIFEST)) {
            if ((element = element.getParentElement()) != null) continue;
            return null;
        }
        return element;
    }

    public Element getElementByIdentifier(Element parent, String identifier) {
        String id = parent.getAttributeValue(IDENTIFIER);
        if (id != null && id.equals(identifier)) {
            return parent;
        }
        for (Element child : parent.getChildren()) {
            Element e;
            if (!this._doc.isDocumentNamespace(child) || (e = this.getElementByIdentifier(child, identifier)) == null) continue;
            return e;
        }
        return null;
    }

    public Element[] getOrganizations(Element orgsElement) {
        Vector<Element> v = new Vector<Element>();
        for (Element orgElement : orgsElement.getChildren(ORGANIZATION, orgsElement.getNamespace())) {
            v.add(orgElement);
        }
        Object[] orgs = new Element[v.size()];
        v.copyInto(orgs);
        return orgs;
    }

    public Element[] getOrganizationsAllowed(Element orgsElement) {
        Vector<Element> v = new Vector<Element>();
        Element[] orgs = this.getOrganizations(orgsElement);
        for (int i = 0; i < orgs.length; ++i) {
            String id = orgs[i].getAttributeValue(IDENTIFIER);
            if (id == null || id.equals("")) continue;
            v.add(orgs[i]);
        }
        Object[] new_orgs = new Element[v.size()];
        v.copyInto(new_orgs);
        return new_orgs;
    }

    public Element getDefaultOrganization(Element orgsElement) {
        Element element = null;
        if (orgsElement != null && orgsElement.getName().equals(ORGANIZATIONS)) {
            String defOrg = orgsElement.getAttributeValue(DEFAULT);
            if (defOrg != null) {
                element = this.getElementByIdentifier(orgsElement, defOrg);
            }
            if (element == null) {
                element = orgsElement.getChild(ORGANIZATION, orgsElement.getNamespace());
            }
        }
        return element;
    }

    public boolean isMetadataRoot(String name) {
        return name.equals("lom") || name.equals("record");
    }

    public boolean isMetadataElement(String name) {
        return name.equals(METADATA);
    }

    public String getRelativeURL(Element element) {
        String params = this.getParameters(element);
        String url = this.getElementHREF(element);
        if (url.toLowerCase().startsWith("www")) {
            url = "http://" + url;
        }
        return url + (params == null ? "" : params);
    }

    public String getAbsoluteURL(Element element) {
        String href = this.getElementHREF(element);
        if (href != null) {
            String params = this.getParameters(element);
            try {
                File file;
                String tmp = href.replaceAll("%20", " ");
                int index = tmp.indexOf("?");
                if (index != -1) {
                    params = tmp.substring(index);
                    tmp = tmp.substring(0, index);
                }
                if ((file = new File(this.getRootFolder(), tmp)).exists()) {
                    FilePath filePath = new FilePath(file, params);
                    return filePath.getURL();
                }
                URLPath urlPath = new URLPath(href + (params == null ? "" : params));
                return urlPath.getURL();
            }
            catch (MalformedURLException ex) {
                try {
                    URLPath urlPath = new URLPath("http://" + href + (params == null ? "" : params));
                    return urlPath.getURL();
                }
                catch (MalformedURLException ex1) {
                    return null;
                }
            }
        }
        return null;
    }

    public String getElementHREF(Element element) {
        String base;
        String name = element.getName();
        if ((name.equals(ITEM) || name.equals(DEPENDENCY)) && (element = this.getReferencedElement(element)) == null) {
            return null;
        }
        String href = element.getAttributeValue(HREF);
        if (href != null) {
            href = href.replace('\\', '/');
        }
        if (href != null && !GeneralUtils.isExternalURL((String)href) && (base = this.getElementBase(element)) != null) {
            href = base + href;
        }
        return href;
    }

    public String getElementBase(Element element) {
        String totalBase = "";
        do {
            String base;
            if ((base = element.getAttributeValue(BASE, Namespace.XML_NAMESPACE)) == null) continue;
            totalBase = base + totalBase;
            if (base.startsWith("/") || base.startsWith("http:")) break;
        } while ((element = element.getParentElement()) != null);
        return totalBase.equals("") ? null : totalBase;
    }

    public String getParameters(Element element) {
        char c;
        String params = element.getAttributeValue(PARAMETERS);
        if (params != null && !params.equals("") && (c = params.charAt(0)) != '?' && c != '#') {
            params = "?" + params;
        }
        return params;
    }

    public File getResourceFile(Element element) {
        File file;
        String href = this.getElementHREF(element);
        if (href != null && (file = new File(this.getRootFolder(), href.replaceAll("%20", " "))).exists()) {
            return file;
        }
        return null;
    }

    public File[] getResourceFiles(Element manifestElement) {
        Vector v = new Vector();
        if (MANIFEST.equals(manifestElement.getName())) {
            this._getResourceFiles(manifestElement, v);
        }
        Object[] files = new File[v.size()];
        v.copyInto(files);
        return files;
    }

    private void _getResourceFiles(Element manifestElement, Vector v) {
        Element resourcesElement = manifestElement.getChild(RESOURCES, manifestElement.getNamespace());
        if (resourcesElement != null) {
            for (Element resourceElement : resourcesElement.getChildren(RESOURCE, resourcesElement.getNamespace())) {
                File file = this.getResourceFile(resourceElement);
                if (file != null && !v.contains(file)) {
                    v.add(file);
                }
                for (Element fileElement : resourceElement.getChildren(FILE, resourceElement.getNamespace())) {
                    File file2 = this.getResourceFile(fileElement);
                    if (file2 == null || v.contains(file2)) continue;
                    v.add(file2);
                }
            }
        }
        List submanifestElement = manifestElement.getChildren(MANIFEST, manifestElement.getNamespace());
        for (Element asubmanifest : submanifestElement) {
            this._getResourceFiles(asubmanifest, v);
        }
    }

    public Element getResourceElementByHREF(String href, Element resourcesElement) {
        if (!RESOURCES.equals(resourcesElement.getName())) {
            return null;
        }
        for (Element resource : resourcesElement.getChildren(RESOURCE, resourcesElement.getNamespace())) {
            String tmp = resource.getAttributeValue(HREF);
            if (tmp == null || !(tmp = tmp.replaceAll("%20", " ")).equalsIgnoreCase(href = href.replaceAll("%20", " "))) continue;
            return resource;
        }
        return null;
    }

    public Element getFileElementByHREF(String href, Element resourceElement) {
        if (!RESOURCE.equals(resourceElement.getName())) {
            return null;
        }
        for (Element file : resourceElement.getChildren(FILE, resourceElement.getNamespace())) {
            String tmp = file.getAttributeValue(HREF);
            if (tmp == null || !(tmp = tmp.replaceAll("%20", " ")).equalsIgnoreCase(href = href.replaceAll("%20", " "))) continue;
            return file;
        }
        return null;
    }

    public Element getResourcesElement(Element element) {
        if (element.getName().equals(RESOURCES)) {
            return element;
        }
        Element manifest = this.getParentManifestElement(element);
        return manifest == null ? null : manifest.getChild(RESOURCES, element.getNamespace());
    }
}

