/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit.schema;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDMaxLengthFacet;
import org.eclipse.xsd.XSDMinLengthFacet;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDSchemaQueryTools;
import org.jdom.Attribute;
import org.jdom.Namespace;
import uk.ac.reload.jdom.XMLPath;
import uk.ac.reload.moonunit.schema.SchemaNode;
import uk.ac.reload.moonunit.vocab.VocabularyList;

public class SchemaAttribute
extends SchemaNode {
    private XSDAttributeDeclaration _attDecl;
    private String name;
    private boolean isFixed;

    public SchemaAttribute(XSDAttributeDeclaration attDecl) {
        this._attDecl = attDecl.isAttributeDeclarationReference() ? attDecl.getResolvedAttributeDeclaration() : attDecl;
        this.name = attDecl.getName();
        int idx = this.name.indexOf(58);
        if (idx >= 0) {
            this.name = this.name.substring(idx + 1);
        }
    }

    public String getName() {
        return this.name;
    }

    public XSDAttributeDeclaration getAttributeDecl() {
        return this._attDecl;
    }

    public String getUse() {
        XSDConcreteComponent comp = this._attDecl.getContainer();
        if (comp instanceof XSDAttributeUse) {
            XSDAttributeUseCategory useCat = ((XSDAttributeUse)comp).getUse();
            return useCat.getName();
        }
        if (comp instanceof XSDSchema) {
            return "optional";
        }
        return "optional";
    }

    public String getDefaultValue() {
        if (this._attDecl.getContainer() instanceof XSDAttributeUse) {
            XSDAttributeUse ause = (XSDAttributeUse)this._attDecl.getContainer();
            return ause.getLexicalValue();
        }
        return null;
    }

    public String getNamespacePrefix() {
        int idx;
        String refname = this._attDecl.getQName();
        if (refname != null && (idx = refname.indexOf(58)) >= 0) {
            String prefix = refname.substring(0, idx);
            if (prefix.equals("x")) {
                prefix = "xml";
            }
            return prefix;
        }
        return "";
    }

    public Namespace getNamespace() {
        String nsPrefix = this.getNamespacePrefix();
        if ("".equals(nsPrefix) || nsPrefix == null) {
            return Namespace.NO_NAMESPACE;
        }
        if (nsPrefix.equals("xml")) {
            return Namespace.XML_NAMESPACE;
        }
        String namespaceURI = (String)this.getSchemaModel().getNSMap().get(nsPrefix);
        if (namespaceURI == null || "".equals(namespaceURI)) {
            namespaceURI = this.getAttributeDecl().getTargetNamespace();
        }
        return Namespace.getNamespace((String)nsPrefix, (String)namespaceURI);
    }

    public VocabularyList getVocabularyList() {
        VocabularyList rvList = null;
        XSDSimpleTypeDefinition simpleType = this._attDecl.getTypeDefinition();
        if (simpleType != null) {
            if (XSDSchemaQueryTools.isTypeDerivedFrom((XSDTypeDefinition)simpleType, (String)this._attDecl.getSchema().getTargetNamespace(), (String)"boolean")) {
                rvList = VocabularyList.getTrueFalseList();
            } else if (this.getName().equals("lang")) {
                rvList = VocabularyList.getLangList();
            } else {
                Vector<String> v = null;
                EList enLst = simpleType.getEnumerationFacets();
                Iterator enIt = enLst.iterator();
                while (enIt.hasNext()) {
                    if (v == null) {
                        v = new Vector<String>();
                    }
                    XSDFacet facet = (XSDFacet)enIt.next();
                    v.addElement(facet.getLexicalValue());
                }
                if (v != null) {
                    Object[] s = new String[v.size()];
                    v.copyInto(s);
                    rvList = new VocabularyList("$schema$", (String[])s);
                }
            }
        }
        return rvList;
    }

    public String getTypeName() {
        XSDSimpleTypeDefinition simpleType = this._attDecl.getTypeDefinition();
        return simpleType == null ? "Not known" : simpleType.getName();
    }

    public Long getMaxLength() {
        XSDMaxLengthFacet lenFac;
        XSDSimpleTypeDefinition simpleType = this._attDecl.getTypeDefinition();
        if (simpleType != null && (lenFac = simpleType.getMaxLengthFacet()) != null) {
            return new Long(lenFac.getValue());
        }
        return null;
    }

    public Long getMinLength() {
        XSDMinLengthFacet lenFac;
        XSDSimpleTypeDefinition simpleType = this._attDecl.getTypeDefinition();
        if (simpleType != null && (lenFac = simpleType.getMinLengthFacet()) != null) {
            return new Long(lenFac.getValue());
        }
        return null;
    }

    public String getBaseTypeName() {
        XSDSimpleTypeDefinition simpleType = this._attDecl.getTypeDefinition();
        if (simpleType != null) {
            XSDTypeDefinition baseType = simpleType.getBaseType();
            if (baseType == null) {
                return simpleType.getName();
            }
            return baseType.getName();
        }
        return "Unknown BaseType";
    }

    public String getAtomicBaseTypeName() {
        String baseName = null;
        XSDSimpleTypeDefinition simpleType = this._attDecl.getTypeDefinition();
        if (simpleType != null) {
            XSDTypeDefinition baseType = simpleType.getBaseType();
            baseName = baseType.getRootType().getName();
            return baseName == null ? simpleType.getName() : baseName;
        }
        return "Unknown BaseType";
    }

    public String getFacetValue(String facetName) {
        String val = null;
        XSDSimpleTypeDefinition simpleType = this._attDecl.getTypeDefinition();
        if (simpleType != null) {
            EList facLst = simpleType.getFacets();
            for (XSDFacet tmpFacet : facLst) {
                if (!tmpFacet.getFacetName().equals(facetName)) continue;
                return tmpFacet.getLexicalValue();
            }
        }
        return val;
    }

    public Attribute createAttribute() {
        Attribute att = null;
        String localName = this.getName();
        if (this.isExternalNamespace()) {
            Namespace ns = this.getNamespace();
            int idx = localName.indexOf(58);
            if (idx >= 0) {
                localName = localName.substring(idx + 1);
            }
            att = new Attribute(localName, "", ns);
        } else {
            att = new Attribute(localName, "");
        }
        return att;
    }

    public XMLPath getXMLPath() {
        XMLPath xmlPath = this.getParent().getXMLPath();
        Attribute att = this.createAttribute();
        xmlPath.appendAttributeName(att.getQualifiedName());
        return xmlPath;
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public void setFixed(boolean isFixed) {
        this.isFixed = isFixed;
    }
}

