/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit.schema;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConstraint;
import org.eclipse.xsd.XSDContentTypeCategory;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDIdentityConstraintCategory;
import org.eclipse.xsd.XSDIdentityConstraintDefinition;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.XSDXPathDefinition;
import org.eclipse.xsd.util.XSDSchemaQueryTools;
import org.jdom.Namespace;
import org.w3c.dom.Element;
import uk.ac.reload.jdom.XMLPath;
import uk.ac.reload.moonunit.schema.SchemaAttribute;
import uk.ac.reload.moonunit.schema.SchemaModel;
import uk.ac.reload.moonunit.schema.SchemaNode;
import uk.ac.reload.moonunit.schema.SchemaWildcard;
import uk.ac.reload.moonunit.vocab.VocabularyList;

public class SchemaElement
extends SchemaNode {
    private XSDElementDeclaration xsdElementDecl;
    private String name;
    private SchemaElement[] children;
    private SchemaAttribute[] attributes;
    private SchemaWildcard childWildCard;
    private boolean resolvedWildCard;
    private XSDModelGroup xsdMGRef = null;
    private int minOccurs = 1;
    private int maxOccurs = 1;
    boolean childMinSet = false;
    boolean childMaxSet = false;

    public SchemaElement(XSDElementDeclaration elementDecl) {
        this.xsdElementDecl = elementDecl.getResolvedElementDeclaration();
        this.name = this.xsdElementDecl.getName();
        int idx = this.name.indexOf(58);
        if (idx >= 0) {
            this.name = this.name.substring(idx + 1);
        }
    }

    public SchemaElement setSchemaModel(SchemaModel schemaModel) {
        this.setParent(schemaModel);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getQName() {
        String prefix = this.getNamespacePrefix();
        if (!prefix.equals("")) {
            return prefix + ":" + this.name;
        }
        return this.name;
    }

    public XSDElementDeclaration getElementDecl() {
        return this.xsdElementDecl;
    }

    public String getNamespacePrefix() {
        String nsPrefix = (String)this.getSchemaModel().getNS2PrefixMap().get(this.xsdElementDecl.getTargetNamespace());
        if (nsPrefix == null) {
            return "";
        }
        return nsPrefix;
    }

    public Namespace getNamespace() {
        String nsURI = this.xsdElementDecl.getTargetNamespace();
        String nsPrefix = (String)this.getSchemaModel().getNS2PrefixMap().get(nsURI);
        if (nsPrefix == null) {
            nsPrefix = "";
        }
        return Namespace.getNamespace((String)nsPrefix, (String)nsURI);
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public XMLPath getXMLPath() {
        if (this.getParent() instanceof SchemaElement) {
            XMLPath xmlPath = this.getParent().getXMLPath();
            String elName = this.getName();
            if (this.isExternalNamespace()) {
                elName = this.getNamespacePrefix() + ":" + elName;
            }
            xmlPath.appendElementName(elName);
            return xmlPath;
        }
        return new XMLPath(this.getName());
    }

    public VocabularyList getVocabularyList() {
        XSDComplexTypeDefinition ctd;
        VocabularyList rvList = null;
        Vector<String> v = null;
        XSDTypeDefinition xmlType = this.getXMLType();
        if (xmlType instanceof XSDSimpleTypeDefinition) {
            XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)xmlType;
            if (XSDSchemaQueryTools.isTypeDerivedFrom((XSDTypeDefinition)simpleType, (String)simpleType.getSchema().getTargetNamespace(), (String)"boolean")) {
                rvList = VocabularyList.getTrueFalseList();
            } else {
                EList enLst = simpleType.getEnumerationFacets();
                Iterator enIt = enLst.iterator();
                while (enIt.hasNext()) {
                    if (v == null) {
                        v = new Vector<String>();
                    }
                    XSDFacet facet = (XSDFacet)enIt.next();
                    v.addElement(facet.getLexicalValue());
                }
                if (v != null) {
                    Object[] s = new String[v.size()];
                    v.copyInto(s);
                    rvList = new VocabularyList("$schema$", (String[])s);
                }
            }
        } else if (((XSDComplexTypeDefinition)xmlType).getContentTypeCategory().equals(XSDContentTypeCategory.SIMPLE_LITERAL) && (ctd = (XSDComplexTypeDefinition)xmlType).getBaseTypeDefinition() instanceof XSDSimpleTypeDefinition) {
            XSDSimpleTypeDefinition base = (XSDSimpleTypeDefinition)ctd.getBaseTypeDefinition();
            EList lst = base.getMemberTypeDefinitions();
            for (XSDSimpleTypeDefinition element : lst) {
                EList enLst = element.getEnumerationFacets();
                Iterator enIt = enLst.iterator();
                while (enIt.hasNext()) {
                    if (v == null) {
                        v = new Vector();
                    }
                    XSDFacet facet = (XSDFacet)enIt.next();
                    v.addElement(facet.getLexicalValue());
                }
            }
            if (v != null) {
                Object[] s = new String[v.size()];
                v.copyInto(s);
                rvList = new VocabularyList("$schema$", (String[])s);
                v = null;
                return rvList;
            }
        }
        return rvList;
    }

    public String getTypeName() {
        return this.getXMLType().getName();
    }

    public String getBaseTypeName() {
        XSDTypeDefinition xmlType = this.getXMLType();
        XSDTypeDefinition baseType = xmlType.getBaseType();
        return baseType == null ? xmlType.getName() : baseType.getName();
    }

    public String getAtomicBaseTypeName() {
        String typeName = null;
        XSDTypeDefinition xmlType = this.getXMLType();
        if (xmlType != null) {
            typeName = xmlType.getRootType().getName();
            return typeName == null ? xmlType.getName() : typeName;
        }
        return "Unknown AtomicBaseType";
    }

    public boolean isValue() {
        String baseTypeName = this.getAtomicBaseTypeName();
        if (baseTypeName == null) {
            return false;
        }
        return baseTypeName.equals("string") || baseTypeName.equals("int") || baseTypeName.equals("integer") || baseTypeName.equals("decimal") || baseTypeName.equals("date") || baseTypeName.equals("anyURI");
    }

    public boolean isStringType() {
        String baseTypeName = this.getAtomicBaseTypeName();
        return baseTypeName != null && baseTypeName.equals("string");
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public String getDefaultValue() {
        return this.xsdElementDecl.getLexicalValue();
    }

    protected XSDTypeDefinition getXMLType() {
        if (this.xsdElementDecl.getTypeDefinition() != null) {
            return this.xsdElementDecl.getTypeDefinition();
        }
        Object obj = this.getSchemaModel().getElementDecTbl().get(this.getQName());
        if (obj != null) {
            return ((XSDElementDeclaration)obj).getType();
        }
        System.err.println("element type not found ");
        return null;
    }

    public boolean isComplexType() {
        if (!(this.getXMLType() instanceof XSDComplexTypeDefinition)) {
            return false;
        }
        XSDComplexTypeDefinition ctd = (XSDComplexTypeDefinition)this.getXMLType();
        XSDContentTypeCategory contCat = ctd.getContentTypeCategory();
        return !contCat.equals(XSDContentTypeCategory.SIMPLE_LITERAL);
    }

    public boolean isValueType() {
        if (!(this.getXMLType() instanceof XSDComplexTypeDefinition)) {
            return true;
        }
        XSDComplexTypeDefinition ctd = (XSDComplexTypeDefinition)this.getXMLType();
        XSDContentTypeCategory contCat = ctd.getContentTypeCategory();
        return contCat.equals(XSDContentTypeCategory.SIMPLE_LITERAL);
    }

    public boolean isEmptyType() {
        if (this.hasChildren() || !(this.getXMLType() instanceof XSDComplexTypeDefinition)) {
            return false;
        }
        XSDComplexTypeDefinition ctd = (XSDComplexTypeDefinition)this.getXMLType();
        XSDContentTypeCategory contCat = ctd.getContentTypeCategory();
        return contCat.equals(XSDContentTypeCategory.EMPTY_LITERAL);
    }

    public boolean isMixedType() {
        if (!(this.getXMLType() instanceof XSDComplexTypeDefinition)) {
            return false;
        }
        XSDComplexTypeDefinition ctd = (XSDComplexTypeDefinition)this.getXMLType();
        XSDContentTypeCategory contCat = ctd.getContentTypeCategory();
        return contCat.equals(XSDContentTypeCategory.MIXED_LITERAL);
    }

    public boolean isChoiceElement() {
        if (this.getXsdMGRef() == null) {
            return false;
        }
        return "choice".equals(this.getXsdMGRef().getCompositor().getName());
    }

    public boolean isSequenceElement() {
        if (this.getXsdMGRef() == null) {
            return false;
        }
        return "sequence".equals(this.getXsdMGRef().getCompositor().getName());
    }

    public String getOrderType() {
        if (this.getXsdMGRef() != null) {
            return this.getXsdMGRef().getCompositor().getName();
        }
        return null;
    }

    public int getOrderMaxOccurs() {
        Element el = this.getXsdMGRef().getElement();
        if (el == null) {
            this.getXsdMGRef().updateElement();
            el = this.getXsdMGRef().getElement();
        }
        if (el != null) {
            String maxOccursStr = el.getAttribute("maxOccurs");
            if (maxOccursStr.equals("unbounded")) {
                return -1;
            }
            if (maxOccursStr.equals("")) {
                return 1;
            }
            return Integer.parseInt(maxOccursStr);
        }
        return 1;
    }

    public int getOrderMinOccurs() {
        Element el = this.getXsdMGRef().getElement();
        if (el == null) {
            this.getXsdMGRef().updateElement();
            el = this.getXsdMGRef().getElement();
        }
        if (el != null) {
            String minOccursStr = el.getAttribute("minOccurs");
            if (minOccursStr.equals("")) {
                return 1;
            }
            return Integer.parseInt(minOccursStr);
        }
        return 0;
    }

    public String getFacetValue(String facetName) {
        String val = null;
        XSDTypeDefinition xmlType = this.getXMLType();
        if (xmlType instanceof XSDSimpleTypeDefinition) {
            XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)xmlType;
            EList facLst = simpleType.getFacets();
            for (XSDFacet tmpFacet : facLst) {
                if (!tmpFacet.getFacetName().equals(facetName)) continue;
                return tmpFacet.getLexicalValue();
            }
        }
        return val;
    }

    public SchemaAttribute[] getSchemaAttributes() {
        if (this.attributes == null) {
            Vector v = new Vector();
            this.buildAttributes(v);
            this.attributes = new SchemaAttribute[v.size()];
            v.copyInto(this.attributes);
            Object var1_1 = null;
        }
        return this.attributes;
    }

    private void buildAttributes(Vector v) {
        XSDTypeDefinition xmlType = this.getXMLType();
        if (xmlType instanceof XSDComplexTypeDefinition) {
            EList attrLst = ((XSDComplexTypeDefinition)xmlType).getAttributeUses();
            for (XSDAttributeUse attrUse : attrLst) {
                SchemaAttribute att = new SchemaAttribute(attrUse.getAttributeDeclaration());
                XSDConstraint constr = attrUse.getConstraint();
                att.setFixed(constr.equals(XSDConstraint.FIXED_LITERAL));
                att.setParent(this);
                v.add(att);
            }
        }
    }

    public SchemaAttribute getSchemaAttribute(String attName) {
        Namespace ns;
        String nsURI = null;
        int idx = attName.indexOf(58);
        if (idx >= 0) {
            String prefix = attName.substring(0, idx);
            attName = attName.substring(idx + 1);
            nsURI = (String)this.getSchemaModel().getNSMap().get(prefix);
            ns = !prefix.equals("xml") && !prefix.equals("x") ? Namespace.getNamespace((String)prefix, (String)nsURI) : Namespace.XML_NAMESPACE;
        } else {
            ns = Namespace.NO_NAMESPACE;
        }
        return this.getSchemaAttribute(attName, ns);
    }

    public SchemaAttribute getSchemaAttribute(String attName, Namespace ns) {
        SchemaAttribute[] atts = this.getSchemaAttributes();
        for (int i = 0; i < atts.length; ++i) {
            int idx = atts[i].getName().indexOf(58);
            String localAttName = idx >= 0 ? atts[i].getName().substring(idx + 1) : atts[i].getName();
            if (!localAttName.equals(attName) || !atts[i].getNamespace().equals((Object)ns)) continue;
            return atts[i];
        }
        return null;
    }

    public SchemaAttribute getSchemaAttributeAtIndex(int index) {
        if (index >= this.getSchemaAttributes().length || index < 0) {
            return null;
        }
        return this.getSchemaAttributes()[index];
    }

    public boolean hasSchemaAttributes() {
        return this.getSchemaAttributes().length > 0;
    }

    public boolean hasSchemaAttribute(String attName) {
        if (this.hasSchemaAttributes()) {
            return this.indexofSchemaAttribute(attName, Namespace.NO_NAMESPACE) != -1;
        }
        return false;
    }

    public boolean hasSchemaAttribute(String attName, Namespace ns) {
        if (this.hasSchemaAttributes()) {
            return this.indexofSchemaAttribute(attName, ns) != -1;
        }
        return false;
    }

    public int indexofSchemaAttribute(SchemaAttribute att) {
        if (att == null) {
            return -1;
        }
        return this.indexofSchemaAttribute(att.getName(), att.getNamespace());
    }

    public int indexofSchemaAttribute(String attName) {
        return this.indexofSchemaAttribute(attName, Namespace.NO_NAMESPACE);
    }

    public int indexofSchemaAttribute(String attName, Namespace ns) {
        if (attName == null) {
            return -1;
        }
        SchemaAttribute[] atts = this.getSchemaAttributes();
        for (int i = 0; i < atts.length; ++i) {
            if (!atts[i].getName().equals(attName) || !atts[i].getNamespace().equals((Object)ns)) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return this.getName();
    }

    public SchemaElement[] getChildren() {
        return this.buildChildren();
    }

    public SchemaElement[] getChildren(Namespace ns) {
        Vector<SchemaElement> v = new Vector<SchemaElement>();
        SchemaElement[] childElements = this.getChildren();
        for (int i = 0; i < childElements.length; ++i) {
            if (!childElements[i].getNamespace().equals((Object)ns)) continue;
            v.add(childElements[i]);
        }
        Object[] elements = new SchemaElement[v.size()];
        v.copyInto(elements);
        v = null;
        return elements;
    }

    public int getChildCount() {
        return this.getChildren().length;
    }

    public boolean hasChildren() {
        return this.getChildCount() > 0;
    }

    public boolean hasChild(String childName) {
        return this.getChild(childName) != null;
    }

    public SchemaElement getChild(String childName) {
        Namespace ns;
        int idx = childName.indexOf(58);
        if (idx >= 0) {
            String prefix = childName.substring(0, idx);
            childName = childName.substring(idx + 1);
            String nsURI = (String)this.getSchemaModel().getNSMap().get(prefix);
            if (nsURI == null || "".equals(nsURI)) {
                return null;
            }
            ns = Namespace.getNamespace((String)prefix, (String)nsURI);
        } else {
            String nsURI = this.xsdElementDecl.getTargetNamespace();
            ns = Namespace.getNamespace((String)"", (String)nsURI);
        }
        return this.getChild(childName, ns);
    }

    public SchemaElement getChild(String childName, Namespace ns) {
        if (ns == null || childName == null) {
            return null;
        }
        SchemaElement[] childEls = this.getChildren();
        for (int i = 0; i < childEls.length; ++i) {
            if (!childEls[i].getName().equals(childName) || !childEls[i].getNamespace().equals((Object)ns)) continue;
            return childEls[i];
        }
        return null;
    }

    public SchemaElement getChildAt(int index) {
        if (index >= this.getChildCount() || index < 0) {
            return null;
        }
        return this.getChildren()[index];
    }

    public int indexofChild(SchemaElement child) {
        if (child == null) {
            return -1;
        }
        SchemaElement[] childEls = this.getChildren();
        for (int i = 0; i < childEls.length; ++i) {
            if (childEls[i] != child) continue;
            return i;
        }
        return -1;
    }

    public int indexofChild(String childName, Namespace ns) {
        if (childName == null) {
            return -1;
        }
        SchemaElement[] childEls = this.getChildren();
        for (int i = 0; i < childEls.length; ++i) {
            if (!childEls[i].getName().equals(childName) || !childEls[i].getNamespace().equals((Object)ns)) continue;
            return i;
        }
        return -1;
    }

    public String[] getChildNames() {
        SchemaElement[] childEls = this.getChildren();
        String[] s = new String[childEls.length];
        for (int i = 0; i < childEls.length; ++i) {
            s[i] = childEls[i].getName();
        }
        return s;
    }

    protected SchemaElement[] buildChildren() {
        if (this.children == null) {
            Vector v = new Vector();
            XSDTypeDefinition xmlType = this.getXMLType();
            if (xmlType != null) {
                if (xmlType instanceof XSDComplexTypeDefinition) {
                    XSDComplexTypeDefinition ct = (XSDComplexTypeDefinition)xmlType;
                    XSDComplexTypeContent content = ct.getContentType();
                    if (content == null && xmlType.getBaseType() != null) {
                        XSDParticle cplxPartcl = xmlType.getBaseType().getComplexType();
                        if (cplxPartcl != null) {
                            this.processParticle(this, cplxPartcl, v);
                        }
                    } else if (content instanceof XSDParticle) {
                        this.processParticle(this, (XSDParticle)content, v);
                    }
                } else if (xmlType.getBaseType() instanceof XSDComplexTypeDefinition) {
                    System.err.println("buildChildren() - base type is ComplexType Structure: " + this.getName());
                    XSDParticle cplxPartcl = xmlType.getBaseType().getComplexType();
                    this.processParticle(this, cplxPartcl, v);
                }
                this.children = new SchemaElement[v.size()];
                v.copyInto(this.children);
                Object var1_1 = null;
            }
        }
        return this.children;
    }

    public void processParticle(SchemaElement schEl, XSDParticle particle, Vector v) {
        int minOccurs = 1;
        int maxOccurs = 1;
        if (particle.isSetMinOccurs()) {
            minOccurs = particle.getMinOccurs();
        }
        if (particle.isSetMaxOccurs()) {
            maxOccurs = particle.getMaxOccurs();
        }
        this.processParticle(schEl, particle, null, minOccurs, maxOccurs, v);
    }

    public void processParticle(SchemaElement schEl, XSDParticle particle, XSDModelGroup mg, int min, int max, Vector v) {
        XSDTerm content = particle.getTerm();
        if (content instanceof XSDElementDeclaration) {
            this.processElement(schEl, (XSDElementDeclaration)content, mg, particle, min, max, v);
        } else if (content instanceof XSDWildcard) {
            this.processWildCard((XSDWildcard)content, particle, min, max, v);
        } else if (content instanceof XSDModelGroup) {
            this.processModelGroup(schEl, (XSDModelGroup)content, min, max, v);
        }
    }

    public void processModelGroup(SchemaElement schEl, XSDModelGroup group, int min, int max, Vector v) {
        EList particleList = group.getParticles();
        for (XSDParticle particle : particleList) {
            if (particle.isSetMinOccurs()) {
                min = particle.getMinOccurs();
                this.childMinSet = true;
            }
            if (particle.isSetMaxOccurs()) {
                max = particle.getMaxOccurs();
                this.childMaxSet = true;
            }
            this.processParticle(schEl, particle, group, min, max, v);
        }
    }

    private void processWildCard(XSDWildcard wildcard, XSDParticle particle, int min, int max, Vector v) {
        SchemaWildcard child = new SchemaWildcard(wildcard);
        child.setParent(this);
        this.childWildCard = child;
    }

    private void processElement(SchemaElement schEl, XSDElementDeclaration declaration, XSDModelGroup mg, XSDParticle particle, int minOccurs, int maxOccurs, Vector v) {
        SchemaElement child = new SchemaElement(declaration.getResolvedElementDeclaration());
        child.setParent(this);
        if (mg != null) {
            child.xsdMGRef = mg;
        }
        if (mg.getCompositor().getName().equals("choice")) {
            String maxOccursStr;
            Element el = mg.getElement();
            String minOccursStr = el.getAttribute("minOccurs");
            if (!minOccursStr.equals("")) {
                minOccurs = Integer.parseInt(minOccursStr);
            }
            if ((maxOccursStr = el.getAttribute("maxOccurs")).equals("unbounded")) {
                maxOccurs = -1;
            } else if (!maxOccursStr.equals("")) {
                maxOccurs = Integer.parseInt(maxOccursStr);
            }
        } else if (mg.getCompositor().getName().equals("sequence") && !this.IsChoiceModelGroup()) {
            if (!particle.isSetMinOccurs() && !this.childMinSet) {
                minOccurs = 1;
            }
            if (!particle.isSetMaxOccurs() && !this.childMaxSet) {
                maxOccurs = 1;
            }
        }
        EList lst = this.xsdElementDecl.getIdentityConstraintDefinitions();
        if (lst.size() > 0) {
            for (XSDIdentityConstraintDefinition element : lst) {
                XSDXPathDefinition fld;
                String fldValue;
                if (!element.getIdentityConstraintCategory().equals(XSDIdentityConstraintCategory.UNIQUE_LITERAL)) continue;
                XSDXPathDefinition selXpath = element.getSelector();
                EList fldLst = element.getFields();
                if (selXpath == null || !selXpath.getValue().equals("*") || (fldValue = (fld = (XSDXPathDefinition)fldLst.get(0)).getValue()).indexOf("@") == -1 || child.getSchemaAttribute(fldValue = fldValue.substring(fldValue.lastIndexOf("@") + 1)) == null) continue;
                maxOccurs = 1;
            }
        }
        this.childMaxSet = false;
        this.childMinSet = false;
        child.maxOccurs = maxOccurs;
        child.minOccurs = minOccurs;
        v.add(child);
    }

    public boolean IsChoiceModelGroup() {
        XSDTypeDefinition xmlType = this.getXMLType();
        if (xmlType != null && xmlType instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition ct = (XSDComplexTypeDefinition)xmlType;
            if (ct.getContentType().getElement() == null) {
                return false;
            }
            String contentTypeNodeName = ct.getContentType().getElement().getNodeName();
            if (contentTypeNodeName.indexOf("choice") != -1) {
                return true;
            }
        }
        return false;
    }

    public boolean hasAncestor(SchemaElement schemaElement) {
        if (this.getParent() instanceof SchemaElement) {
            SchemaElement parent = (SchemaElement)this.getParent();
            return parent.getName().equals(schemaElement.getName()) && parent.getNamespace().equals((Object)schemaElement.getNamespace()) ? true : parent.hasAncestor(schemaElement);
        }
        return false;
    }

    public SchemaElement[] getSchemaElements() {
        Vector v = new Vector();
        this.__getSchemaElements(v);
        Object[] schemaElements = new SchemaElement[v.size()];
        v.copyInto(schemaElements);
        return schemaElements;
    }

    private void __getSchemaElements(Vector v) {
        v.add(0, this);
        if (this.getParent() instanceof SchemaElement) {
            ((SchemaElement)this.getParent()).__getSchemaElements(v);
        }
    }

    public XSDModelGroup getXsdMGRef() {
        return this.xsdMGRef;
    }

    public void setXsdMGRef(XSDModelGroup groupRef) {
        this.xsdMGRef = groupRef;
    }

    public boolean isResolvedWildCard() {
        return this.resolvedWildCard;
    }

    public void setResolvedWildCard(boolean resolvedWildCard) {
        this.resolvedWildCard = resolvedWildCard;
    }
}

