/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.diva.util;

import java.io.File;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceBundleManager {
    private ResourceBundle _bundle;
    private Hashtable FILE_CACHE = new Hashtable();

    public ResourceBundleManager(String baseName) {
        this._bundle = ResourceBundle.getBundle(baseName);
    }

    public ResourceBundleManager(ResourceBundle bundle) {
        this._bundle = bundle;
    }

    public ResourceBundle getResourceBundle() {
        return this._bundle;
    }

    public String getString(String key) {
        return this._bundle.getString(key);
    }

    public File getFileProperty(String key) {
        File file = (File)this.FILE_CACHE.get(key);
        if (file == null) {
            String str = null;
            try {
                str = this._bundle.getString(key);
            }
            catch (MissingResourceException ex) {
                return null;
            }
            String root = null;
            String path = null;
            int index = str.indexOf("/");
            if (index == -1) {
                root = str;
            } else {
                root = str.substring(0, index);
                path = str.substring(index);
            }
            if (root.length() > 0 && root.charAt(0) == '{' && root.charAt(root.length() - 1) == '}') {
                root = root.substring(1, root.length() - 1);
                if ((root = System.getProperty(root)) == null) {
                    root = ".";
                }
            } else {
                File f = this.getFileProperty(root);
                if (f != null) {
                    root = f.getPath();
                }
            }
            if (root != null) {
                file = path != null ? new File(root, path) : new File(root);
                this.FILE_CACHE.put(key, file);
            }
        }
        return file;
    }
}

