/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.diva.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import uk.ac.reload.diva.util.FileUtils;
import uk.ac.reload.diva.util.IProgressMonitor;

public final class ZipUtils {
    public static void addFolderToZip(File rootFolder, File srcFolder, ZipOutputStream zOut, File zipFile) throws IOException {
        ZipUtils.addFolderToZip(rootFolder, srcFolder, zOut, zipFile, null);
    }

    public static void addFolderToZip(File rootFolder, File srcFolder, ZipOutputStream zOut, File zipFile, IProgressMonitor progressMonitor) throws IOException {
        File[] files = srcFolder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (progressMonitor != null) {
                progressMonitor.setNote(files[i].getName());
                if (progressMonitor.isCanceled()) {
                    throw new IOException("User cancelled.");
                }
            }
            if (files[i].isDirectory()) {
                ZipUtils.addFolderToZip(rootFolder, files[i], zOut, zipFile, progressMonitor);
                continue;
            }
            if (files[i].equals(zipFile)) continue;
            String entryName = FileUtils.getRelativePath(rootFolder, files[i]);
            ZipUtils.addFileToZip(files[i], entryName, zOut);
        }
    }

    public static void addFilesToZip(File rootFolder, File[] filesToInclude, ZipOutputStream zOut, File zipFile) throws IOException {
        ZipUtils.addFilesToZip(rootFolder, filesToInclude, zOut, zipFile, null);
    }

    public static void addFilesToZip(File rootFolder, File[] filesToInclude, ZipOutputStream zOut, File zipFile, IProgressMonitor progressMonitor) throws IOException {
        for (int i = 0; i < filesToInclude.length; ++i) {
            if (progressMonitor != null) {
                progressMonitor.setNote(filesToInclude[i].getName());
                if (progressMonitor.isCanceled()) {
                    throw new IOException("User cancelled.");
                }
            }
            if (filesToInclude[i].equals(zipFile) || !filesToInclude[i].exists()) continue;
            String entryName = FileUtils.getRelativePath(rootFolder, filesToInclude[i]);
            ZipUtils.addFileToZip(filesToInclude[i], entryName, zOut);
        }
    }

    public static void addFileToZip(File file, String entryName, ZipOutputStream zOut) throws IOException {
        int bytesRead;
        if (file.isDirectory()) {
            return;
        }
        int bufSize = 1024;
        byte[] buf = new byte[1024];
        ZipEntry zipEntry = new ZipEntry(entryName);
        zipEntry.setTime(file.lastModified());
        try {
            zOut.putNextEntry(zipEntry);
        }
        catch (IOException ex) {
            return;
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file), 1024);
        while ((bytesRead = in.read(buf)) != -1) {
            zOut.write(buf, 0, bytesRead);
        }
        zOut.closeEntry();
        in.close();
    }

    public static void addStringToZip(String text, String entryName, ZipOutputStream zOut) throws IOException {
        int i;
        BufferedReader reader = new BufferedReader(new StringReader(text));
        ZipEntry zipEntry = new ZipEntry(entryName);
        zOut.putNextEntry(zipEntry);
        while ((i = reader.read()) != -1) {
            zOut.write(i);
        }
        zOut.closeEntry();
    }

    public static boolean hasZipEntry(File zipFile, String entryName) throws IOException {
        ZipEntry zipEntry;
        boolean foundEntry = false;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFile));
        ZipInputStream zIn = new ZipInputStream(in);
        while ((zipEntry = zIn.getNextEntry()) != null) {
            String zipEntryName = zipEntry.getName();
            if (zipEntryName.equalsIgnoreCase(entryName)) {
                foundEntry = true;
                break;
            }
            zIn.closeEntry();
        }
        zIn.close();
        return foundEntry;
    }

    public static String extractZipEntry(File zipFile, String entryName) throws IOException {
        int bit;
        ZipEntry zipEntry;
        boolean foundEntry = false;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFile));
        ZipInputStream zIn = new ZipInputStream(in);
        while ((zipEntry = zIn.getNextEntry()) != null) {
            String zipEntryName = zipEntry.getName();
            if (zipEntryName.equalsIgnoreCase(entryName)) {
                foundEntry = true;
                break;
            }
            zIn.closeEntry();
        }
        if (!foundEntry) {
            try {
                zIn.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            return null;
        }
        StringBuffer sb = new StringBuffer();
        while ((bit = zIn.read()) != -1) {
            sb.append((char)bit);
        }
        zIn.close();
        return sb.toString();
    }

    public static File extractZipEntry(File zipFile, String entryName, File outFile) throws IOException {
        int bytesRead;
        ZipEntry zipEntry;
        int bufSize = 1024;
        byte[] buf = new byte[1024];
        boolean foundEntry = false;
        if (!outFile.getParentFile().exists()) {
            outFile.getParentFile().mkdirs();
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFile), 1024);
        ZipInputStream zIn = new ZipInputStream(in);
        while ((zipEntry = zIn.getNextEntry()) != null) {
            String zipEntryName = zipEntry.getName();
            if (zipEntryName.equalsIgnoreCase(entryName)) {
                foundEntry = true;
                break;
            }
            zIn.closeEntry();
        }
        if (!foundEntry) {
            return null;
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile), 1024);
        while ((bytesRead = zIn.read(buf)) != -1) {
            out.write(buf, 0, bytesRead);
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        out.flush();
        out.close();
        zIn.close();
        outFile.setLastModified(zipEntry.getTime());
        return outFile;
    }

    public static String[] getZipFileEntryNames(File zipFile) throws IOException {
        ZipInputStream zIn = null;
        int bufSize = 1024;
        Vector<String> fileList = new Vector<String>();
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFile), 1024);
        zIn = new ZipInputStream(in);
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zIn.getNextEntry()) != null) {
                if (!zipEntry.isDirectory()) {
                    String zipEntryName = zipEntry.getName();
                    fileList.addElement(zipEntryName);
                }
                zIn.closeEntry();
            }
        }
        catch (IOException ex) {
            zIn.close();
            throw ex;
        }
        Object[] names = new String[fileList.size()];
        fileList.copyInto(names);
        Arrays.sort(names);
        return names;
    }

    public static void unpackZip(File zipFile, File targetFolder) throws IOException {
        ZipUtils.unpackZip(zipFile, targetFolder, null);
    }

    public static void unpackZip(File zipFile, File targetFolder, IProgressMonitor progressMonitor) throws IOException {
        targetFolder.mkdirs();
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        ZipInputStream zIn = null;
        int bufSize = 512;
        byte[] buf = new byte[512];
        in = new BufferedInputStream(new FileInputStream(zipFile), 512);
        zIn = new ZipInputStream(in);
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zIn.getNextEntry()) != null) {
                if (!zipEntry.isDirectory()) {
                    int bytesRead;
                    File outFile = new File(targetFolder, zipEntry.getName());
                    if (!outFile.getParentFile().exists()) {
                        outFile.getParentFile().mkdirs();
                    }
                    out = new BufferedOutputStream(new FileOutputStream(outFile), 512);
                    if (progressMonitor != null) {
                        progressMonitor.setNote(zipEntry.getName());
                    }
                    int sleep_count = 0;
                    while ((bytesRead = zIn.read(buf)) != -1) {
                        out.write(buf, 0, bytesRead);
                        if (sleep_count >= 40) {
                            try {
                                Thread.sleep(2L);
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                            }
                            sleep_count = 0;
                        }
                        ++sleep_count;
                        if (progressMonitor == null || !progressMonitor.isCanceled()) continue;
                        out.flush();
                        out.close();
                        zIn.close();
                        throw new IOException("User Cancelled");
                    }
                    outFile.setLastModified(zipEntry.getTime());
                    out.flush();
                    out.close();
                }
                zIn.closeEntry();
            }
            zIn.close();
        }
        catch (IOException ex) {
            zIn.close();
            if (out != null) {
                out.flush();
                out.close();
            }
            throw ex;
        }
    }
}

