/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.jdom;

import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import uk.ac.reload.jdom.XMLDocument;
import uk.ac.reload.jdom.XMLDocumentListener;
import uk.ac.reload.jdom.XMLDocumentListenerEvent;

public class XMLActiveDocument
extends XMLDocument {
    private Vector _listeners = new Vector();

    public XMLActiveDocument() {
    }

    public XMLActiveDocument(Document doc) {
        super(doc);
    }

    public void saveDocument() throws IOException {
        super.saveDocument();
        this.fireDocumentSaved();
    }

    public synchronized Element addElementAtIndex(Object source, Element parentElement, Element newElement, int index, boolean doSelect) {
        List children = parentElement.getChildren();
        if (index < 0 || index > children.size()) {
            index = 0;
        }
        children.add(index, newElement);
        XMLDocumentListenerEvent event = new XMLDocumentListenerEvent(source, this, newElement, doSelect);
        this.setDirty(true);
        this.fireElementAdded(event);
        return newElement;
    }

    public synchronized Element removeElement(Object source, Element element) {
        Element parent = element.getParentElement();
        if (parent != null) {
            parent.removeContent((Content)element);
            XMLDocumentListenerEvent event = new XMLDocumentListenerEvent(source, this, element, false);
            this.setDirty(true);
            this.fireElementRemoved(event);
        }
        return element;
    }

    public Element moveElementUp(Object source, Element element, boolean doSelect) {
        int index;
        List children;
        Element parent = element.getParentElement();
        if (parent != null && (children = parent.getChildren()).size() > 1 && (index = children.indexOf(element)) > 0) {
            this.removeElement(source, element);
            this.addElementAtIndex(source, parent, element, index - 1, doSelect);
        }
        return element;
    }

    public Element moveElementUpSameType(Object source, Element element, boolean doSelect) {
        if (element == null) {
            return null;
        }
        Element parent = element.getParentElement();
        if (parent != null) {
            Element prevSibling = this.getPreviousSiblingSameType(element);
            if (prevSibling != null) {
                int index = this.indexOfElement(prevSibling);
                if (index != -1) {
                    this.removeElement(source, element);
                    this.addElementAtIndex(source, parent, element, index, doSelect);
                }
            } else {
                this.moveElementUp(source, element, doSelect);
            }
        }
        return element;
    }

    public Element moveElementDown(Object source, Element element, boolean doSelect) {
        int index;
        List children;
        Element parent = element.getParentElement();
        if (parent != null && (children = parent.getChildren()).size() > 1 && (index = children.indexOf(element)) < children.size() - 1) {
            this.removeElement(source, element);
            this.addElementAtIndex(source, parent, element, index + 1, doSelect);
        }
        return element;
    }

    public Element moveElementDownSameType(Object source, Element element, boolean doSelect) {
        if (element == null) {
            return null;
        }
        Element parent = element.getParentElement();
        if (parent != null) {
            Element nextSibling = this.getNextSiblingSameType(element);
            if (nextSibling != null) {
                int index = this.indexOfElement(nextSibling);
                if (index != -1) {
                    this.removeElement(source, element);
                    this.addElementAtIndex(source, parent, element, index, doSelect);
                }
            } else {
                this.moveElementDown(source, element, doSelect);
            }
        }
        return element;
    }

    public void changedElement(Object source, Element element) {
        XMLDocumentListenerEvent event = new XMLDocumentListenerEvent(source, this, element, false);
        this.setDirty(true);
        this.fireElementChanged(event);
    }

    public boolean canCopyElement(Element element) {
        return false;
    }

    public boolean canDeleteElement(Element element) {
        return false;
    }

    public boolean canCutElement(Element element) {
        return false;
    }

    public boolean canPasteFromClipboard(Element parentElement) {
        return false;
    }

    public boolean canMoveElementUp(Element element) {
        return false;
    }

    public boolean canMoveElementDown(Element element) {
        return false;
    }

    public void destroy() {
        super.destroy();
        this._listeners.clear();
        this._listeners = null;
    }

    public synchronized void addXMLDocumentListener(XMLDocumentListener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.addElement(listener);
        }
    }

    public synchronized void removeXMLDocumentListener(XMLDocumentListener listener) {
        this._listeners.removeElement(listener);
    }

    protected void fireElementAdded(XMLDocumentListenerEvent event) {
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            XMLDocumentListener listener = (XMLDocumentListener)this._listeners.elementAt(i);
            listener.elementAdded(event);
        }
    }

    protected void fireElementRemoved(XMLDocumentListenerEvent event) {
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            XMLDocumentListener listener = (XMLDocumentListener)this._listeners.elementAt(i);
            listener.elementRemoved(event);
        }
    }

    protected void fireElementChanged(XMLDocumentListenerEvent event) {
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            XMLDocumentListener listener = (XMLDocumentListener)this._listeners.elementAt(i);
            listener.elementChanged(event);
        }
    }

    protected void fireDocumentSaved() {
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            XMLDocumentListener listener = (XMLDocumentListener)this._listeners.elementAt(i);
            listener.documentSaved(this);
        }
    }
}

