/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.jdom;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import uk.ac.reload.jdom.XMLPath;
import uk.ac.reload.jdom.XMLUtils;

public class XMLDocument {
    private Document _doc;
    private boolean _dirty;
    private File _file;

    public XMLDocument() {
    }

    public XMLDocument(Document doc) {
        this._doc = doc;
    }

    public void setDocument(Document doc) {
        this._doc = doc;
    }

    public Document getDocument() {
        return this._doc;
    }

    public void setFile(File file) {
        this._file = file;
    }

    public File getFile() {
        return this._file;
    }

    public void loadDocument(File file) throws JDOMException, IOException {
        this._file = file;
        this._doc = XMLUtils.readXMLFile(file);
        this._dirty = false;
    }

    public void saveDocument() throws IOException {
        if (this._doc != null && this._file != null) {
            XMLUtils.write2XMLFile(this._doc, this._file);
            this._dirty = false;
        }
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean isDirty) {
        this._dirty = isDirty;
    }

    public void saveAsDocument(File file) throws IOException {
        this._file = file;
        this.saveDocument();
    }

    public Element getRootElement() {
        if (this._doc != null && this._doc.hasRootElement()) {
            return this._doc.getRootElement();
        }
        return null;
    }

    public Namespace getRootNamespace() {
        Element root = this.getRootElement();
        if (root != null) {
            return root.getNamespace();
        }
        return null;
    }

    public boolean isDocumentNamespace(Element element) {
        Namespace ns = element.getNamespace();
        if (ns == null) {
            return false;
        }
        return ns.equals((Object)this.getRootNamespace());
    }

    public int indexOfElement(Element element) {
        List children;
        int index = 0;
        Element parent = element.getParentElement();
        if (parent != null && (index = (children = parent.getChildren()).indexOf(element)) == -1) {
            index = 0;
        }
        return index;
    }

    public Element getPreviousSiblingSameType(Element element) {
        Element prevSibling = element;
        while ((prevSibling = this.getPreviousSibling(prevSibling)) != null) {
            if (!element.getName().equals(prevSibling.getName()) || !element.getNamespace().equals((Object)prevSibling.getNamespace())) continue;
            return prevSibling;
        }
        return null;
    }

    public Element getPreviousSibling(Element element) {
        if (element == null) {
            return null;
        }
        Element parent = element.getParentElement();
        if (parent == null) {
            return null;
        }
        int index = this.indexOfElement(element);
        if (index < 1) {
            return null;
        }
        return (Element)parent.getChildren().get(index - 1);
    }

    public Element getNextSiblingSameType(Element element) {
        Element nextSibling = element;
        while ((nextSibling = this.getNextSibling(nextSibling)) != null) {
            if (!element.getName().equals(nextSibling.getName()) || !element.getNamespace().equals((Object)nextSibling.getNamespace())) continue;
            return nextSibling;
        }
        return null;
    }

    public Element getNextSibling(Element element) {
        if (element == null) {
            return null;
        }
        Element parent = element.getParentElement();
        if (parent == null) {
            return null;
        }
        int index = this.indexOfElement(element);
        if (index == parent.getChildren().size() - 1) {
            return null;
        }
        return (Element)parent.getChildren().get(index + 1);
    }

    public Element getElement(XMLPath xmlPath) {
        Element element = this.getDocument().getRootElement();
        String rootName = xmlPath.getRootPart();
        StringTokenizer t = xmlPath.getElements();
        while (t.hasMoreElements()) {
            Namespace ns;
            String name = t.nextToken();
            if (name.equals(rootName)) continue;
            int idx = name.indexOf(58);
            if (idx >= 0) {
                String prefix = name.substring(0, idx);
                name = name.substring(idx + 1);
                ns = element.getNamespace(prefix);
            } else {
                ns = element.getNamespace();
            }
            if ((element = element.getChild(name, ns)) != null) continue;
            return null;
        }
        return element;
    }

    public Element[] getElements(XMLPath xmlPath) {
        Element element = this.getElement(xmlPath);
        if (element == null) {
            return null;
        }
        Element parent = element.getParentElement();
        if (parent == null) {
            return new Element[]{element};
        }
        List list = element.getParentElement().getChildren(element.getName(), element.getNamespace());
        Element[] elements = new Element[list.size()];
        if (!list.isEmpty()) {
            list.toArray(elements);
        }
        return elements;
    }

    public Element getElement(Element parentElement, XMLPath xmlChildPath) {
        Element element = null;
        Namespace ns = null;
        StringTokenizer t = xmlChildPath.getElements();
        while (t.hasMoreElements()) {
            String path = t.nextToken();
            int idx = path.indexOf(58);
            if (idx >= 0) {
                String prefix = path.substring(0, idx);
                path = path.substring(idx + 1);
                ns = parentElement.getNamespace(prefix);
            } else {
                ns = parentElement.getNamespace();
            }
            element = parentElement.getChild(path, ns);
            if (element == null) {
                return null;
            }
            parentElement = element;
        }
        return element;
    }

    public void destroy() {
        this._doc = null;
    }
}

