/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.jdom;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public final class XMLUtils {
    public static Namespace XSI_Namespace = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    public static Namespace XSI_NamespaceOLD = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2000/10/XMLSchema-instance");
    public static String XSI_SchemaLocation = "schemaLocation";

    public static void write2XMLFile(Document doc, File file) throws IOException {
        Format f = Format.getPrettyFormat();
        XMLOutputter outputter = new XMLOutputter(f);
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(file);
        outputter.output(doc, (OutputStream)out);
        out.close();
    }

    public static String write2XMLString(Document doc) throws IOException {
        Format f = Format.getPrettyFormat();
        XMLOutputter outputter = new XMLOutputter(f);
        StringWriter out = new StringWriter();
        outputter.output(doc, (Writer)out);
        out.close();
        return out.toString();
    }

    public static Document readXMLFile(File file, String schemaNamespace, String schemaLocation) throws IOException, JDOMException {
        Document doc = null;
        SAXBuilder builder = new SAXBuilder(true);
        builder.setFeature("http://apache.org/xml/features/validation/schema", true);
        builder.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)(schemaNamespace + " " + schemaLocation));
        doc = builder.build((InputStream)new FileInputStream(file));
        return doc;
    }

    public static Document readXMLFile(File file) throws IOException, JDOMException {
        Document doc = null;
        SAXBuilder builder = new SAXBuilder();
        doc = builder.build((InputStream)new FileInputStream(file));
        return doc;
    }

    public static Document readXMLString(String xmlString) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        return builder.build((Reader)new StringReader(xmlString));
    }

    public static void replaceNamespaces(Element element, Namespace oldNamespace, Namespace newNamespace) {
        if (element.getNamespace().equals((Object)oldNamespace)) {
            element.setNamespace(newNamespace);
        }
        for (Element child : element.getChildren()) {
            XMLUtils.replaceNamespaces(child, oldNamespace, newNamespace);
        }
    }

    public static String getSchemaLocation(Document doc, Namespace ns) {
        String namespaceURI;
        if (doc.hasRootElement() && ns != null && (namespaceURI = ns.getURI()) != null) {
            int index;
            Element root = doc.getRootElement();
            String str = root.getAttributeValue(XSI_SchemaLocation, XSI_Namespace);
            if (str == null) {
                str = root.getAttributeValue(XSI_SchemaLocation, XSI_NamespaceOLD);
            }
            if (str != null && (index = str.indexOf(namespaceURI)) != -1) {
                str = str.substring(index + namespaceURI.length());
                StringTokenizer t = new StringTokenizer(str, " ");
                try {
                    return t.nextToken();
                }
                catch (NoSuchElementException ex) {
                    return null;
                }
            }
        }
        return null;
    }

    public static Namespace getDocumentNamespace(Document doc) {
        Namespace ns = null;
        if (doc.hasRootElement()) {
            ns = doc.getRootElement().getNamespace();
        }
        return ns;
    }

    public static Namespace getDocumentNamespace(Document doc, String prefix) {
        Namespace ns = null;
        if (doc.hasRootElement()) {
            ns = doc.getRootElement().getNamespace(prefix);
        }
        return ns;
    }

    public static boolean containsNamespace(Document doc, Namespace ns) {
        return XMLUtils.containsNamespace(doc.getRootElement(), ns);
    }

    public static boolean containsNamespace(Element element, Namespace ns) {
        if (ns.equals((Object)element.getNamespace())) {
            return true;
        }
        for (Namespace ns1 : element.getAdditionalNamespaces()) {
            if (!ns1.equals((Object)ns)) continue;
            return true;
        }
        for (Element child : element.getChildren()) {
            boolean found = XMLUtils.containsNamespace(child, ns);
            if (!found) continue;
            return true;
        }
        return false;
    }

    public static boolean isMemberOfSameDocument(Element element1, Element element2) {
        Document doc1 = element1.getDocument();
        Document doc2 = element2.getDocument();
        if (doc1 == null || doc2 == null) {
            return false;
        }
        return doc1.equals((Object)doc2);
    }
}

