/*
 * Decompiled with CFR 0.152.
 */
package com.brunchboy.util.swing.relativelayout;

import com.brunchboy.util.swing.relativelayout.Attribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DependencyManager {
    public static final String VERSION = "$Id: DependencyManager.java,v 1.1 2006/05/17 05:35:23 rp_cherian Exp $";
    private Map nodes = new HashMap();
    public static final String ROOT_NAME = "_container";
    private boolean valid = false;
    private List roots;
    private List sortedNodes;

    private Node getNode(Attribute attribute) {
        Node node = (Node)this.nodes.get(attribute);
        if (node == null) {
            node = new Node(attribute);
            this.nodes.put(attribute, node);
        }
        return node;
    }

    private void invalidate() {
        this.valid = false;
        this.sortedNodes = null;
        this.roots = null;
    }

    public void add(Attribute dependent, Attribute anchor) throws IllegalStateException {
        Node anchorNode = this.getNode(anchor);
        this.getNode(dependent);
        if (anchorNode.hasDependent(dependent)) {
            throw new IllegalStateException(dependent + " already dependent on " + anchor);
        }
        anchorNode.addDependent(dependent);
    }

    private void resetNodes() {
        for (Node node : this.nodes.values()) {
            node.refCount = 0;
        }
    }

    private List getRootNodes() {
        this.resetNodes();
        for (Node anchorNode : this.nodes.values()) {
            for (int i = 0; i < anchorNode.size(); ++i) {
                Attribute dependentAttribute = anchorNode.getDependent(i);
                if (dependentAttribute.equals(anchorNode.attribute)) {
                    throw new IllegalStateException(anchorNode + " depends on itself");
                }
                ++((Node)this.nodes.get((Object)dependentAttribute)).refCount;
            }
        }
        ArrayList<Node> roots = new ArrayList<Node>();
        for (Node candidate : this.nodes.values()) {
            if (candidate.refCount != 0) continue;
            roots.add(candidate);
        }
        return roots;
    }

    private void checkNodeForCycles(Node node, int depth) {
        if (++depth > this.nodes.size()) {
            throw new IllegalStateException("Cycle detected for attribute " + node.attribute);
        }
        for (int i = 0; i < node.size(); ++i) {
            Attribute dependentAttribute = node.getDependent(i);
            Node dependentNode = (Node)this.nodes.get(dependentAttribute);
            this.checkNodeForCycles(dependentNode, depth);
        }
    }

    public void validate() {
        this.roots = this.getRootNodes();
        for (Node aRoot : this.roots) {
            if (!aRoot.attribute.getComponent().equals(ROOT_NAME)) {
                throw new IllegalStateException("Unresolvable dependency: " + aRoot.attribute);
            }
            this.checkNodeForCycles(aRoot, 0);
        }
        this.valid = true;
    }

    public List sort() {
        if (this.sortedNodes != null) {
            return this.sortedNodes;
        }
        if (!this.valid) {
            this.validate();
        }
        ArrayList result = new ArrayList(this.nodes.size());
        for (Node aRoot : this.roots) {
            this.recursiveSort(result, aRoot);
        }
        this.sortedNodes = Collections.unmodifiableList(result);
        return this.sortedNodes;
    }

    private void recursiveSort(List sorted, Node anchorNode) {
        for (int i = 0; i < anchorNode.size(); ++i) {
            Attribute dependentAttribute = anchorNode.getDependent(i);
            Node dependentNode = (Node)this.nodes.get(dependentAttribute);
            if (--dependentNode.refCount != 0) continue;
            sorted.add(dependentAttribute);
            this.recursiveSort(sorted, dependentNode);
        }
    }

    private static class Node {
        final Attribute attribute;
        List dependents = new LinkedList();
        int refCount;

        Node(Attribute attribute) {
            this.attribute = attribute;
        }

        boolean hasDependent(Attribute dependent) {
            return this.dependents.contains(dependent);
        }

        int size() {
            return this.dependents.size();
        }

        Attribute getDependent(int index) {
            return (Attribute)this.dependents.get(index);
        }

        void addDependent(Attribute attribute) {
            this.dependents.add(attribute);
        }
    }
}

