/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class DweezilFileChooser
extends JFileChooser {
    private static File _lastFolder;

    public static File askFileNameOpen(Component parent, String title, FileFilter filter) {
        DweezilFileChooser chooser = new DweezilFileChooser();
        chooser.setDialogTitle(title);
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(parent);
        if (returnVal != 0) {
            return null;
        }
        return chooser.getSelectedFileAndStore();
    }

    public static File askFileNameSave(Component parent, String title, FileFilter filter, String extension) {
        String fileName;
        DweezilFileChooser chooser = new DweezilFileChooser();
        chooser.setDialogTitle(title);
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(parent);
        if (returnVal != 0) {
            return null;
        }
        File file = chooser.getSelectedFileAndStore();
        if (extension != null && (fileName = file.getPath()).indexOf(".") == -1) {
            file = new File(fileName + "." + extension);
        }
        return file;
    }

    public static void setDefaultFolder(File defFolder) {
        _lastFolder = defFolder;
    }

    public DweezilFileChooser() {
        this(_lastFolder);
    }

    public DweezilFileChooser(File folder) {
        super(folder);
    }

    public File getSelectedFileAndStore() {
        File file = this.getSelectedFile();
        if (file != null) {
            _lastFolder = file.getParentFile();
        }
        return file;
    }

    public File[] getSelectedFilesAndStore() {
        File[] files = this.getSelectedFiles();
        if (files != null) {
            _lastFolder = files[0].getParentFile();
        }
        return files;
    }

    public void setStoredFolder(File folder) {
        _lastFolder = folder;
    }

    public File getStoredFolder() {
        return _lastFolder;
    }
}

