/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import uk.ac.reload.diva.util.GeneralUtils;
import uk.ac.reload.dweezil.Messages;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.dweezil.util.UIUtils;

public class StatusWindow
extends JFrame {
    String CR = System.getProperty("line.separator");
    private boolean _macKludge;
    private JTextArea _editor;
    private String _appName;
    private String _appVersion;
    private String _buildDate;

    public StatusWindow(String appName, String appVersion, String buildDate, ImageIcon icon, boolean redirect, File logFolder) {
        super(appName + " - " + Messages.getString("uk.ac.reload.dweezil.gui.StatusWindow.0"));
        this._appName = appName;
        this._appVersion = appVersion;
        this._buildDate = buildDate;
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
        this.getContentPane().setLayout(new BorderLayout());
        this._editor = new JTextArea();
        this._editor.setEditable(false);
        this._editor.setCursor(DweezilUIManager.TEXT_CURSOR);
        this.getContentPane().add((Component)new JScrollPane(this._editor), "Center");
        JMenuBar menuBar = this.constructMenuBar();
        this.setJMenuBar(menuBar);
        UIUtils.centreWindow(this, 450, 400);
        this.setDefaultCloseOperation(1);
        boolean bl = this._macKludge = GeneralUtils.getOS() == 0;
        if (redirect) {
            try {
                PrintStream output = new PrintStream(new DumpStream(), true);
                PrintStream err = new PrintStream(new ErrorStream(logFolder), true);
                System.setOut(output);
                System.setErr(err);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        System.out.println(appName + " " + Messages.getString("uk.ac.reload.dweezil.gui.StatusWindow.1") + ":\t" + appVersion + " (" + buildDate + ")");
        System.out.println(Messages.getString("uk.ac.reload.dweezil.gui.StatusWindow.2") + ":\t\t" + System.getProperty("java.version"));
        System.out.println(Messages.getString("uk.ac.reload.dweezil.gui.StatusWindow.3") + ":\t\t" + GeneralUtils.getShortDate((Date)GeneralUtils.getNow()));
        System.out.println(Messages.getString("uk.ac.reload.dweezil.gui.StatusWindow.4") + ":\t\t" + System.getProperty("user.home"));
        System.out.println(Messages.getString("uk.ac.reload.dweezil.gui.StatusWindow.5") + ":\t\t" + System.getProperty("user.name"));
        System.out.println(Messages.getString("uk.ac.reload.dweezil.gui.StatusWindow.6") + ":\t\t" + System.getProperty("user.dir"));
        System.out.println();
    }

    public void showWindow() {
        this.setVisible(true);
    }

    public static void printTrace(String message) {
        boolean trace = true;
        if (trace) {
            System.out.println(message);
        }
    }

    private JMenuBar constructMenuBar() {
        JMenuBar mb = new JMenuBar();
        String menuText = Messages.getString("uk.ac.reload.dweezil.gui.StatusWindow.7");
        JMenu fileMenu = mb.add(new JMenu(MenuAction.getRemoveMnemonicText(menuText)));
        fileMenu.setMnemonic(MenuAction.getMnemonic(menuText));
        menuText = Messages.getString("uk.ac.reload.dweezil.gui.StatusWindow.8");
        JMenuItem menuItem = fileMenu.add(new JMenuItem(MenuAction.getRemoveMnemonicText(menuText)));
        menuItem.addActionListener(new Action_Clear());
        menuItem.setMnemonic(MenuAction.getMnemonic(menuText));
        menuText = Messages.getString("uk.ac.reload.dweezil.gui.StatusWindow.9");
        menuItem = fileMenu.add(new JMenuItem(MenuAction.getRemoveMnemonicText(menuText)));
        menuItem.addActionListener(new Action_Save());
        menuItem.setMnemonic(MenuAction.getMnemonic(menuText));
        menuText = Messages.getString("uk.ac.reload.dweezil.gui.StatusWindow.10");
        menuItem = fileMenu.add(new JMenuItem(MenuAction.getRemoveMnemonicText(menuText)));
        menuItem.addActionListener(new Action_GC());
        menuItem.setMnemonic(MenuAction.getMnemonic(menuText));
        return mb;
    }

    private class Action_Save
    extends AbstractAction {
        private Action_Save() {
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            int returnVal = chooser.showSaveDialog(StatusWindow.this);
            if (returnVal != 0) {
                return;
            }
            try {
                File file = chooser.getSelectedFile();
                BufferedWriter out = new BufferedWriter(new FileWriter(file));
                out.write(StatusWindow.this._editor.getText());
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                System.out.println("Status log save error " + ex);
            }
        }
    }

    private class Action_GC
    extends AbstractAction {
        private Action_GC() {
        }

        public void actionPerformed(ActionEvent e) {
            Runtime rt = Runtime.getRuntime();
            rt.gc();
            float freeMem = (float)rt.freeMemory() / 1024.0f / 1024.0f;
            System.out.println(Messages.getString("uk.ac.reload.dweezil.gui.StatusWindow.11") + ":\t\t" + freeMem + " Mb");
            float totalMem = (float)rt.totalMemory() / 1024.0f / 1024.0f;
            System.out.println(Messages.getString("uk.ac.reload.dweezil.gui.StatusWindow.12") + ":\t\t" + totalMem + " Mb");
            System.out.println();
        }
    }

    private class Action_Clear
    extends AbstractAction {
        private Action_Clear() {
        }

        public void actionPerformed(ActionEvent e) {
            StatusWindow.this._editor.setText("");
        }
    }

    private class ErrorStream
    extends DumpStream {
        File file;
        FileWriter writer;
        boolean dateWritten;
        boolean canWrite;

        public ErrorStream(File logFolder) {
            this.canWrite = true;
            this.openErrorFile(logFolder);
        }

        public void write(int b) {
            if (this.canWrite) {
                try {
                    if (!this.dateWritten) {
                        this.dateWritten = true;
                        this.writeDate();
                    }
                    this.writer.write(b);
                    this.writer.flush();
                }
                catch (IOException ex) {
                    this.canWrite = false;
                }
            }
            super.write(b);
        }

        private void openErrorFile(File logFolder) {
            String logName = StatusWindow.this._appName + ".log";
            this.file = new File(logFolder, logName);
            try {
                if (this.file.length() > 131072L) {
                    Date date = new Date();
                    File tmp = new File(logFolder + StatusWindow.this._appName + date.getTime() + ".log");
                    this.file.renameTo(tmp);
                    this.file = new File(logFolder + logName);
                }
                this.writer = new FileWriter(this.file.getPath(), true);
            }
            catch (IOException ex) {
                this.canWrite = false;
            }
        }

        private void writeDate() throws IOException {
            this.writer.write("-----------------------------------------------------------------------------" + StatusWindow.this.CR);
            this.writer.write(StatusWindow.this._appName + " " + Messages.getString("uk.ac.reload.dweezil.gui.StatusWindow.1") + ":\t" + StatusWindow.this._appVersion + " (" + StatusWindow.this._buildDate + ")" + StatusWindow.this.CR);
            this.writer.write(Messages.getString("uk.ac.reload.dweezil.gui.StatusWindow.2") + ":\t\t" + System.getProperties().getProperty("java.version") + StatusWindow.this.CR);
            this.writer.write(Messages.getString("uk.ac.reload.dweezil.gui.StatusWindow.3") + ":\t\t" + GeneralUtils.getShortDate((Date)GeneralUtils.getNow()) + StatusWindow.this.CR);
            this.writer.write("-----------------------------------------------------------------------------" + StatusWindow.this.CR);
            this.writer.write(StatusWindow.this.CR);
            this.writer.flush();
        }
    }

    private class DumpStream
    extends OutputStream {
        String s;

        public void write(int b) {
            this.s = String.valueOf((char)(b & 0xFF));
            if (StatusWindow.this._macKludge && (this.s.equals(StatusWindow.this.CR) || this.s.equals("\r"))) {
                StatusWindow.this._editor.append("\r\n");
            } else {
                StatusWindow.this._editor.append(this.s);
            }
            StatusWindow.this._editor.setCaretPosition(StatusWindow.this._editor.getText().length());
        }
    }
}

