/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;
import uk.ac.reload.dweezil.gui.layout.XYConstraints;

public class XYLayout
implements Serializable,
LayoutManager2 {
    static final XYConstraints defaultConstraints = new XYConstraints();
    Hashtable info = new Hashtable();
    int height;
    int width;
    private static final long serialVersionUID = 201L;

    public XYLayout(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public XYLayout() {
    }

    Dimension getLayoutSize(Container container, boolean flag) {
        Dimension dimension = new Dimension(0, 0);
        if (this.width <= 0 || this.height <= 0) {
            int i = container.getComponentCount();
            for (int j = 0; j < i; ++j) {
                Component component = container.getComponent(j);
                if (!component.isVisible()) continue;
                Rectangle rectangle = this.getComponentBounds(component, flag);
                dimension.width = Math.max(dimension.width, rectangle.x + rectangle.width);
                dimension.height = Math.max(dimension.height, rectangle.y + rectangle.height);
            }
        }
        if (this.width > 0) {
            dimension.width = this.width;
        }
        if (this.height > 0) {
            dimension.height = this.height;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    Rectangle getComponentBounds(Component component, boolean flag) {
        XYConstraints xyConstraints = (XYConstraints)this.info.get(component);
        if (xyConstraints == null) {
            xyConstraints = defaultConstraints;
        }
        Rectangle rectangle = new Rectangle(xyConstraints.x, xyConstraints.y, xyConstraints.width, xyConstraints.height);
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            Dimension dimension;
            Dimension dimension2 = dimension = flag ? component.getPreferredSize() : component.getMinimumSize();
            if (rectangle.width <= 0) {
                rectangle.width = dimension.width;
            }
            if (rectangle.height <= 0) {
                rectangle.height = dimension.height;
            }
        }
        return rectangle;
    }

    public void invalidateLayout(Container container) {
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void addLayoutComponent(Component component, Object obj) {
        if (obj instanceof XYConstraints) {
            this.info.put(component, obj);
        }
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int i = container.getComponentCount();
        for (int j = 0; j < i; ++j) {
            Component component = container.getComponent(j);
            if (!component.isVisible()) continue;
            Rectangle rectangle = this.getComponentBounds(component, true);
            component.setBounds(insets.left + rectangle.x, insets.top + rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(container, false);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(container, true);
    }

    public void removeLayoutComponent(Component component) {
        this.info.remove(component);
    }

    public void addLayoutComponent(String s, Component component) {
    }

    public String toString() {
        return "XYLayout [" + this.width + ", " + this.height + "]";
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }
}

