/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.menu;

import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import uk.ac.reload.dweezil.menu.DweezilMenuEvent;
import uk.ac.reload.dweezil.menu.MenuActionListener;
import uk.ac.reload.dweezil.util.DweezilUIManager;

public class MenuAction
extends AbstractAction {
    private Icon _icon;
    private String _menuText;
    private char _mnemonic;
    private JButton _button;
    private Vector listeners;

    public MenuAction() {
        this("", (String)null);
    }

    public MenuAction(String text) {
        this(text, (String)null);
    }

    public MenuAction(String text, String iconPath) {
        ImageIcon icon;
        this.parseText(text);
        if (iconPath != null && (icon = DweezilUIManager.getIcon(iconPath)) != null) {
            this.setMenuIcon(icon);
        }
        this.getButton();
    }

    public char getMnemonic() {
        return this._mnemonic;
    }

    public void setMnemonic(char mnemonic) {
        this._mnemonic = mnemonic;
    }

    public void setMenuIcon(Icon icon) {
        this._icon = icon;
        this.putValue("SmallIcon", icon);
    }

    public Icon getMenuIcon() {
        return this._icon;
    }

    public void setButtonIcon(Icon icon) {
        this.getButton().setIcon(icon);
    }

    public void setButtonText(String text) {
        this.getButton().setText(text);
    }

    public void setText(String text) {
        this.parseText(text);
        this.putValue("Name", this.getText());
        this.getButton().setToolTipText(this.getText());
    }

    public String getText() {
        return this._menuText;
    }

    public void setEnabled(boolean newValue) {
        this.getButton().setEnabled(newValue);
        super.setEnabled(newValue);
    }

    public JButton getButton() {
        if (this._button == null) {
            this._button = new JButton();
            if (this._icon != null) {
                this._button.setIcon(this._icon);
            }
            this._button.setEnabled(this.isEnabled());
            this._button.addActionListener(this);
            this._button.setToolTipText(this.getText());
            this._button.setFocusPainted(false);
            this._button.setFocusable(false);
        }
        return this._button;
    }

    protected void parseText(String menuText) {
        char mnemonic = MenuAction.getMnemonic(menuText);
        if (mnemonic != '\u0000') {
            this.setMnemonic(mnemonic);
        }
        this._menuText = MenuAction.getRemoveMnemonicText(menuText);
        this.putValue("Name", this._menuText);
    }

    public static char getMnemonic(String menuText) {
        if (menuText == null) {
            return '\u0000';
        }
        int index = menuText.indexOf("&");
        if (index == -1) {
            return '\u0000';
        }
        try {
            return menuText.charAt(index + 1);
        }
        catch (IndexOutOfBoundsException ex) {
            return '\u0000';
        }
    }

    public static String getRemoveMnemonicText(String menuText) {
        if (menuText == null) {
            return null;
        }
        int index = menuText.indexOf("&");
        if (index == -1) {
            return menuText;
        }
        try {
            return menuText.substring(0, index) + menuText.substring(index + 1);
        }
        catch (IndexOutOfBoundsException ex) {
            return menuText;
        }
    }

    public synchronized void addMenuActionListener(MenuActionListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public synchronized void removeMenuActionListener(MenuActionListener listener) {
        if (this.listeners != null) {
            this.listeners.removeElement(listener);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.listeners != null) {
            DweezilMenuEvent menuEvent = new DweezilMenuEvent(this);
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                MenuActionListener listener = (MenuActionListener)this.listeners.elementAt(i);
                listener.menuActionPerformed(menuEvent);
            }
        }
    }
}

