/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.filechooser.FileFilter;
import org.jdom.Element;
import uk.ac.reload.diva.util.FileUtils;
import uk.ac.reload.diva.util.IProgressMonitor;
import uk.ac.reload.dweezil.gui.CoolBarPanel;
import uk.ac.reload.dweezil.gui.CoolBarPanelGroup;
import uk.ac.reload.dweezil.gui.DweezilComboBox;
import uk.ac.reload.dweezil.gui.DweezilFileChooser;
import uk.ac.reload.dweezil.gui.DweezilFileFilter;
import uk.ac.reload.dweezil.gui.DweezilProgressMonitor;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.gui.IComponentSelectionListener;
import uk.ac.reload.dweezil.menu.DweezilMenuEvent;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.menu.ProxyAction;
import uk.ac.reload.dweezil.menu.UndoMenuManager;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.EditorHandler;
import uk.ac.reload.editor.EditorInternalFrame;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.contentpackaging.CP_EditorHandler;
import uk.ac.reload.editor.contentpackaging.CP_Viewer;
import uk.ac.reload.editor.contentpackaging.editor.CP_NewDialog;
import uk.ac.reload.editor.contentpackaging.editor.manifestview.ManifestPanel;
import uk.ac.reload.editor.contentpackaging.editor.resourceview.CP_ResourcesPanel;
import uk.ac.reload.editor.contentpackaging.xml.ContentPackage;
import uk.ac.reload.editor.menu.MainMenu;
import uk.ac.reload.editor.properties.EditorProperties;
import uk.ac.reload.editor.scorm.xml.SCORM12_Package;
import uk.ac.reload.editor.transform.XMLConverter;
import uk.ac.reload.editor.valdn.DocValidator;
import uk.ac.reload.jdom.XMLDocument;
import uk.ac.reload.jdom.XMLDocumentListener;
import uk.ac.reload.jdom.XMLDocumentListenerEvent;
import uk.ac.reload.moonunit.ProfiledSchemaController;

public class CP_Editor
extends EditorInternalFrame
implements XMLDocumentListener,
IIcons {
    private ContentPackage _contentPackage;
    private CP_ResourcesPanel _resourcesPanel;
    private ManifestPanel _manifestPanel;
    private JSplitPane _splitPane;
    private ProxySaveHandler _saveHandler;
    private ProxySaveHandler _saveAsHandler;
    private ProxyZipHandler _zipHandler;
    private ProxyViewCPHandler _viewCPHandler;
    private ProxyExportCPPreviewHandler _exportPreviewHandler;
    private ProxyValidationHandler _validationHandler;
    private ProxySCMTValidationHandler _scmtvalidationHandler;
    private ProxyXSLTExportHandler _xslExportHandler;
    private UndoMenuManager _undoMenuManager;
    private CP_CoolBarPanel _coolBarPanel;

    public CP_Editor() {
        this.setFrameIcon("uk/ac/reload/editor/resources/images/cp.gif");
        this.setTitle(Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.0"));
        this._resourcesPanel = new CP_ResourcesPanel();
        this._manifestPanel = new ManifestPanel(this);
        this._coolBarPanel = new CP_CoolBarPanel(this._manifestPanel);
        CoolBarPanelGroup panelGroup = new CoolBarPanelGroup();
        panelGroup.addCoolBarPanel((CoolBarPanel)this._resourcesPanel);
        panelGroup.addCoolBarPanel((CoolBarPanel)this._coolBarPanel);
        this._splitPane = new JSplitPane(1);
        this._splitPane.setOneTouchExpandable(true);
        this.getContentPane().add(this._splitPane);
        this._splitPane.setLeftComponent((Component)((Object)this._resourcesPanel));
        this._splitPane.setRightComponent((Component)((Object)this._coolBarPanel));
        this.setDefaultCloseOperation(0);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        boolean ok = CP_Editor.this.checkNeedsSaving();
                        if (ok) {
                            CP_Editor.this.dispose();
                        }
                    }
                });
            }

            public void internalFrameActivated(InternalFrameEvent e) {
                CP_Editor.this.setFocusGained();
            }

            public void internalFrameDeactivated(InternalFrameEvent e) {
                CP_Editor.this.setFocusLost();
            }
        });
    }

    public CP_Editor(ContentPackage cp) {
        this();
        this._contentPackage = cp;
        this.setTitle(Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.0") + " - " + cp.getProjectName());
        this._resourcesPanel.setFileView(cp.getProjectFolder());
        this._manifestPanel.setContentPackage(cp);
        this._saveHandler = new ProxySaveHandler(MainMenu.getSharedInstance().actionSave);
        this._saveAsHandler = new ProxySaveHandler(MainMenu.getSharedInstance().actionSaveAs);
        this._zipHandler = new ProxyZipHandler();
        this._viewCPHandler = new ProxyViewCPHandler();
        this._exportPreviewHandler = new ProxyExportCPPreviewHandler();
        this._validationHandler = new ProxyValidationHandler();
        this._scmtvalidationHandler = new ProxySCMTValidationHandler((Component)((Object)this));
        this._xslExportHandler = new ProxyXSLTExportHandler();
        cp.addXMLDocumentListener(this);
        this._undoMenuManager = new UndoMenuManager((MenuAction)MainMenu.getSharedInstance().editMenu.actionUndo, (MenuAction)MainMenu.getSharedInstance().editMenu.actionRedo);
        cp.setUndoHandler(this._undoMenuManager.getUndoHandler());
        this._coolBarPanel.setDocument(cp);
        EditorHandler.getSharedInstance().registerOpenedFile(cp.getFile(), this);
    }

    public void show() {
        super.show();
        this._splitPane.setDividerLocation(0.25);
        this._manifestPanel.initView();
        this._resourcesPanel.setSelected(true);
    }

    public void exportManifest(Element manifestElement) {
        try {
            CP_NewDialog dialog = new CP_NewDialog(Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.1"));
            File targetFolder = dialog.showDialog();
            if (targetFolder == null || !targetFolder.exists()) {
                return;
            }
            boolean result = this._contentPackage.exportManifest(manifestElement, targetFolder);
            if (result) {
                JOptionPane.showMessageDialog((Component)((Object)this), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.2"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.3"), 1, null);
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.4"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.3"), 0, null);
            }
        }
        catch (Exception ex) {
            ErrorDialogBox.showWarning((Component)((Object)this), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.4"), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.5"), (Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importManifest(Element manifestElement) {
        DweezilProgressMonitor progressMonitor = null;
        try {
            FileFilter filter = new FileFilter(){

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    return file.getName().equalsIgnoreCase("imsmanifest.xml") || file.getName().toLowerCase().endsWith(".zip");
                }

                public String getDescription() {
                    return Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.6");
                }
            };
            File manifestFile = DweezilFileChooser.askFileNameOpen((Component)((Object)this), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.7"), (FileFilter)filter);
            if (manifestFile == null || !manifestFile.exists()) {
                return;
            }
            if (manifestFile.equals(this._contentPackage.getFile())) {
                JOptionPane.showMessageDialog((Component)((Object)this), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.8"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.9"), 2);
                return;
            }
            File fileBase = null;
            String base = this._contentPackage.getElementBase(manifestElement);
            fileBase = base != null ? new File(this._contentPackage.getProjectFolder(), base) : this._contentPackage.getProjectFolder();
            File targetFolder = null;
            int i = 1;
            do {
                targetFolder = new File(fileBase, "submanifest" + i);
                ++i;
            } while (targetFolder.exists());
            if (manifestFile.getName().toLowerCase().endsWith(".zip")) {
                if (!CP_EditorHandler.containsManifest(manifestFile)) {
                    JOptionPane.showMessageDialog(EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.43") + " " + "imsmanifest.xml" + " " + Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.10"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.11"), 2);
                    return;
                }
                targetFolder.mkdirs();
                progressMonitor = new DweezilProgressMonitor((Component)EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.12"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.13"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.14"), true, (Icon)DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/app16.gif"));
                manifestFile = CP_EditorHandler.unzipContentPackage(manifestFile, targetFolder, progressMonitor);
                if (manifestFile == null) {
                    progressMonitor.close();
                    return;
                }
            } else {
                progressMonitor = new DweezilProgressMonitor((Component)EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.15"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.16"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.14"), true, (Icon)DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/app16.gif"));
                targetFolder.mkdirs();
                FileUtils.copyFolder((File)manifestFile.getParentFile(), (File)targetFolder, (IProgressMonitor)progressMonitor);
            }
            this._contentPackage.importManifest(manifestFile, manifestElement, targetFolder.getName());
        }
        catch (Exception ex) {
            if (EditorProperties.getString("DEBUG").equals("true")) {
                ex.printStackTrace();
            }
            ErrorDialogBox.showWarning((Component)((Object)this), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.17"), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.18"), (Exception)ex);
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.close();
            }
            this._resourcesPanel.refreshResourceTree();
        }
    }

    protected void zipIt() {
        if (this._contentPackage != null) {
            boolean doSave = this.checkNeedsSaving();
            if (!doSave) {
                return;
            }
            this._zipHandler.setEnabled(false);
            CP_EditorHandler.zipContentPackage(this._contentPackage);
            this._zipHandler.setEnabled(true);
        }
    }

    public ContentPackage getContentPackage() {
        return this._contentPackage;
    }

    public void elementAdded(XMLDocumentListenerEvent e) {
        if (this.isSelected()) {
            this._saveHandler.setEnabled(this._contentPackage.isDirty());
        }
    }

    public void elementChanged(XMLDocumentListenerEvent e) {
        if (this.isSelected()) {
            this._saveHandler.setEnabled(this._contentPackage.isDirty());
        }
    }

    public void elementRemoved(XMLDocumentListenerEvent e) {
        if (this.isSelected()) {
            this._saveHandler.setEnabled(this._contentPackage.isDirty());
        }
    }

    public void documentSaved(XMLDocument doc) {
        if (this.isSelected()) {
            this._saveHandler.setEnabled(this._contentPackage.isDirty());
        }
    }

    private void setFocusGained() {
        if (this._contentPackage != null) {
            this._undoMenuManager.setFocusGained();
            this._manifestPanel.getManifestTree().updateMenus();
            this._zipHandler.setEnabled(true);
            this._zipHandler.addListener();
            this._viewCPHandler.setEnabled(true);
            this._viewCPHandler.addListener();
            this._exportPreviewHandler.setEnabled(true);
            this._exportPreviewHandler.addListener();
            this._saveHandler.setEnabled(this._contentPackage.isDirty());
            this._saveHandler.addListener();
            this._saveAsHandler.setEnabled(true);
            this._saveAsHandler.addListener();
            this._validationHandler.setEnabled(true);
            this._validationHandler.addListener();
            this._scmtvalidationHandler.setEnabled(true);
            this._scmtvalidationHandler.addListener();
            this._xslExportHandler.setEnabled(true);
            this._xslExportHandler.addListener();
        }
    }

    private void setFocusLost() {
        this._undoMenuManager.setFocusLost();
        this._manifestPanel.getManifestTree().clearMenus();
        this._zipHandler.clear();
        this._viewCPHandler.clear();
        this._exportPreviewHandler.clear();
        this._saveHandler.clear();
        this._saveAsHandler.clear();
        this._validationHandler.clear();
        this._scmtvalidationHandler.clear();
        this._xslExportHandler.clear();
    }

    public boolean applicationClosing() {
        return this.checkNeedsSaving();
    }

    protected boolean checkNeedsSaving() {
        boolean isOK = true;
        if (this._contentPackage != null && this._contentPackage.isDirty()) {
            String name = this._contentPackage.getProjectName();
            String msg = name != null ? name + " " + Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.23") : Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.24");
            int doSave = JOptionPane.showConfirmDialog((Component)((Object)this), msg + " " + Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.25"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.26"), 1);
            if (doSave == 0) {
                isOK = this.saveDocument();
            } else if (doSave == 2) {
                isOK = false;
            }
        }
        return isOK;
    }

    public void dispose() {
        this.cleanup();
        super.dispose();
    }

    public void cleanup() {
        if (this._saveHandler != null) {
            this._saveHandler.clear();
        }
        if (this._saveAsHandler != null) {
            this._saveAsHandler.clear();
        }
        if (this._zipHandler != null) {
            this._zipHandler.clear();
        }
        if (this._viewCPHandler != null) {
            this._viewCPHandler.clear();
        }
        if (this._exportPreviewHandler != null) {
            this._exportPreviewHandler.clear();
        }
        if (this._resourcesPanel != null) {
            this._resourcesPanel.cleanup();
        }
        if (this._contentPackage != null) {
            this._contentPackage.removeXMLDocumentListener(this);
        }
        if (this._manifestPanel != null) {
            this._manifestPanel.cleanup();
        }
        if (this._contentPackage != null) {
            this._contentPackage.destroy();
        }
        if (this._undoMenuManager != null) {
            this._undoMenuManager.cleanup();
        }
        if (this._validationHandler != null) {
            this._validationHandler.clear();
        }
        if (this._scmtvalidationHandler != null) {
            this._scmtvalidationHandler.clear();
        }
    }

    protected boolean saveDocument() {
        if (this._contentPackage.getFile() == null) {
            return this.saveDocumentAskName();
        }
        try {
            this._contentPackage.saveDocument();
        }
        catch (IOException ex) {
            ErrorDialogBox.showWarning((Component)((Object)this), (String)(Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.27") + ": "), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.28"), (Exception)ex);
            return false;
        }
        return true;
    }

    protected boolean saveDocumentAskName() {
        DweezilFileFilter filter = new DweezilFileFilter(new String[]{"xml"}, "xml files");
        File file = DweezilFileChooser.askFileNameSave((Component)((Object)this), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.28"), (FileFilter)filter, (String)"xml");
        if (file == null) {
            return false;
        }
        this.setTitle(Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.0") + " - " + file.getPath());
        try {
            this._contentPackage.saveAsDocument(file);
        }
        catch (IOException ex) {
            ErrorDialogBox.showWarning((Component)((Object)this), (String)(Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.27") + ": "), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.28"), (Exception)ex);
            return false;
        }
        EditorHandler.getSharedInstance().registerOpenedFile(this._contentPackage.getFile(), this);
        return true;
    }

    protected void saveDocumentAs() {
        DweezilProgressMonitor progressMonitor = null;
        try {
            CP_NewDialog dialog = new CP_NewDialog(Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.29"));
            File targetFolder = dialog.showDialog();
            if (targetFolder == null || !targetFolder.exists()) {
                return;
            }
            progressMonitor = new DweezilProgressMonitor((Component)EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.31"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.16"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.16"), true, (Icon)DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/app16.gif"));
            this._contentPackage.saveDocumentAs(targetFolder, (IProgressMonitor)progressMonitor);
            progressMonitor.close();
            this.setTitle(Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.0") + " - " + this._contentPackage.getProjectName());
            this._resourcesPanel.setFileView(this._contentPackage.getProjectFolder());
            this._manifestPanel.setContentPackage(this._contentPackage);
            EditorHandler.getSharedInstance().registerOpenedFile(this._contentPackage.getFile(), this);
            JOptionPane.showMessageDialog((Component)((Object)this), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.30"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.31"), 1, null);
        }
        catch (Exception ex) {
            if (progressMonitor != null) {
                progressMonitor.close();
            }
            ErrorDialogBox.showWarning((Component)((Object)this), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.32"), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.33"), (Exception)ex);
        }
    }

    public void validateIt() {
        if (this._contentPackage != null) {
            boolean doSave = this.checkNeedsSaving();
            if (!doSave) {
                return;
            }
            this._validationHandler.setEnabled(false);
            DocValidator.validateWithJava(this._contentPackage);
            this._validationHandler.setEnabled(true);
        }
    }

    private void exportIt() {
        if (this._contentPackage != null) {
            boolean doSave = this.checkNeedsSaving();
            if (!doSave) {
                return;
            }
            this._xslExportHandler.setEnabled(false);
            try {
                XMLConverter.ctExport(this);
            }
            catch (Exception ex) {
                if (EditorProperties.getString("DEBUG").equals("true")) {
                    ex.printStackTrace();
                }
                ErrorDialogBox.showWarning((Component)((Object)this), (String)Messages.getString("CP_Editor_Export.0"), (String)Messages.getString("CP_Editor_Export.1"), (Exception)ex);
            }
            this._xslExportHandler.setEnabled(true);
        }
    }

    class ProxyXSLTExportHandler
    extends ProxyAction {
        public ProxyXSLTExportHandler() {
            super((MenuAction)MainMenu.getSharedInstance().menuCRTExport);
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            Thread thread = new Thread(){

                public void run() {
                    CP_Editor.this.exportIt();
                }
            };
            if (CP_Editor.this.isSelected()) {
                thread.start();
            }
        }
    }

    class ProxySCMTValidationHandler
    extends ProxyAction {
        Component parent;
        public FileFilter scmtfilter;

        public ProxySCMTValidationHandler(Component editor) {
            super((MenuAction)MainMenu.getSharedInstance().actionSCMTValidate);
            this.scmtfilter = new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getAbsolutePath().endsWith(".scmt");
                }

                public String getDescription() {
                    return "Schematron File (.scmt)";
                }
            };
            this.parent = editor;
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            Thread thread = new Thread(){

                public void run() {
                    ProxySCMTValidationHandler.this.validateSCMTIt();
                }
            };
            if (CP_Editor.this.isSelected()) {
                thread.start();
            }
        }

        public void validateSCMTIt() {
            CP_Editor.this.saveDocument();
            String contentPath = CP_Editor.this._contentPackage.getFile().getAbsolutePath();
            File scmtFile = DweezilFileChooser.askFileNameOpen((Component)this.parent, (String)"Select Schematron rule file", (FileFilter)this.scmtfilter);
            if (scmtFile != null) {
                CP_Editor.this._scmtvalidationHandler.setEnabled(false);
                String scmtRulePath = scmtFile.getAbsolutePath();
                DocValidator.validateWithSchematron(contentPath, scmtRulePath);
                CP_Editor.this._scmtvalidationHandler.setEnabled(true);
            }
        }
    }

    class ProxyValidationHandler
    extends ProxyAction {
        public ProxyValidationHandler() {
            super((MenuAction)MainMenu.getSharedInstance().actionValidate);
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            Thread thread = new Thread(){

                public void run() {
                    CP_Editor.this.validateIt();
                }
            };
            if (CP_Editor.this.isSelected()) {
                thread.start();
            }
        }
    }

    class ProxyExportCPPreviewHandler
    extends ProxyAction {
        public ProxyExportCPPreviewHandler() {
            super((MenuAction)MainMenu.getSharedInstance().exportPreview);
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    DweezilProgressMonitor progressMonitor = null;
                    try {
                        CP_Viewer cpViewer = new CP_Viewer(CP_Editor.this._contentPackage);
                        File exportFolder = cpViewer.askExportFolder();
                        if (exportFolder == null) {
                            return;
                        }
                        if (!exportFolder.exists() || !exportFolder.isDirectory()) {
                            JOptionPane.showMessageDialog((Component)((Object)CP_Editor.this), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.36"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.37"), 2);
                            return;
                        }
                        progressMonitor = new DweezilProgressMonitor((Component)EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.38"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.16"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.16"), true, (Icon)DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/app16.gif"));
                        cpViewer.exportContentPackage(exportFolder, progressMonitor);
                    }
                    catch (IOException ex) {
                        if (EditorProperties.getString("DEBUG").equals("true")) {
                            ex.printStackTrace();
                        }
                        ErrorDialogBox.showWarning((Component)((Object)CP_Editor.this), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.39"), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.37"), (Exception)ex);
                        return;
                    }
                    finally {
                        if (progressMonitor != null) {
                            progressMonitor.close();
                        }
                    }
                    JOptionPane.showMessageDialog(EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.40"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.37"), 1);
                }
            };
            if (CP_Editor.this.isSelected()) {
                thread.start();
            }
        }
    }

    class ProxyViewCPHandler
    extends ProxyAction {
        public ProxyViewCPHandler() {
            super((MenuAction)MainMenu.getSharedInstance().actionViewCP);
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            Thread thread = new Thread(){

                public void run() {
                    try {
                        CP_Viewer cpViewer = new CP_Viewer(CP_Editor.this._contentPackage);
                        cpViewer.launch();
                    }
                    catch (Exception ex) {
                        ErrorDialogBox.showWarning((Component)((Object)CP_Editor.this), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.34"), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.35"), (Exception)ex);
                        return;
                    }
                }
            };
            if (CP_Editor.this.isSelected()) {
                thread.start();
            }
        }
    }

    class ProxyZipHandler
    extends ProxyAction {
        public ProxyZipHandler() {
            super((MenuAction)MainMenu.getSharedInstance().actionZipIt);
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            Thread thread = new Thread(){

                public void run() {
                    CP_Editor.this.zipIt();
                }
            };
            if (CP_Editor.this.isSelected()) {
                thread.start();
            }
        }
    }

    class ProxySaveHandler
    extends ProxyAction {
        public ProxySaveHandler(MenuAction menuAction) {
            super(menuAction);
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            if (CP_Editor.this.isSelected() && event.getSource() == MainMenu.getSharedInstance().actionSave) {
                CP_Editor.this.saveDocument();
            }
            if (CP_Editor.this.isSelected() && event.getSource() == MainMenu.getSharedInstance().actionSaveAs) {
                Thread thread = new Thread(){

                    public void run() {
                        CP_Editor.this.saveDocumentAs();
                    }
                };
                thread.start();
            }
        }
    }

    protected class CP_CoolBarPanel
    extends CoolBarPanel {
        private DweezilComboBox profileCombobox;

        protected CP_CoolBarPanel(final ManifestPanel manifestPanel) {
            this.setMainComponent(manifestPanel);
            this.setText(Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.0"));
            this.setIcon(DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/cp.gif"));
            this.addComponentToCoolBar(new JLabel(Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.41") + ": "));
            this.profileCombobox = new DweezilComboBox(false);
            this.addComponentToCoolBar((Component)this.profileCombobox);
            this.addComponentSelectionListener(new IComponentSelectionListener(){

                public void componentSelected(Component component) {
                    manifestPanel.getManifestTree().requestFocus();
                }
            });
        }

        public void setDocument(ContentPackage cp) {
            this.setIcon(cp instanceof SCORM12_Package ? DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/cp_scorm.gif") : DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/cp.gif"));
            Object[] profiles = ((ProfiledSchemaController)cp.getSchemaController()).getHelperProfileNames();
            this.profileCombobox.setItems(profiles);
            String profile = ((ProfiledSchemaController)cp.getSchemaController()).getHelperProfile().getProfileName();
            this.profileCombobox.setSelectedItem((Object)profile);
            this.profileCombobox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String profileName = (String)CP_CoolBarPanel.this.profileCombobox.getSelectedItem();
                    try {
                        ((ProfiledSchemaController)CP_Editor.this._contentPackage.getSchemaController()).loadHelperProfile(profileName);
                    }
                    catch (Exception ex) {
                        if (EditorProperties.getString("DEBUG").equals("true")) {
                            ex.printStackTrace();
                        }
                        ErrorDialogBox.showWarning((String)Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.41"), (String)(Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.42") + ": " + profileName), (Exception)ex);
                    }
                }
            });
        }
    }
}

