/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import uk.ac.reload.dweezil.gui.DweezilFolderChooser;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.Messages;

public class CP_NewDialog {
    private DweezilFolderChooser _chooser = new DweezilFolderChooser();
    private JComboBox _comboCP;
    private JComboBox _comboMD;
    private JPanel _accessoryPanel;

    public CP_NewDialog(String[] versionsCP, String defaultVersionCP, String[] versionsMD, String defaultVersionMD) {
        this._chooser.setDialogTitle(Messages.getString("uk.ac.reload.editor.contentpackaging.CP_NewDialog.0"));
        this.createAccessoryPanel(versionsCP, defaultVersionCP, versionsMD, defaultVersionMD);
        this._chooser.setPreferredSize(new Dimension(600, this._chooser.getPreferredSize().height));
    }

    public CP_NewDialog(String title) {
        this._chooser.setDialogTitle(title);
    }

    public File showDialog() {
        int returnVal = this._chooser.showOpenDialog((Component)EditorFrame.getInstance());
        if (returnVal != 0) {
            return null;
        }
        File file = this._chooser.getSelectedFileAndStore();
        file.mkdirs();
        if (!file.exists() || !file.isDirectory()) {
            JOptionPane.showMessageDialog(EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_NewDialog.1"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_NewDialog.2"), 2);
            return null;
        }
        File imsManifest = new File(file, "imsmanifest.xml");
        if (imsManifest.exists()) {
            JOptionPane.showMessageDialog(EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_NewDialog.3"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_NewDialog.2"), 2);
            return null;
        }
        return file;
    }

    protected JPanel getAccessoryPanel() {
        if (this._accessoryPanel == null) {
            this._accessoryPanel = new JPanel();
            this._accessoryPanel.setLayout(new BoxLayout(this._accessoryPanel, 1));
            this._chooser.setAccessory((JComponent)this._accessoryPanel);
        }
        return this._accessoryPanel;
    }

    public String getVersionMD() {
        return this._comboMD == null ? null : (String)this._comboMD.getSelectedItem();
    }

    public String getVersionCP() {
        return this._comboCP == null ? null : (String)this._comboCP.getSelectedItem();
    }

    public DweezilFolderChooser getFolderChooser() {
        return this._chooser;
    }

    protected void createAccessoryPanel(String[] versionsCP, String defaultVersionCP, String[] versionsMD, String defaultVersionMD) {
        JPanel subPanel = new JPanel();
        this.getAccessoryPanel().add(subPanel);
        subPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        GridBagLayout layout = new GridBagLayout();
        subPanel.setLayout(layout);
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.insets = new Insets(0, 0, 5, 0);
        JLabel label = new JLabel(Messages.getString("uk.ac.reload.editor.contentpackaging.CP_NewDialog.4") + ": ");
        gc.weightx = 0.8;
        gc.gridx = 0;
        gc.gridy = 0;
        subPanel.add((Component)label, gc);
        this._comboCP = new JComboBox<String>(versionsCP);
        if (defaultVersionCP != null) {
            this._comboCP.setSelectedItem(defaultVersionCP);
        }
        gc.gridx = 1;
        subPanel.add((Component)this._comboCP, gc);
        label = new JLabel(Messages.getString("uk.ac.reload.editor.contentpackaging.CP_NewDialog.5") + ": ");
        gc.weightx = 0.8;
        gc.gridx = 0;
        gc.gridy = 1;
        subPanel.add((Component)label, gc);
        this._comboMD = new JComboBox<String>(versionsMD);
        if (defaultVersionMD != null) {
            this._comboMD.setSelectedItem(defaultVersionMD);
        }
        gc.gridx = 1;
        subPanel.add((Component)this._comboMD, gc);
    }
}

