/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.datamodel;

import java.util.Vector;
import org.jdom.Element;
import uk.ac.reload.editor.datamodel.DataElement;
import uk.ac.reload.editor.datamodel.DataModel;
import uk.ac.reload.editor.datamodel.IDataComponent;
import uk.ac.reload.editor.datamodel.IDataContainer;
import uk.ac.reload.editor.datamodel.IDataModelListener;
import uk.ac.reload.jdom.XMLDocument;
import uk.ac.reload.jdom.XMLDocumentListener;
import uk.ac.reload.jdom.XMLDocumentListenerEvent;
import uk.ac.reload.jdom.XMLPath;
import uk.ac.reload.moonunit.SchemaDocument;
import uk.ac.reload.moonunit.schema.SchemaElement;

public abstract class DataComponent
implements IDataComponent,
IDataContainer,
IDataModelListener,
XMLDocumentListener {
    private DataModel _dataModel;
    private Element _element;
    protected Vector _children;
    private DataComponent _parent;
    private String _title;
    private String _description;

    protected DataComponent() {
    }

    protected DataComponent(DataModel dataModel) {
        this._dataModel = dataModel;
    }

    public void setDataModel(DataModel dataModel) {
        this._dataModel = dataModel;
    }

    public DataModel getDataModel() {
        return this._dataModel;
    }

    public Element getElement() {
        return this._element;
    }

    public void setElement(Element element) {
        this._element = element;
    }

    public DataComponent getParent() {
        return this._parent;
    }

    public void setParent(DataComponent parent) {
        this._parent = parent;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getDefaultTitle() {
        return "Title";
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public XMLPath getXMLPath() {
        return null;
    }

    public String toString() {
        return this.getTitle();
    }

    public DataElement getDataElement() {
        return new DataElement(this.getDataModel(), this.getElement());
    }

    public DataComponent addChildElement(String elementName, String title) {
        return null;
    }

    protected Element addChildElement(Element parentElement, String elementName) {
        Element element = null;
        SchemaDocument schemaDocument = this.getDataModel().getSchemaDocument();
        XMLPath xmlPath = XMLPath.getXMLPathForElement((Element)parentElement);
        xmlPath.appendElementName(elementName);
        SchemaElement schemaElement = (SchemaElement)schemaDocument.getSchemaController().getSchemaNode(xmlPath);
        if (schemaElement != null) {
            element = schemaDocument.addElementBySchema((Object)this, parentElement, schemaElement, true);
        } else {
            System.out.println("Could not get SchemaElement for: " + xmlPath);
        }
        return element;
    }

    public void delete() {
        Element element = this.getElement();
        if (element != null) {
            this.getDataModel().getSchemaDocument().removeElement((Object)this, element);
        }
        if (this.getParent() != null) {
            this.getParent().removeChild(this);
        }
        this.getDataModel().fireDataComponentRemoved(this);
        this.getDataModel().removeIDataModelListener(this);
        this.getDataModel().getSchemaDocument().removeXMLDocumentListener((XMLDocumentListener)this);
    }

    public boolean canDelete() {
        return true;
    }

    public boolean canMoveUp() {
        if (this.getParent() == null) {
            return false;
        }
        return this.getParent().indexOf(this) > 0;
    }

    public boolean canMoveDown() {
        if (this.getParent() == null) {
            return false;
        }
        return this.getParent().indexOf(this) < this.getParent().getChildren().length - 1;
    }

    public void moveUp() {
        if (this.canMoveUp()) {
            DataComponent parent = this.getParent();
            int index = parent.indexOf(this);
            parent.removeChild(this);
            parent.addChildAt(this, index - 1);
            this.getDataModel().fireDataComponentMoved(this);
            this.moveElementUp();
        }
    }

    protected void moveElementUp() {
        SchemaDocument schemaDocument;
        Element element = this.getElement();
        if (element != null && (schemaDocument = this.getDataModel().getSchemaDocument()).canMoveElementUp(element)) {
            schemaDocument.moveElementUp((Object)this, element, true);
        }
    }

    protected void moveElementUpSameType() {
        SchemaDocument schemaDocument;
        Element element = this.getElement();
        if (element != null && (schemaDocument = this.getDataModel().getSchemaDocument()).canMoveElementUp(element)) {
            schemaDocument.moveElementUpSameType((Object)this, element, true);
        }
    }

    public void moveDown() {
        if (this.canMoveDown()) {
            DataComponent parent = this.getParent();
            int index = parent.indexOf(this);
            parent.removeChild(this);
            parent.addChildAt(this, index + 1);
            this.getDataModel().fireDataComponentMoved(this);
            this.moveElementDown();
        }
    }

    protected void moveElementDown() {
        SchemaDocument schemaDocument;
        Element element = this.getElement();
        if (element != null && (schemaDocument = this.getDataModel().getSchemaDocument()).canMoveElementDown(element)) {
            schemaDocument.moveElementDown((Object)this, element, true);
        }
    }

    protected void moveElementDownSameType() {
        SchemaDocument schemaDocument;
        Element element = this.getElement();
        if (element != null && (schemaDocument = this.getDataModel().getSchemaDocument()).canMoveElementDown(element)) {
            schemaDocument.moveElementDownSameType((Object)this, element, true);
        }
    }

    public void ensureAttribute(Element element, String attName, String defaultVal) {
        String val;
        if (element != null && ((val = element.getAttributeValue(attName)) == null || "".equals(val))) {
            element.setAttribute(attName, defaultVal);
        }
    }

    public Element ensureChildElement(Element parentElement, String elementName) {
        if (parentElement != null) {
            Element child = parentElement.getChild(elementName, parentElement.getNamespace());
            if (child == null) {
                this.addChildElement(parentElement, elementName);
            } else {
                return child;
            }
        }
        return null;
    }

    public Element getChildElementByTextValue(Element parentElement, String elementName, String text) {
        if (parentElement != null && elementName != null && text != null) {
            for (Element element : parentElement.getChildren(elementName, parentElement.getNamespace())) {
                String s = element.getText();
                if (!text.equals(s)) continue;
                return element;
            }
        }
        return null;
    }

    public void addChild(DataComponent child) {
        if (this._children == null) {
            this._children = new Vector();
        }
        if (child != null && !this._children.contains(child)) {
            this._children.add(child);
            child.setParent(this);
        }
    }

    public void addChildAt(DataComponent child, int index) {
        if (this._children == null) {
            this._children = new Vector();
        }
        if (child != null && !this._children.contains(child)) {
            this._children.add(index, child);
            child.setParent(this);
        }
    }

    public void removeChild(DataComponent child) {
        if (child != null && this._children != null) {
            this._children.remove(child);
            child.setParent(null);
        }
    }

    public void removeChildren() {
        if (this._children != null) {
            for (int i = 0; i < this._children.size(); ++i) {
                DataComponent child = (DataComponent)this._children.get(i);
                child.setParent(null);
            }
            this._children.clear();
        }
    }

    public boolean hasChildren() {
        return this._children == null ? false : !this._children.isEmpty();
    }

    public int indexOf(DataComponent child) {
        if (child != null && this._children != null) {
            return this._children.indexOf(child);
        }
        return -1;
    }

    public DataComponent getChildAt(int index) {
        if (!this.hasChildren()) {
            return null;
        }
        if (index >= this.getChildren().length) {
            return null;
        }
        return this.getChildren()[index];
    }

    public DataComponent[] getChildren() {
        if (this._children == null) {
            this._children = new Vector();
        }
        Object[] children = new DataComponent[this._children.size()];
        this._children.copyInto(children);
        return children;
    }

    public DataComponent[] getChildren(String elementName) {
        Vector<DataComponent> v = new Vector<DataComponent>();
        DataComponent[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            String name;
            Element element = children[i].getElement();
            if (element == null || !(name = element.getName()).equals(elementName)) continue;
            v.add(children[i]);
        }
        Object[] c = new DataComponent[v.size()];
        v.copyInto(c);
        return c;
    }

    public DataComponent[] getAllChildren() {
        return this.getAllChildren(null);
    }

    public DataComponent[] getAllChildren(String elementName) {
        Vector v = new Vector();
        this.__getAllChildren(v, elementName);
        Object[] c = new DataComponent[v.size()];
        v.copyInto(c);
        return c;
    }

    void __getAllChildren(Vector v, String elementName) {
        DataComponent[] children = elementName == null ? this.getChildren() : this.getChildren(elementName);
        for (int i = 0; i < children.length; ++i) {
            v.add(children[i]);
            children[i].__getAllChildren(v, elementName);
        }
    }

    public DataComponent getChildByElement(Element element) {
        if (element == null || !this.hasChildren()) {
            return null;
        }
        DataComponent[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Element boundElement = children[i].getElement();
            if (element != boundElement) continue;
            return children[i];
        }
        return null;
    }

    public DataComponent getPreviousSibling() {
        DataComponent parent = this.getParent();
        if (parent == null) {
            return null;
        }
        int index = parent.indexOf(this);
        if (index < 1) {
            return null;
        }
        return parent.getChildAt(index - 1);
    }

    public DataComponent getNextSibling() {
        DataComponent parent = this.getParent();
        if (parent == null) {
            return null;
        }
        int index = parent.indexOf(this);
        if (index == parent.getChildren().length - 1) {
            return null;
        }
        return parent.getChildAt(index + 1);
    }

    public void elementAdded(XMLDocumentListenerEvent event) {
    }

    public void elementRemoved(XMLDocumentListenerEvent event) {
    }

    public void elementChanged(XMLDocumentListenerEvent event) {
    }

    public void documentSaved(XMLDocument doc) {
    }

    public void componentAdded(DataComponent component) {
    }

    public void componentRemoved(DataComponent component) {
    }

    public void componentMoved(DataComponent component) {
    }

    public void componentChanged(DataComponent component) {
    }
}

