/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui;

import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import uk.ac.reload.dweezil.gui.tree.DweezilTree;
import uk.ac.reload.dweezil.gui.tree.DweezilTreeModel;
import uk.ac.reload.dweezil.gui.tree.DweezilTreeNode;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.DataModel;
import uk.ac.reload.editor.datamodel.IDataModelListener;
import uk.ac.reload.editor.gui.Editor_TreeNode;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;

public abstract class Editor_TreeModel
extends DweezilTreeModel
implements IDataModelListener {
    private DweezilTree _tree;
    private DataModel _dataModel;
    private boolean _doSelectNodeOnAdd = false;

    protected Editor_TreeModel() {
    }

    protected Editor_TreeModel(DweezilTree tree) {
        this._tree = tree;
    }

    public DweezilTree getTree() {
        return this._tree;
    }

    public void setDataModel(DataModel dataModel) {
        this._dataModel = dataModel;
    }

    public DataModel getDataModel() {
        return this._dataModel;
    }

    protected void buildChildren(Editor_TreeNode node) {
        LD_Component component;
        Object obj = node.getUserObject();
        if (obj instanceof DataComponent && (component = (LD_Component)obj).hasChildren()) {
            DataComponent[] children = component.getChildren();
            for (int i = 0; i < children.length; ++i) {
                Editor_TreeNode childNode = new Editor_TreeNode(children[i]);
                node.add((MutableTreeNode)((Object)childNode));
                this.buildChildren(childNode);
            }
        }
    }

    protected DefaultMutableTreeNode addNode(DefaultMutableTreeNode parentNode, DataComponent component) {
        int index = this.getInsertNodePosition(component);
        Editor_TreeNode newNode = new Editor_TreeNode(component);
        this.insertNodeInto((MutableTreeNode)((Object)newNode), parentNode, index);
        if (component.hasChildren()) {
            DataComponent[] children = component.getChildren();
            for (int i = 0; i < children.length; ++i) {
                this.addNode((DefaultMutableTreeNode)((Object)newNode), children[i]);
            }
        }
        return newNode;
    }

    protected int getInsertNodePosition(DataComponent component) {
        DataComponent parent;
        int index = 0;
        if (component.getParent() != null && (index = (parent = component.getParent()).indexOf(component)) == -1) {
            index = 0;
        }
        return index;
    }

    public void setSelectNodeOnAdd(boolean select) {
        this._doSelectNodeOnAdd = select;
    }

    public boolean doSetSelectNodeOnAdd() {
        return this._doSelectNodeOnAdd;
    }

    public void cleanup() {
        if (this._dataModel != null) {
            this._dataModel.removeIDataModelListener(this);
        }
        this._dataModel = null;
    }

    public void componentAdded(DataComponent component) {
        DataComponent parentComponent;
        DweezilTreeNode parentNode;
        if (component != null && (parentNode = this._tree.getNode((Object)(parentComponent = component.getParent()))) != null) {
            DefaultMutableTreeNode childNode = this.addNode((DefaultMutableTreeNode)parentNode, component);
            if (this._doSelectNodeOnAdd) {
                this._tree.selectNode(childNode);
                this._tree.expandNode(childNode, true);
            } else {
                this._tree.setSelectionPath(null);
                this._tree.selectNode((DefaultMutableTreeNode)parentNode);
                this._tree.expandNode((DefaultMutableTreeNode)parentNode, true);
                this._tree.expandNode(childNode, true);
            }
        }
    }

    public void componentRemoved(DataComponent component) {
        DweezilTreeNode nodeToDelete;
        if (component != null && (nodeToDelete = this._tree.getNode((Object)component)) != null) {
            DefaultMutableTreeNode prevNode = null;
            if (nodeToDelete.isNodeDescendant((DefaultMutableTreeNode)this._tree.getSelectedNode()) && (prevNode = nodeToDelete.getPreviousSibling()) == null) {
                prevNode = (DefaultMutableTreeNode)nodeToDelete.getParent();
            }
            this.removeNodeFromParent((MutableTreeNode)nodeToDelete);
            if (prevNode != null) {
                this._tree.selectNode(prevNode);
            }
        }
    }

    public void componentMoved(DataComponent component) {
        DweezilTreeNode nodeToDelete;
        if (component != null && (nodeToDelete = this._tree.getNode((Object)component)) != null) {
            boolean doSelectNode = nodeToDelete == this.getTree().getSelectedNode();
            this.removeNodeFromParent((MutableTreeNode)nodeToDelete);
            DataComponent parentComponent = component.getParent();
            DweezilTreeNode parentNode = this._tree.getNode((Object)parentComponent);
            if (parentNode != null) {
                DefaultMutableTreeNode childNode = this.addNode((DefaultMutableTreeNode)parentNode, component);
                if (doSelectNode) {
                    this._tree.selectNode(childNode);
                }
            }
        }
    }

    public void componentChanged(DataComponent component) {
        DweezilTreeNode node = this._tree.getNode((Object)component);
        if (node != null) {
            SwingUtilities.invokeLater(new Runnable((DefaultMutableTreeNode)node){
                final /* synthetic */ DefaultMutableTreeNode val$node;
                {
                    this.val$node = defaultMutableTreeNode;
                }

                public void run() {
                    Editor_TreeModel.this.nodeChanged(this.val$node);
                }
            });
        }
    }
}

