/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui.schemaviewer;

import java.awt.Color;
import javax.swing.JTextPane;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.jdom.XMLPath;
import uk.ac.reload.moonunit.SchemaController;
import uk.ac.reload.moonunit.schema.SchemaAttribute;
import uk.ac.reload.moonunit.schema.SchemaElement;
import uk.ac.reload.moonunit.schema.SchemaNode;
import uk.ac.reload.moonunit.vocab.VocabularyList;

public class NodeViewer
extends JTextPane {
    private SchemaController _schemaController;

    public NodeViewer(SchemaController schemaController) {
        this.setEditable(false);
        this.setCursor(DweezilUIManager.TEXT_CURSOR);
        this._schemaController = schemaController;
        this.setBackground(Color.lightGray);
    }

    public void setElement(SchemaElement schemaElement) {
        int i;
        String CR = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        XMLPath xmlPath = schemaElement.getXMLPath();
        sb.append("Name:\t" + schemaElement.getName() + CR);
        sb.append("Friendly:\t" + this._schemaController.getElementFriendlyName(xmlPath) + CR);
        sb.append("Tip:\t" + this._schemaController.getElementTip(xmlPath) + CR);
        sb.append("Path:\t" + xmlPath.getPath() + CR);
        sb.append("Type:\t" + schemaElement.getTypeName() + CR);
        sb.append("Base:\t" + schemaElement.getBaseTypeName() + CR);
        sb.append("Atomic Base:\t" + schemaElement.getAtomicBaseTypeName() + CR);
        sb.append("Min:\t" + schemaElement.getMinOccurs() + CR);
        sb.append("Max:\t" + schemaElement.getMaxOccurs() + CR);
        sb.append("MinLength:\t" + schemaElement.getFacetValue("minLength") + CR);
        sb.append("MaxLength:\t" + schemaElement.getFacetValue("maxLength") + CR);
        sb.append("Default:\t" + this._schemaController.getDefaultValue((SchemaNode)schemaElement) + CR);
        VocabularyList rvList = this._schemaController.getVocabularyList((SchemaNode)schemaElement);
        if (rvList != null) {
            String[] vocab = rvList.getList();
            sb.append("Vocabulary:\t");
            for (i = 0; i < vocab.length; ++i) {
                sb.append(vocab[i]);
                if (i >= vocab.length - 1) continue;
                sb.append(", ");
            }
            sb.append(CR);
        }
        if (schemaElement.isChoiceElement()) {
            sb.append(CR);
            sb.append("Is part of a Choice grouping: " + CR);
            sb.append("\tGroup Min:\t" + schemaElement.getOrderMinOccurs() + CR);
            sb.append("\tGroup Max:\t" + schemaElement.getOrderMaxOccurs() + CR);
        }
        sb.append(CR);
        if (schemaElement.hasSchemaAttributes()) {
            sb.append("Attributes" + CR);
            sb.append("----------" + CR);
            SchemaAttribute[] atts = schemaElement.getSchemaAttributes();
            for (i = 0; i < atts.length; ++i) {
                SchemaAttribute schemaAttribute = atts[i];
                xmlPath = schemaAttribute.getXMLPath();
                sb.append("Name:\t" + schemaAttribute.getName() + CR);
                sb.append("Friendly:\t" + this._schemaController.getElementFriendlyName(xmlPath) + CR);
                sb.append("Tip:\t" + this._schemaController.getElementTip(xmlPath) + CR);
                sb.append("Path:\t" + xmlPath.getPath() + CR);
                sb.append("Type:\t" + schemaAttribute.getTypeName() + CR);
                sb.append("Base:\t" + schemaAttribute.getBaseTypeName() + CR);
                sb.append("Atomic Base:\t" + schemaAttribute.getAtomicBaseTypeName() + CR);
                sb.append("Use:\t" + schemaAttribute.getUse() + CR);
                sb.append("MinLength:\t" + schemaAttribute.getMinLength() + CR);
                sb.append("MaxLength:\t" + schemaAttribute.getMaxLength() + CR);
                sb.append("Default:\t" + this._schemaController.getDefaultValue((SchemaNode)schemaAttribute) + CR);
                rvList = this._schemaController.getVocabularyList((SchemaNode)schemaAttribute);
                if (rvList != null) {
                    String[] vocab = rvList.getList();
                    sb.append("Vocabulary:\t");
                    for (int j = 0; j < vocab.length; ++j) {
                        sb.append(vocab[j]);
                        if (j >= vocab.length - 1) continue;
                        sb.append(", ");
                    }
                    sb.append(CR);
                }
                sb.append(CR);
            }
        }
        this.setText(sb.toString());
        this.setCaretPosition(0);
    }
}

