/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui.widgets;

import java.util.HashSet;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;
import uk.ac.reload.editor.gui.widgets.Widget;

public class TextAreaWidget
extends JTextArea
implements Widget {
    private int _maxLength;

    public TextAreaWidget() {
        this.setTabKeyBehaviour();
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setUI();
    }

    private void setUI() {
        this.setFont(UIManager.getFont("TextField.font"));
    }

    public void updateUI() {
        super.updateUI();
        this.setUI();
    }

    protected void setTabKeyBehaviour() {
        HashSet<KeyStroke> forwardTraversalKeys = new HashSet<KeyStroke>();
        forwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 0));
        forwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 2));
        this.setFocusTraversalKeys(0, forwardTraversalKeys);
        HashSet<KeyStroke> backwardTraversalKeys = new HashSet<KeyStroke>();
        backwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 1));
        backwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 3));
        this.setFocusTraversalKeys(1, backwardTraversalKeys);
    }

    public void setTextValue(String value) {
        this.setText(value);
    }

    public void insertTextValue(String text) {
    }

    public String getTextValue() {
        return this.getText();
    }

    public void setMaxLength(int maxLength) {
        this._maxLength = maxLength;
    }

    public boolean isSingleLine() {
        return false;
    }

    public void addDocumentListener(DocumentListener dl) {
        this.getDocument().addDocumentListener(dl);
    }

    public void removeDocumentListener(DocumentListener dl) {
        this.getDocument().removeDocumentListener(dl);
    }
}

