/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.datamodel;

import java.util.List;
import org.jdom.Element;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.xml.LearningDesign;
import uk.ac.reload.jdom.XMLPath;
import uk.ac.reload.moonunit.SchemaDocument;

public class LD_Component
extends DataComponent {
    public static XMLPath XMLPATH_ROOT_LD = new XMLPath("manifest/organizations/imsld:learning-design");

    public LD_Component() {
    }

    public LD_Component(LD_DataModel ldDataModel) {
        super(ldDataModel);
    }

    public LD_DataModel getLD_DataModel() {
        return (LD_DataModel)this.getDataModel();
    }

    public String getIdentifier() {
        String id = null;
        Element element = this.getElement();
        if (element != null) {
            id = element.getAttributeValue("identifier");
        }
        return id;
    }

    public void addIdentifier() {
        Element element = this.getElement();
        if (element != null) {
            LearningDesign ld = (LearningDesign)this.getDataModel().getSchemaDocument();
            element.setAttribute("identifier", ld.generateUniqueID(element));
        }
    }

    public void setTitleElement(String title) {
        Element titleElement;
        if ("".equals(title) || title == null) {
            title = this.getDefaultTitle();
        }
        if ((titleElement = this.ensureTitleElement()) != null) {
            titleElement.setText(title);
            SchemaDocument schemaDocument = this.getDataModel().getSchemaDocument();
            if (schemaDocument != null) {
                schemaDocument.changedElement((Object)this, this.getElement());
            }
        }
        super.setTitle(title);
    }

    protected Element ensureTitleElement() {
        Element element = this.getElement();
        if (element == null) {
            return null;
        }
        Element titleElement = element.getChild("title", element.getNamespace());
        if (titleElement == null) {
            titleElement = new Element("title", element.getNamespace());
            SchemaDocument schemaDocument = this.getDataModel().getSchemaDocument();
            schemaDocument.addElement((Object)this, element, titleElement, false);
        }
        if ("".equals(titleElement.getText())) {
            String id = this.getIdentifier();
            if (id != null && !id.startsWith("LD-")) {
                titleElement.setText(id);
            } else {
                titleElement.setText(this.getDefaultTitle());
            }
        }
        super.setTitle(titleElement.getText());
        return titleElement;
    }

    public LD_Component getChildByIdentifer(String id) {
        if (id == null || "".equals(id) || !this.hasChildren()) {
            return null;
        }
        DataComponent[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            LD_Component ldComponent = (LD_Component)children[i];
            String id2 = ldComponent.getIdentifier();
            if (!id.equals(id2)) continue;
            return ldComponent;
        }
        return null;
    }

    public void addRef(LD_Component component, Element parentElement, String childElementName, String attributeRefName) {
        Element element;
        if (component == null || parentElement == null) {
            return;
        }
        if (component.getIdentifier() == null) {
            component.addIdentifier();
        }
        if ((element = this.getRefTypeElement(component.getIdentifier(), parentElement, childElementName, attributeRefName)) != null) {
            return;
        }
        element = this.addChildElement(parentElement, childElementName);
        if (element != null) {
            element.setAttribute(attributeRefName, component.getIdentifier());
            this.getDataModel().fireDataComponentChanged(this);
        }
    }

    public void removeRef(LD_Component component, Element parentElement, String childElementName, String attributeRefName) {
        if (component == null || parentElement == null) {
            return;
        }
        Element element = this.getRefTypeElement(component.getIdentifier(), parentElement, childElementName, attributeRefName);
        if (element != null) {
            SchemaDocument schemaDocument = this.getDataModel().getSchemaDocument();
            schemaDocument.removeElement((Object)this, element);
            this.getDataModel().fireDataComponentChanged(this);
        }
    }

    public void moveRefUp(LD_Component component, Element parentElement, String childElementName, String attributeRefName) {
        if (component == null || parentElement == null) {
            return;
        }
        Element element = this.getRefTypeElement(component.getIdentifier(), parentElement, childElementName, attributeRefName);
        if (element != null) {
            SchemaDocument schemaDocument = this.getDataModel().getSchemaDocument();
            if (schemaDocument.canMoveElementUp(element)) {
                schemaDocument.moveElementUp((Object)this, element, false);
            }
            this.getDataModel().fireDataComponentChanged(this);
        }
    }

    public void moveRefDown(LD_Component component, Element parentElement, String childElementName, String attributeRefName) {
        if (component == null || parentElement == null) {
            return;
        }
        Element element = this.getRefTypeElement(component.getIdentifier(), parentElement, childElementName, attributeRefName);
        if (element != null) {
            SchemaDocument schemaDocument = this.getDataModel().getSchemaDocument();
            if (schemaDocument.canMoveElementDown(element)) {
                schemaDocument.moveElementDown((Object)this, element, false);
            }
            this.getDataModel().fireDataComponentChanged(this);
        }
    }

    public Element getRefTypeElement(String identifier, Element parentElement, String childElementName, String attributeRefName) {
        if (identifier == null || parentElement == null) {
            return null;
        }
        for (Element element : parentElement.getChildren(childElementName, parentElement.getNamespace())) {
            String ref = element.getAttributeValue(attributeRefName);
            if (!identifier.equals(ref)) continue;
            return element;
        }
        return null;
    }

    public boolean ensureReferences(Element parentElement, String childElementName, String attributeRefName, LD_Component parentComponent) {
        if (parentElement == null) {
            return false;
        }
        boolean modified = false;
        List list = parentElement.getChildren(childElementName, parentElement.getNamespace());
        Object[] elements = list.toArray();
        for (int i = 0; i < elements.length; ++i) {
            Element element = (Element)elements[i];
            String ref = element.getAttributeValue(attributeRefName);
            LD_Component component = parentComponent.getChildByIdentifer(ref);
            if (component != null) continue;
            SchemaDocument schemaDocument = this.getDataModel().getSchemaDocument();
            schemaDocument.removeElement((Object)this, element);
            modified = true;
        }
        return modified;
    }
}

