/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.datamodel.components.environments;

import java.util.Vector;
import javax.swing.Icon;
import org.jdom.Element;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.IDataComponentIcon;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.MetadataType;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.EnvironmentRef_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.LearningObject_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Service_Grouping;
import uk.ac.reload.jdom.XMLPath;

public class Environment
extends LD_Component
implements IDataComponentIcon {
    public static XMLPath XMLPATH = new XMLPath(XMLPATH_ROOT_LD).appendElementName("components/environments/environment");
    static final String DESCRIPTION = "An Environment can contain any number of Learning Objects, Services and references to other Environments.";
    private LearningObject_Grouping _learningObjectGrouping;
    private EnvironmentRef_Grouping _envRefGrouping;
    private Service_Grouping _serviceGrouping;
    private MetadataType _mdType;

    public Environment() {
    }

    public Environment(LD_DataModel ldDataModel, Element element) {
        this.setDataModel(ldDataModel);
        this.setElement(element);
        this.setDescription(DESCRIPTION);
        this._learningObjectGrouping = new LearningObject_Grouping(ldDataModel, this);
        this.addChild(this._learningObjectGrouping);
        this._serviceGrouping = new Service_Grouping(ldDataModel, this);
        this.addChild(this._serviceGrouping);
        this._envRefGrouping = new EnvironmentRef_Grouping(ldDataModel, this);
        this.addChild(this._envRefGrouping);
    }

    public void setTitle(String title) {
        this.setTitleElement(title);
    }

    public void setElement(Element element) {
        super.setElement(element);
        this.ensureTitleElement();
    }

    public EnvironmentRef_Grouping getEnvironmentRef_Grouping() {
        return this._envRefGrouping;
    }

    public LearningObject_Grouping getLearningObject_Grouping() {
        return this._learningObjectGrouping;
    }

    public Service_Grouping getService_Grouping() {
        return this._serviceGrouping;
    }

    public Environment[] getAllowedEnvironmentsToReference() {
        Vector<Environment> v = new Vector<Environment>();
        if (this.getParent() != null) {
            DataComponent[] envs = this.getParent().getChildren("environment");
            for (int i = 0; i < envs.length; ++i) {
                Environment env = (Environment)envs[i];
                if (env == this || this.getEnvironmentRef_Grouping().hasEnvironmentRef(env)) continue;
                v.add(env);
            }
        }
        Object[] envs_valid = new Environment[v.size()];
        v.copyInto(envs_valid);
        return envs_valid;
    }

    public MetadataType getMetadataType() {
        if (this._mdType == null) {
            this._mdType = new MetadataType(this.getDataElement(), "Metadata", "Metadata for the Environment.");
        }
        return this._mdType;
    }

    public String getDefaultTitle() {
        return "Environment";
    }

    public Icon getIcon() {
        return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/environment.gif");
    }

    public XMLPath getXMLPath() {
        return XMLPATH;
    }
}

