/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.datamodel.method;

import java.util.Vector;
import javax.swing.Icon;
import org.jdom.Element;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.DataElement;
import uk.ac.reload.editor.datamodel.IDataComponentIcon;
import uk.ac.reload.editor.learningdesign.datamodel.ItemModelType;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.method.Play;
import uk.ac.reload.editor.learningdesign.xml.LearningDesign;
import uk.ac.reload.jdom.XMLPath;
import uk.ac.reload.moonunit.schema.SchemaElement;

public class Method
extends LD_Component
implements IDataComponentIcon {
    public static XMLPath XMLPATH = new XMLPath(XMLPATH_ROOT_LD).appendElementName("method");
    static final String TITLE = "Method";
    static final String DESCRIPTION = "This section provides information about the Method";
    static final String FEEDBACKDESCRIPTION_TITLE = "Completion Feedback Description";
    static final String FEEDBACKDESCRIPTION_DESCRIPTION = "May be used to provide additional information about the Completion of this Method.";
    private ItemModelType _feedbackdescription;

    public Method(LD_DataModel ldDataModel) {
        this.setDataModel(ldDataModel);
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        LearningDesign ld = ldDataModel.getLearningDesign();
        Element elementMethod = ld.getElement(XMLPATH);
        if (elementMethod == null) {
            SchemaElement schemaElement = (SchemaElement)ld.getSchemaController().getSchemaNode(XMLPATH);
            elementMethod = ld.addElementUniqueBySchema(this, schemaElement, false);
        }
        this.setElement(elementMethod);
        this.addChildren();
        ldDataModel.addIDataModelListener(this);
    }

    protected void addChildren() {
        for (Element child : this.getElement().getChildren("play", this.getElement().getNamespace())) {
            Play play = new Play(this.getLD_DataModel(), child);
            this.addChild(play);
        }
    }

    public DataComponent addChildElement(String elementName, String title) {
        if (!"play".equals(elementName)) {
            return null;
        }
        Play play = null;
        Element element = this.addChildElement(this.getElement(), elementName);
        if (element != null) {
            play = new Play(this.getLD_DataModel(), element);
            this.addChild(play);
            if (title != null) {
                play.setTitle(title);
            }
            this.getDataModel().fireDataComponentAdded(play);
        }
        return play;
    }

    public Play[] getPlaysCompleted() {
        Vector<LD_Component> v = new Vector<LD_Component>();
        Element elementCompleteUOL = this.getElement().getChild("complete-unit-of-learning", this.getElement().getNamespace());
        if (elementCompleteUOL != null) {
            for (Element element : elementCompleteUOL.getChildren("when-play-completed", elementCompleteUOL.getNamespace())) {
                String ref = element.getAttributeValue("ref");
                LD_Component component = this.getChildByIdentifer(ref);
                if (component == null) continue;
                v.add(component);
            }
        }
        Object[] plays = new Play[v.size()];
        v.copyInto(plays);
        return plays;
    }

    public void addPlayCompleted(Play play) {
        DataElement completeUnitOfLearning = this.getCompleteUnitOfLearningDataElement();
        Element element = completeUnitOfLearning.createElement();
        this.addRef(play, element, "when-play-completed", "ref");
    }

    public void removePlayCompleted(Play play) {
        DataElement completeUnitOfLearning = this.getCompleteUnitOfLearningDataElement();
        this.removeRef(play, completeUnitOfLearning.getElement(), "when-play-completed", "ref");
        if (this.getPlaysCompleted().length == 0) {
            completeUnitOfLearning.deleteElement();
        }
    }

    public void movePlayCompletedUp(Play play) {
        DataElement completeUnitOfLearning = this.getCompleteUnitOfLearningDataElement();
        this.moveRefUp(play, completeUnitOfLearning.getElement(), "when-play-completed", "ref");
    }

    public void movePlayCompletedDown(Play play) {
        DataElement completeUnitOfLearning = this.getCompleteUnitOfLearningDataElement();
        this.moveRefDown(play, completeUnitOfLearning.getElement(), "when-play-completed", "ref");
    }

    protected boolean ensureAllReferences() {
        DataElement completeUnitOfLearning = this.getCompleteUnitOfLearningDataElement();
        Element parent = completeUnitOfLearning.getElement();
        if (parent == null) {
            return false;
        }
        boolean modified = this.ensureReferences(parent, "when-play-completed", "ref", this);
        if (this.getPlaysCompleted().length == 0) {
            completeUnitOfLearning.deleteElement();
        }
        return modified;
    }

    public ItemModelType getFeedbackDescriptionItemModelType() {
        if (this._feedbackdescription == null) {
            DataElement dataElement = new DataElement(this.getDataModel(), this.getElement(), new XMLPath("on-completion/feedback-description"));
            this._feedbackdescription = new ItemModelType(dataElement, FEEDBACKDESCRIPTION_TITLE, FEEDBACKDESCRIPTION_DESCRIPTION);
        }
        return this._feedbackdescription;
    }

    public DataElement getCompleteUnitOfLearningDataElement() {
        return new DataElement(this.getDataModel(), this.getElement(), new XMLPath("complete-unit-of-learning"));
    }

    public DataElement getWhenPlayCompletedDataElement() {
        return new DataElement(this.getDataModel(), this.getElement(), new XMLPath("complete-unit-of-learning/when-play-completed"));
    }

    public DataElement getTimeLimitDataElement() {
        return new DataElement(this.getDataModel(), this.getElement(), new XMLPath("complete-unit-of-learning/time-limit"));
    }

    public DataElement getWhenPropertyValueSetDataElement() {
        return new DataElement(this.getDataModel(), this.getElement(), new XMLPath("complete-unit-of-learning/when-property-value-is-set"));
    }

    public boolean canDelete() {
        return false;
    }

    public boolean canMoveUp() {
        return false;
    }

    public boolean canMoveDown() {
        return false;
    }

    public Icon getIcon() {
        return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/method.gif");
    }

    public XMLPath getXMLPath() {
        return XMLPATH;
    }

    public void componentRemoved(DataComponent component) {
        boolean modified;
        if (component instanceof Play && (modified = this.ensureAllReferences())) {
            this.getDataModel().fireDataComponentChanged(this);
        }
    }
}

