/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.activities;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.Activity;
import uk.ac.reload.editor.learningdesign.editor.activities.ActivityEnvironmentSelectorTree;

public class ActivityEnvironmentSelectorDialog
extends JDialog
implements IIcons {
    private Activity _activity;
    private ActivityEnvironmentSelectorTree _selectorTree;
    private int WIDTH = 480;
    private int HEIGHT = 355;

    public ActivityEnvironmentSelectorDialog() {
        super(EditorFrame.getInstance(), "Select Environments", true);
        this.setResizable(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ActivityEnvironmentSelectorDialog.this.dispose();
            }
        });
        this._selectorTree = new ActivityEnvironmentSelectorTree();
        JScrollPane sp = new JScrollPane((Component)((Object)this._selectorTree));
        this.getContentPane().add((Component)sp, "Center");
        JPanel buttonPanel = this.createButtonPanel();
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setSize(this.WIDTH, this.HEIGHT);
        this.setLocationRelativeTo(EditorFrame.getInstance());
    }

    public ActivityEnvironmentSelectorTree getSelectorTree() {
        return this._selectorTree;
    }

    public void setActivity(Activity activity) {
        this._activity = activity;
        this._selectorTree.setActivity(activity);
        this._selectorTree.expandTree(true);
    }

    protected JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton btnOK = new JButton("OK");
        btnOK.addActionListener(new OKClick());
        this.getRootPane().setDefaultButton(btnOK);
        buttonPanel.add(btnOK);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new CancelClick());
        buttonPanel.add(btnCancel);
        return buttonPanel;
    }

    protected void finish() {
        LD_Component[] components = this._selectorTree.getSelectedComponents();
        for (int i = 0; i < components.length; ++i) {
            this._activity.addRef(components[i]);
        }
        this.dispose();
    }

    public void cleanup() {
        this._selectorTree.cleanup();
        this._activity = null;
    }

    private class CancelClick
    extends AbstractAction {
        private CancelClick() {
        }

        public void actionPerformed(ActionEvent e) {
            ActivityEnvironmentSelectorDialog.this.dispose();
        }
    }

    private class OKClick
    extends AbstractAction {
        private OKClick() {
        }

        public void actionPerformed(ActionEvent e) {
            ActivityEnvironmentSelectorDialog.this.finish();
        }
    }
}

