/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.environment;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import uk.ac.reload.dweezil.gui.ComponentHiderLabelPanel;
import uk.ac.reload.dweezil.gui.LabelComponentPanel;
import uk.ac.reload.dweezil.gui.layout.RelativeLayoutManager;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.DataElement;
import uk.ac.reload.editor.gui.widgets.DataElementComboBox;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Conference;
import uk.ac.reload.editor.learningdesign.editor.environment.ConferenceRoleTable;
import uk.ac.reload.editor.learningdesign.editor.environment.ServiceEditorPanel;
import uk.ac.reload.editor.learningdesign.editor.shared.ItemTypePanel;
import uk.ac.reload.editor.learningdesign.editor.shared.MetadataPanel;

public class ConferenceEditorPanel
extends ServiceEditorPanel {
    static final String RESOURCE_DESCRIPTION = "Reference to a Resource.";
    private DataElementComboBox _cbType;
    private ItemTypePanel _itemPanel;
    private ConferenceRoleTable _rolePicker;
    private MetadataPanel _metadataPanel;

    public void setComponent(DataComponent dataComponent) {
        super.setComponent(dataComponent);
        DataElement typeElement = dataComponent.getDataElement();
        this._cbType.setAttribute(typeElement, "conference-type", "synchronous");
        Conference conference = (Conference)dataComponent;
        this._itemPanel.setItemType(conference.getItemType());
        this._rolePicker.setConference(conference);
        this._metadataPanel.setMetadataType(conference.getMetadataType());
    }

    protected void setupView() {
        super.setupView();
        RelativeLayoutManager layoutManager = this.getRelativeLayoutManager();
        this._cbType = new DataElementComboBox(new String[]{"synchronous", "asynchronous", "announcement"});
        LabelComponentPanel panelType = new LabelComponentPanel("Type:", (JComponent)((Object)this._cbType), 0.3, 1.0);
        layoutManager.addFromLeftToRightEdges((JComponent)panelType, "panelType", "fieldPanel", 1, 5, 10);
        ComponentHiderLabelPanel hider = new ComponentHiderLabelPanel("Resource", RESOURCE_DESCRIPTION);
        layoutManager.addFromLeftToRightEdges((JComponent)hider, "hider", "panelType", 1, 15, 10);
        this._itemPanel = new ItemTypePanel();
        hider.getComponentHiderButton().setComponent((JComponent)this._itemPanel);
        hider.getComponentHiderButton().showComponent(false);
        layoutManager.addFromLeftToRightEdges((JComponent)this._itemPanel, "_itemPanel", "hider", 1, 10, 10);
        ComponentHiderLabelPanel hider2 = new ComponentHiderLabelPanel("Roles", "Add Conference Roles.");
        layoutManager.addFromLeftToRightEdges((JComponent)hider2, "hider2", "_itemPanel", 1, 15, 10);
        this._rolePicker = new ConferenceRoleTable();
        JScrollPane sp1 = new JScrollPane((Component)((Object)this._rolePicker));
        sp1.setPreferredSize(new Dimension(0, 200));
        sp1.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        JPanel panel1 = new JPanel(new BorderLayout());
        panel1.add(sp1);
        hider2.getComponentHiderButton().setComponent((JComponent)panel1);
        hider2.getComponentHiderButton().showComponent(false);
        layoutManager.addFromLeftToRightEdges((JComponent)panel1, "panel1", "hider2", 1, 5, 10);
        this._metadataPanel = new MetadataPanel();
        layoutManager.addFromLeftToRightEdges((JComponent)this._metadataPanel, "_metadataPanel", "panel1", 1, 20, 10);
    }

    public void cleanup() {
        super.cleanup();
        if (this._itemPanel != null) {
            this._itemPanel.cleanup();
        }
        if (this._rolePicker != null) {
            this._rolePicker.cleanup();
        }
        if (this._metadataPanel != null) {
            this._metadataPanel.cleanup();
        }
    }
}

