/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.environment;

import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import uk.ac.reload.dweezil.gui.FlatCheckBox;
import uk.ac.reload.dweezil.gui.treetable.DweezilTreeTable;
import uk.ac.reload.editor.datamodel.DataModel;
import uk.ac.reload.editor.gui.Editor_TreeRenderer;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Conference;
import uk.ac.reload.editor.learningdesign.editor.environment.ConferenceRoleTableModel;

public class ConferenceRoleTable
extends DweezilTreeTable {
    private DataModel _dataModel;
    private ConferenceRoleTableModel _tableModel = new ConferenceRoleTableModel(this);

    public ConferenceRoleTable() {
        this.setTreeTableModel(this._tableModel);
        this.getTableHeader().setReorderingAllowed(false);
        TableColumnModel tcm = this.getTableHeader().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(150);
        this.setSelectionMode(0);
        this.getTree().setCellRenderer(new Editor_TreeRenderer());
        this.setDefaultRenderer(Boolean.class, new BooleanRenderer());
        this.setDefaultEditor(Boolean.class, new BooleanEditor());
        this.getTree().setRootVisible(false);
        this.getTree().setToggleClickCount(0);
    }

    public void setConference(Conference conference) {
        if (this.getDataModel() == null) {
            this.setDataModel(conference.getDataModel());
        }
        this._tableModel.setConference(conference);
        this.repaint();
    }

    public void setDataModel(DataModel dataModel) {
        this._dataModel = dataModel;
    }

    public DataModel getDataModel() {
        return this._dataModel;
    }

    public void cleanup() {
        this._tableModel.cleanup();
        this._dataModel = null;
    }

    static class BooleanRenderer
    implements TableCellRenderer {
        FlatCheckBox checkbox = new FlatCheckBox(){
            {
                this.setHorizontalAlignment(0);
                this.setBorder(new LineBorder(Color.GRAY));
            }

            protected void setUI() {
                this.setOpaque(false);
                this.setBorderPaintedFlat(true);
            }
        };
        JLabel label = new JLabel();

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel component;
            if (value == null) {
                component = this.label;
            } else {
                component = this.checkbox;
                this.checkbox.setSelected(value != null && (Boolean)value != false);
            }
            if (isSelected) {
                ((Component)component).setForeground(table.getSelectionForeground());
                ((Component)component).setBackground(table.getSelectionBackground());
            } else {
                ((Component)component).setForeground(table.getForeground());
                ((Component)component).setBackground(table.getBackground());
            }
            return component;
        }
    }

    static class BooleanEditor
    extends DefaultCellEditor {
        public BooleanEditor() {
            super((JCheckBox)new FlatCheckBox());
            FlatCheckBox checkBox = (FlatCheckBox)this.getComponent();
            checkBox.setHorizontalAlignment(0);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                return null;
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }
}

