/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.environment;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import uk.ac.reload.dweezil.gui.ComponentHiderLabelPanel;
import uk.ac.reload.dweezil.gui.LabelComponentPanel;
import uk.ac.reload.dweezil.gui.layout.RelativeLayoutManager;
import uk.ac.reload.dweezil.gui.layout.SGLayout;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.DataElement;
import uk.ac.reload.editor.gui.IdentifierLabelTextField;
import uk.ac.reload.editor.gui.TitledEditorPanel;
import uk.ac.reload.editor.gui.widgets.DataElementComboBox;
import uk.ac.reload.editor.gui.widgets.DataElementTextField;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.LearningObject;
import uk.ac.reload.editor.learningdesign.editor.shared.IsVisibleParametersPanel;
import uk.ac.reload.editor.learningdesign.editor.shared.ItemTypePanel;
import uk.ac.reload.editor.learningdesign.editor.shared.MetadataPanel;

public class LearningObjectEditorPanel
extends TitledEditorPanel {
    static final String RESOURCE_DESCRIPTION = "Reference to a Resource.";
    static final boolean SHOW_IDENTIFIER = false;
    private IdentifierLabelTextField _tfIdentifier;
    private DataElementTextField _tfClass;
    private IsVisibleParametersPanel _isVisibleParametersPanel;
    private DataElementComboBox _cbType;
    private ItemTypePanel _itemPanel;
    private MetadataPanel _metadataPanel;

    protected void setupView() {
        super.setupView();
        RelativeLayoutManager layoutManager = this.getRelativeLayoutManager();
        SGLayout fieldPanelLayout = new SGLayout(3, 1, 0, 5);
        JPanel fieldPanel = new JPanel((LayoutManager)fieldPanelLayout);
        fieldPanel.setOpaque(false);
        layoutManager.addFromLeftToRightEdges((JComponent)fieldPanel, "fieldPanel", "TitledEditorPanel.TOPPANEL_ID", 1, 10, 10);
        this._tfClass = new DataElementTextField();
        LabelComponentPanel panelClass = new LabelComponentPanel("Class:", (JComponent)this._tfClass, 0.3, 0.0);
        fieldPanel.add((Component)panelClass);
        this._isVisibleParametersPanel = new IsVisibleParametersPanel();
        fieldPanel.add(this._isVisibleParametersPanel);
        this._cbType = new DataElementComboBox(new String[]{"", "knowledge-object", "tool-object", "test-object"});
        LabelComponentPanel panelType = new LabelComponentPanel("Type:", (JComponent)((Object)this._cbType), 0.3, 1.0);
        fieldPanel.add((Component)panelType);
        ComponentHiderLabelPanel hider = new ComponentHiderLabelPanel("Resource", RESOURCE_DESCRIPTION);
        layoutManager.addFromLeftToRightEdges((JComponent)hider, "hider", "fieldPanel", 1, 15, 10);
        this._itemPanel = new ItemTypePanel();
        hider.getComponentHiderButton().setComponent((JComponent)this._itemPanel);
        hider.getComponentHiderButton().showComponent(false);
        layoutManager.addFromLeftToRightEdges((JComponent)this._itemPanel, "_itemPanel", "hider", 1, 10, 10);
        this._metadataPanel = new MetadataPanel();
        layoutManager.addFromLeftToRightEdges((JComponent)this._metadataPanel, "_metadataPanel", "_itemPanel", 1, 15, 10);
    }

    public void setComponent(DataComponent dataComponent) {
        super.setComponent(dataComponent);
        DataElement loElement = dataComponent.getDataElement();
        this._tfClass.setAttribute(loElement, "class", null);
        this._isVisibleParametersPanel.getIsVisibleCheckBox().setAttribute(loElement, "isvisible", true);
        this._isVisibleParametersPanel.getParametersField().setAttribute(loElement, "parameters", null);
        this._cbType.setAttribute(loElement, "type", null);
        this._itemPanel.setItemType(((LearningObject)dataComponent).getItemType());
        this._metadataPanel.setMetadataType(((LearningObject)dataComponent).getMetadataType());
    }

    public void cleanup() {
        super.cleanup();
        if (this._itemPanel != null) {
            this._itemPanel.cleanup();
        }
        if (this._metadataPanel != null) {
            this._metadataPanel.cleanup();
        }
    }
}

