/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.method;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;
import uk.ac.reload.dweezil.gui.tree.DweezilTree;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.DataModel;
import uk.ac.reload.editor.datamodel.IDataComponentIcon;
import uk.ac.reload.editor.datamodel.IDataModelListener;
import uk.ac.reload.editor.gui.Editor_TreeModel;
import uk.ac.reload.editor.gui.Editor_TreeNode;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.Activity;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.ActivityStructure_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.LearningActivity_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.SupportActivity_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Environment;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Environments_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.method.RolePart;
import uk.ac.reload.editor.learningdesign.editor.shared.LD_SelectorTree;

public class RolePartActivitySelectorTree
extends LD_SelectorTree
implements IDataModelListener {
    private RolePart _rolePart;
    private JLabel _label;

    public RolePartActivitySelectorTree(JLabel label) {
        this.setRootVisible(false);
        this.setEditor_TreeModel(new ActivityEnvironmentTreeModel(this));
        this.setCellRenderer(new ActivitySelectorTreeTreeRenderer());
        this._label = label;
    }

    public void setRolePartComponent(RolePart rolePart) {
        this._rolePart = rolePart;
        if (this.getDataModel() == null) {
            this.setDataModel(rolePart.getDataModel());
            this.expandTree(true);
        }
        this.update();
    }

    private void update() {
        LD_Component component = this._rolePart.getReferencedComponent();
        this.setSelectedNodes(new LD_Component[]{component});
        this.updateLabel(component);
    }

    public void setDataModel(DataModel ldDataModel) {
        super.setDataModel(ldDataModel);
        ldDataModel.addIDataModelListener(this);
    }

    public void nodeSelected(Editor_TreeNode node) {
        Object o = node.getUserObject();
        if (!(o instanceof LD_Grouping)) {
            LD_Component component = (LD_Component)o;
            this._rolePart.setReferencedComponent(component);
        }
    }

    protected void updateLabel(LD_Component component) {
        if (component != null) {
            this._label.setText("<html>" + component.getTitle());
            this._label.setIcon(((IDataComponentIcon)((Object)component)).getIcon());
        } else {
            this._label.setText("(not set)");
            this._label.setIcon(null);
        }
    }

    public void cleanup() {
        if (this.getDataModel() != null) {
            this.getDataModel().removeIDataModelListener(this);
        }
        super.cleanup();
        this._rolePart = null;
    }

    public void componentAdded(DataComponent component) {
    }

    public void componentRemoved(DataComponent component) {
    }

    public void componentMoved(DataComponent component) {
    }

    public void componentChanged(DataComponent component) {
        if (component == this._rolePart) {
            this.update();
        }
    }

    class ActivitySelectorTreeTreeRenderer
    extends LD_SelectorTree.LD_SelectorTreeTreeRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof Editor_TreeNode) {
                Editor_TreeNode selNode = (Editor_TreeNode)((Object)value);
                Object obj = selNode.getUserObject();
                this.cb.setVisible(obj instanceof Activity || obj instanceof Environment);
            }
            return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
    }

    class ActivityEnvironmentTreeModel
    extends Editor_TreeModel {
        public ActivityEnvironmentTreeModel(DweezilTree tree) {
            super(tree);
            this.setSelectNodeOnAdd(false);
        }

        public void setDataModel(DataModel dataModel) {
            super.setDataModel(dataModel);
            LD_Grouping rootGroup = new LD_Grouping();
            LD_DataModel ldDataModel = (LD_DataModel)dataModel;
            LearningActivity_Grouping act1Group = ldDataModel.getActivities_Grouping().getLearningActivity_Grouping();
            rootGroup.addChild(act1Group);
            SupportActivity_Grouping act2Group = ldDataModel.getActivities_Grouping().getSupportActivity_Grouping();
            rootGroup.addChild(act2Group);
            ActivityStructure_Grouping act3Group = ldDataModel.getActivities_Grouping().getActivityStructure_Grouping();
            rootGroup.addChild(act3Group);
            Environments_Grouping envGroup = ldDataModel.getEnvironment_Grouping();
            rootGroup.addChild(envGroup);
            this.root = new Editor_TreeNode(rootGroup);
            this.buildChildren((Editor_TreeNode)((Object)this.root));
            this.reload();
            dataModel.addIDataModelListener(this);
        }

        protected void buildChildren(Editor_TreeNode node) {
            LD_Component ldComponent;
            Object obj = node.getUserObject();
            if (obj instanceof LD_Component && (ldComponent = (LD_Component)obj).hasChildren()) {
                DataComponent[] children = ldComponent.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    Editor_TreeNode childNode = new Editor_TreeNode(children[i]);
                    node.add((MutableTreeNode)((Object)childNode));
                    if (children[i] instanceof Environment) continue;
                    this.buildChildren(childNode);
                }
            }
        }

        public void componentAdded(DataComponent component) {
            if (this.isComponentOK(component)) {
                super.componentAdded(component);
            }
        }

        public void componentRemoved(DataComponent component) {
            if (this.isComponentOK(component)) {
                super.componentRemoved(component);
            }
        }

        public void componentMoved(DataComponent component) {
            if (this.isComponentOK(component)) {
                super.componentMoved(component);
            }
        }

        public void componentChanged(DataComponent component) {
            if (this.isComponentOK(component)) {
                super.componentChanged(component);
            }
        }

        private boolean isComponentOK(DataComponent component) {
            return component instanceof Activity || component instanceof Environment;
        }
    }
}

