/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.roles;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import uk.ac.reload.dweezil.gui.tree.DweezilTreeNode;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.menu.PopupMenuAction;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.gui.Editor_Tree;
import uk.ac.reload.editor.learningdesign.datamodel.components.roles.Learner;
import uk.ac.reload.editor.learningdesign.datamodel.components.roles.Learner_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.roles.Role;
import uk.ac.reload.editor.learningdesign.datamodel.components.roles.Staff;
import uk.ac.reload.editor.learningdesign.datamodel.components.roles.Staff_Grouping;
import uk.ac.reload.editor.learningdesign.editor.roles.RoleTree;
import uk.ac.reload.editor.learningdesign.editor.shared.LD_TreePanel;

public class RoleTreePanel
extends LD_TreePanel {
    private RoleTree _tree;
    private MenuAction_Add _menuAdd;
    private LD_TreePanel.MenuAction_Delete _menuDelete;
    private LD_TreePanel.MenuAction_Rename _menuRename;
    private LD_TreePanel.MenuAction_MoveUp _menuMoveUp;
    private LD_TreePanel.MenuAction_MoveDown _menuMoveDown;

    public RoleTreePanel() {
        this.setText("Roles");
        this.setIcon(DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/roles.gif"));
        this._menuAdd = new MenuAction_Add();
        this.addMenuActionToCoolBar((MenuAction)this._menuAdd);
        this._menuDelete = new LD_TreePanel.MenuAction_Delete(this);
        this.addMenuActionToCoolBar(this._menuDelete);
        this._menuMoveUp = new LD_TreePanel.MenuAction_MoveUp(this);
        this.addMenuActionToCoolBar(this._menuMoveUp);
        this._menuMoveDown = new LD_TreePanel.MenuAction_MoveDown(this);
        this.addMenuActionToCoolBar(this._menuMoveDown);
        this._menuRename = new LD_TreePanel.MenuAction_Rename(this);
    }

    public Editor_Tree getTree() {
        if (this._tree == null) {
            this._tree = new RoleTree();
        }
        return this._tree;
    }

    public synchronized void updateMenus() {
        super.updateMenus();
        DataComponent component = null;
        DweezilTreeNode selNode = this.getTree().getSelectedNode();
        if (selNode != null) {
            component = (DataComponent)selNode.getUserObject();
        }
        this._menuAdd.newLearner.setEnabled(component instanceof Learner || component instanceof Learner_Grouping);
        this._menuAdd.newStaff.setEnabled(component instanceof Staff || component instanceof Staff_Grouping);
        this._menuDelete.setEnabled(component != null && component.canDelete());
        this._menuRename.setEnabled(component instanceof Role);
        this._menuMoveUp.setEnabled(component != null && component.canMoveUp());
        this._menuMoveDown.setEnabled(component != null && component.canMoveDown());
        this.getTree().getPopupMenu().removeAll();
        this.getTree().getPopupMenu().add((Action)this._menuAdd.newLearner);
        this.getTree().getPopupMenu().add((Action)this._menuAdd.newStaff);
        this.getTree().getPopupMenu().addSeparator();
        this.getTree().getPopupMenu().add((Action)((Object)this._menuDelete));
        this.getTree().getPopupMenu().add((Action)((Object)this._menuRename));
    }

    class MenuAction_Add
    extends PopupMenuAction {
        MenuAction newLearner;
        MenuAction newStaff;

        public MenuAction_Add() {
            super("Add", "uk/ac/reload/editor/resources/images/add.gif");
            this.newLearner = new MenuAction("New Learner Role", "uk/ac/reload/editor/resources/images/learner.gif"){

                public void actionPerformed(ActionEvent e) {
                    RoleTreePanel.this.addNewElement("New Learner Role", this.getMenuIcon(), "learner");
                }
            };
            this.getPopupMenu().add((Action)this.newLearner);
            this.newStaff = new MenuAction("New Staff Role", "uk/ac/reload/editor/resources/images/staff.gif"){

                public void actionPerformed(ActionEvent e) {
                    RoleTreePanel.this.addNewElement("New Staff Role", this.getMenuIcon(), "staff");
                }
            };
            this.getPopupMenu().add((Action)this.newStaff);
        }
    }
}

