/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.shared;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.ac.reload.dweezil.gui.CoolBarPanel;
import uk.ac.reload.dweezil.gui.IComponentSelectionListener;
import uk.ac.reload.dweezil.menu.DweezilMenuEvent;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.menu.ProxyAction;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.datamodel.DataModel;
import uk.ac.reload.editor.datamodel.IDataComponentIcon;
import uk.ac.reload.editor.datamodel.IDataModelListener;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.menu.MainMenu;

public abstract class ComponentListPanel
extends CoolBarPanel
implements IDataModelListener,
IIcons {
    private DataModel _dataModel;
    private JList _list;
    private MenuAction_Add _menuAdd;
    private MenuAction_Delete _menuDelete;
    private MenuAction_MoveUp _menuMoveUp;
    private MenuAction_MoveDown _menuMoveDown;
    private ProxyDeleteHandler _deleteHandler;
    private ProxyMoveUpHandler _moveUpHandler;
    private ProxyMoveDownHandler _moveDownHandler;

    protected ComponentListPanel(String title, Icon icon, int listHeight) {
        this.setText(title);
        this.setIcon(icon);
        this._menuAdd = new MenuAction_Add();
        this.addMenuActionToCoolBar(this._menuAdd);
        this._menuDelete = new MenuAction_Delete();
        this.addMenuActionToCoolBar(this._menuDelete);
        this._menuMoveUp = new MenuAction_MoveUp();
        this.addMenuActionToCoolBar(this._menuMoveUp);
        this._menuMoveDown = new MenuAction_MoveDown();
        this.addMenuActionToCoolBar(this._menuMoveDown);
        JScrollPane sp = new JScrollPane(this.getList());
        sp.setPreferredSize(new Dimension(0, listHeight));
        sp.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.setMainComponent(sp);
        this.getList().setCellRenderer(new ComponentListRenderer());
        this.getList().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ComponentListPanel.this.updateMenus();
                }
            }
        });
        this.addComponentSelectionListener(new IComponentSelectionListener(){

            public void componentSelected(Component component) {
                ComponentListPanel.this.getList().requestFocus();
            }
        });
        this.setSelected(true);
        this._deleteHandler = new ProxyDeleteHandler();
        this._moveUpHandler = new ProxyMoveUpHandler();
        this._moveDownHandler = new ProxyMoveDownHandler();
        this.getList().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!e.isTemporary()) {
                    ComponentListPanel.this._deleteHandler.update();
                    ComponentListPanel.this._moveUpHandler.update();
                    ComponentListPanel.this._moveDownHandler.update();
                }
            }

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    ComponentListPanel.this._deleteHandler.clear();
                    ComponentListPanel.this._moveUpHandler.clear();
                    ComponentListPanel.this._moveDownHandler.clear();
                }
            }
        });
    }

    public void setDataModel(DataModel dataModel) {
        this._dataModel = dataModel;
        this._dataModel.addIDataModelListener(this);
    }

    public DataModel getDataModel() {
        return this._dataModel;
    }

    public JList getList() {
        if (this._list == null) {
            this._list = new JList();
        }
        return this._list;
    }

    protected void updateMenus() {
        Object[] components = this.getList().getSelectedValues();
        this._menuDelete.setEnabled(components.length > 0);
        this._menuMoveUp.setEnabled(components.length > 0);
        this._menuMoveDown.setEnabled(components.length > 0);
        this._deleteHandler.update();
        this._moveUpHandler.update();
        this._moveDownHandler.update();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this._menuAdd.setEnabled(false);
            this._menuDelete.setEnabled(false);
            this._menuMoveUp.setEnabled(false);
            this._menuMoveDown.setEnabled(false);
        } else {
            this._menuAdd.setEnabled(true);
            this.updateMenus();
        }
        this.getList().setEnabled(enabled);
    }

    protected abstract void updateListModel();

    protected abstract void showSelectorDialog();

    protected abstract void deleteListItems();

    protected abstract void moveListItemUp();

    protected abstract void moveListItemDown();

    public void cleanup() {
        this._deleteHandler.clear();
        this._moveUpHandler.clear();
        this._moveDownHandler.clear();
        if (this._dataModel != null) {
            this._dataModel.removeIDataModelListener(this);
        }
        this._dataModel = null;
    }

    protected class ProxyMoveDownHandler
    extends ProxyAction {
        public ProxyMoveDownHandler() {
            super((MenuAction)MainMenu.getSharedInstance().editMenu.actionMoveDown);
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            ComponentListPanel.this.moveListItemDown();
        }

        public void update() {
            Object[] components = ComponentListPanel.this.getList().getSelectedValues();
            if (components.length > 0) {
                this.setEnabled(true);
                this.addListener();
            } else {
                this.clear();
            }
        }
    }

    protected class ProxyMoveUpHandler
    extends ProxyAction {
        public ProxyMoveUpHandler() {
            super((MenuAction)MainMenu.getSharedInstance().editMenu.actionMoveUp);
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            ComponentListPanel.this.moveListItemUp();
        }

        public void update() {
            Object[] components = ComponentListPanel.this.getList().getSelectedValues();
            if (components.length > 0) {
                this.setEnabled(true);
                this.addListener();
            } else {
                this.clear();
            }
        }
    }

    protected class ProxyDeleteHandler
    extends ProxyAction {
        public ProxyDeleteHandler() {
            super((MenuAction)MainMenu.getSharedInstance().editMenu.actionDelete);
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            ComponentListPanel.this.deleteListItems();
        }

        public void update() {
            Object[] components = ComponentListPanel.this.getList().getSelectedValues();
            if (components.length > 0) {
                this.setEnabled(true);
                this.addListener();
            } else {
                this.clear();
            }
        }
    }

    protected class MenuAction_MoveDown
    extends MenuAction {
        public MenuAction_MoveDown() {
            super("Move Down", "uk/ac/reload/editor/resources/images/down.gif");
        }

        public void actionPerformed(ActionEvent e) {
            ComponentListPanel.this.moveListItemDown();
        }
    }

    protected class MenuAction_MoveUp
    extends MenuAction {
        public MenuAction_MoveUp() {
            super("Move Up", "uk/ac/reload/editor/resources/images/up.gif");
        }

        public void actionPerformed(ActionEvent e) {
            ComponentListPanel.this.moveListItemUp();
        }
    }

    protected class MenuAction_Delete
    extends MenuAction {
        public MenuAction_Delete() {
            super("Delete", "uk/ac/reload/editor/resources/images/delete.gif");
        }

        public void actionPerformed(ActionEvent e) {
            ComponentListPanel.this.deleteListItems();
        }
    }

    protected class MenuAction_Add
    extends MenuAction {
        public MenuAction_Add() {
            super("Add...", "uk/ac/reload/editor/resources/images/add.gif");
        }

        public void actionPerformed(ActionEvent e) {
            ComponentListPanel.this.showSelectorDialog();
        }
    }

    protected class ComponentListRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof IDataComponentIcon) {
                this.setIcon(((IDataComponentIcon)value).getIcon());
            }
            return this;
        }
    }

    protected class ComponentListModel
    extends AbstractListModel {
        private LD_Component[] _components;

        public ComponentListModel(LD_Component[] components) {
            this._components = components;
        }

        public int getSize() {
            return this._components.length;
        }

        public Object getElementAt(int index) {
            return this._components[index];
        }
    }
}

