/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.shared;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import uk.ac.reload.dweezil.gui.CoolBarPanel;
import uk.ac.reload.dweezil.gui.IComponentSelectionListener;
import uk.ac.reload.dweezil.gui.tree.DweezilTreeNode;
import uk.ac.reload.dweezil.menu.DweezilMenuEvent;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.menu.ProxyAction;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.DataModel;
import uk.ac.reload.editor.datamodel.IDataComponentIcon;
import uk.ac.reload.editor.gui.Editor_Tree;
import uk.ac.reload.editor.menu.MainMenu;

public abstract class LD_TreePanel
extends CoolBarPanel
implements IIcons {
    private DataModel _dataModel;
    private ProxyDeleteHandler _deleteHandler;
    private ProxyMoveUpHandler _moveUpHandler;
    private ProxyMoveDownHandler _moveDownHandler;

    protected LD_TreePanel() {
        JScrollPane sp = new JScrollPane((Component)((Object)this.getTree()));
        sp.setBorder(null);
        this.setMainComponent(sp);
        this.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                LD_TreePanel.this.updateMenus();
            }
        });
        this.addComponentSelectionListener(new IComponentSelectionListener(){

            public void componentSelected(Component component) {
                LD_TreePanel.this.getTree().requestFocus();
            }
        });
        this.getTree().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!e.isTemporary()) {
                    LD_TreePanel.this.getProxyDeleteHandler().update();
                    LD_TreePanel.this.getProxyMoveUpHandler().update();
                    LD_TreePanel.this.getProxyMoveDownHandler().update();
                }
            }

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    LD_TreePanel.this.getProxyDeleteHandler().clear();
                    LD_TreePanel.this.getProxyMoveUpHandler().clear();
                    LD_TreePanel.this.getProxyMoveDownHandler().clear();
                }
            }
        });
    }

    public void setDataModel(DataModel dataModel) {
        this._dataModel = dataModel;
        this.getTree().setDataModel(dataModel);
    }

    public DataModel getDataModel() {
        return this._dataModel;
    }

    public ProxyDeleteHandler getProxyDeleteHandler() {
        if (this._deleteHandler == null) {
            this._deleteHandler = new ProxyDeleteHandler();
        }
        return this._deleteHandler;
    }

    public ProxyMoveUpHandler getProxyMoveUpHandler() {
        if (this._moveUpHandler == null) {
            this._moveUpHandler = new ProxyMoveUpHandler();
        }
        return this._moveUpHandler;
    }

    public ProxyMoveDownHandler getProxyMoveDownHandler() {
        if (this._moveDownHandler == null) {
            this._moveDownHandler = new ProxyMoveDownHandler();
        }
        return this._moveDownHandler;
    }

    public abstract Editor_Tree getTree();

    public synchronized void updateMenus() {
        this.getProxyDeleteHandler().update();
        this.getProxyMoveUpHandler().update();
        this.getProxyMoveDownHandler().update();
    }

    public void addNewElement(String message, Icon icon, String elementName) {
        String title = (String)JOptionPane.showInputDialog(EditorFrame.getInstance(), "Title", message, 3, icon, null, message);
        if (title != null) {
            this.getTree().addNewElement(elementName, title);
        }
    }

    protected void renameComponent() {
        DataComponent component = null;
        DweezilTreeNode selNode = this.getTree().getSelectedNode();
        if (selNode != null) {
            component = (DataComponent)selNode.getUserObject();
        }
        if (component != null) {
            String title;
            Icon icon = null;
            if (component instanceof IDataComponentIcon) {
                icon = ((IDataComponentIcon)((Object)component)).getIcon();
            }
            if ((title = (String)JOptionPane.showInputDialog(EditorFrame.getInstance(), "Title", "Rename", 3, icon, null, component.getTitle())) != null && !"".equals(title)) {
                component.setTitle(title);
                this.getDataModel().fireDataComponentChanged(component);
            }
        }
    }

    protected void deleteComponents() {
        int result = JOptionPane.showConfirmDialog(EditorFrame.getInstance(), "Are you sure you want to delete the component(s)?", "Confirm Delete", 0);
        if (result == 0) {
            this.getTree().removeSelectedElements();
        }
    }

    protected void moveItemUp() {
        DataComponent component = null;
        DweezilTreeNode selNode = this.getTree().getSelectedNode();
        if (selNode != null) {
            component = (DataComponent)selNode.getUserObject();
        }
        if (component != null) {
            component.moveUp();
        }
    }

    protected void moveItemDown() {
        DataComponent component = null;
        DweezilTreeNode selNode = this.getTree().getSelectedNode();
        if (selNode != null) {
            component = (DataComponent)selNode.getUserObject();
        }
        if (component != null) {
            component.moveDown();
        }
    }

    public void cleanup() {
        if (this.getTree() != null) {
            this.getTree().cleanup();
        }
        if (this._deleteHandler != null) {
            this._deleteHandler.clear();
        }
        if (this._moveUpHandler != null) {
            this._moveUpHandler.clear();
        }
        if (this._moveDownHandler != null) {
            this._moveDownHandler.clear();
        }
        this._dataModel = null;
    }

    protected class ProxyMoveDownHandler
    extends ProxyAction {
        public ProxyMoveDownHandler() {
            super((MenuAction)MainMenu.getSharedInstance().editMenu.actionMoveDown);
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            LD_TreePanel.this.moveItemDown();
        }

        public void update() {
            DataComponent component = null;
            DweezilTreeNode selNode = LD_TreePanel.this.getTree().getSelectedNode();
            if (selNode != null) {
                component = (DataComponent)selNode.getUserObject();
            }
            if (component != null && component.canMoveDown()) {
                this.setEnabled(true);
                this.addListener();
            } else {
                this.clear();
            }
        }
    }

    protected class ProxyMoveUpHandler
    extends ProxyAction {
        public ProxyMoveUpHandler() {
            super((MenuAction)MainMenu.getSharedInstance().editMenu.actionMoveUp);
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            LD_TreePanel.this.moveItemUp();
        }

        public void update() {
            DataComponent component = null;
            DweezilTreeNode selNode = LD_TreePanel.this.getTree().getSelectedNode();
            if (selNode != null) {
                component = (DataComponent)selNode.getUserObject();
            }
            if (component != null && component.canMoveUp()) {
                this.setEnabled(true);
                this.addListener();
            } else {
                this.clear();
            }
        }
    }

    protected class ProxyDeleteHandler
    extends ProxyAction {
        public ProxyDeleteHandler() {
            super((MenuAction)MainMenu.getSharedInstance().editMenu.actionDelete);
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            LD_TreePanel.this.deleteComponents();
        }

        public void update() {
            DataComponent component = null;
            DweezilTreeNode selNode = LD_TreePanel.this.getTree().getSelectedNode();
            if (selNode != null) {
                component = (DataComponent)selNode.getUserObject();
            }
            if (component != null && component.canDelete()) {
                this.setEnabled(true);
                this.addListener();
            } else {
                this.clear();
            }
        }
    }

    protected class MenuAction_MoveDown
    extends MenuAction {
        public MenuAction_MoveDown() {
            super("Move Down", "uk/ac/reload/editor/resources/images/down.gif");
        }

        public void actionPerformed(ActionEvent e) {
            LD_TreePanel.this.moveItemDown();
        }
    }

    protected class MenuAction_MoveUp
    extends MenuAction {
        public MenuAction_MoveUp() {
            super("Move Up", "uk/ac/reload/editor/resources/images/up.gif");
        }

        public void actionPerformed(ActionEvent e) {
            LD_TreePanel.this.moveItemUp();
        }
    }

    protected class MenuAction_Rename
    extends MenuAction {
        public MenuAction_Rename() {
            super("Rename...");
        }

        public void actionPerformed(ActionEvent e) {
            LD_TreePanel.this.renameComponent();
        }
    }

    protected class MenuAction_Delete
    extends MenuAction {
        public MenuAction_Delete() {
            super("Delete", "uk/ac/reload/editor/resources/images/delete.gif");
        }

        public void actionPerformed(ActionEvent e) {
            LD_TreePanel.this.deleteComponents();
        }
    }
}

