/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import uk.ac.reload.dweezil.gui.DweezilFileChooser;
import uk.ac.reload.dweezil.gui.DweezilFileFilter;
import uk.ac.reload.dweezil.gui.DweezilToolBar;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.EditorHandler;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.contentpackaging.xml.CP_SchemaController;
import uk.ac.reload.editor.contentpackaging.xml.ContentPackage;
import uk.ac.reload.editor.menu.Menu_Edit;
import uk.ac.reload.editor.metadata.editor.MD_EditorPanel;
import uk.ac.reload.editor.metadata.xml.MD_SchemaController;
import uk.ac.reload.editor.metadata.xml.Metadata;
import uk.ac.reload.moonunit.schema.SchemaException;

public class MD_EditorDialog
extends JDialog {
    private MD_EditorPanel _mdEditorPanel;
    private ContentPackage _contentPackage;
    private Element _mdElement;
    private Element _existingLomElement;

    public MD_EditorDialog(ContentPackage contentPackage, Element mdElement) throws JDOMException, IOException, SchemaException {
        super(EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.metadata.MD_EditorDialog.0") + " - " + contentPackage.getProjectName(), true);
        this._contentPackage = contentPackage;
        this._mdElement = mdElement;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MD_EditorDialog.this.dispose();
            }
        });
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        Menu_Edit editMenu = new Menu_Edit();
        menuBar.add((JMenu)((Object)editMenu));
        DweezilToolBar toolBar = this.createToolBar(editMenu);
        this.getContentPane().add((Component)toolBar, "North");
        this._mdEditorPanel = new MD_EditorPanel(editMenu);
        this.getContentPane().add((Component)this._mdEditorPanel, "Center");
        toolBar.add((Component)this._mdEditorPanel.getPrefsPanel());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        JButton btnOK = new JButton(Messages.getString("uk.ac.reload.editor.metadata.MD_EditorDialog.1"));
        btnOK.addActionListener(new OKClick());
        this.getRootPane().setDefaultButton(btnOK);
        buttonPanel.add(btnOK);
        JButton btnCancel = new JButton(Messages.getString("uk.ac.reload.editor.metadata.MD_EditorDialog.2"));
        btnCancel.addActionListener(new CancelClick());
        buttonPanel.add(btnCancel);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new FlowLayout(0));
        JButton btnImport = new JButton(Messages.getString("uk.ac.reload.editor.metadata.MD_EditorDialog.3"));
        btnImport.setToolTipText(Messages.getString("uk.ac.reload.editor.metadata.MD_EditorDialog.4"));
        btnImport.addActionListener(new ImportMetadata());
        leftPanel.add(btnImport);
        JButton btnExport = new JButton(Messages.getString("uk.ac.reload.editor.metadata.MD_EditorDialog.5"));
        btnExport.setToolTipText(Messages.getString("uk.ac.reload.editor.metadata.MD_EditorDialog.6"));
        btnExport.addActionListener(new ExportMetadata());
        leftPanel.add(btnExport);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)leftPanel, "West");
        bottomPanel.add((Component)buttonPanel, "East");
        this.getContentPane().add((Component)bottomPanel, "South");
        this.setSize(EditorFrame.getInstance().getWidth() * 3 / 4, EditorFrame.getInstance().getHeight() * 3 / 4);
        this.setLocationRelativeTo(EditorFrame.getInstance());
        this.createMetadataDocument(contentPackage, mdElement);
    }

    protected void createMetadataDocument(ContentPackage cp, Element mdElement) throws JDOMException, IOException, SchemaException {
        this._existingLomElement = cp.getMetadataLomElement(mdElement);
        if (this._existingLomElement != null) {
            Document doc = new Document();
            doc.setRootElement((Element)this._existingLomElement.clone());
            Metadata md = new Metadata(false, doc);
            this._mdEditorPanel.setDocument(md);
        } else {
            MD_SchemaController mdController = ((CP_SchemaController)cp.getSchemaController()).getMD_SchemaController();
            if (mdController == null) {
                mdController = ((CP_SchemaController)cp.getSchemaController()).getDefaultMD_SchemaController();
            }
            Metadata md = new Metadata(false, mdController);
            this._mdEditorPanel.setDocument(md);
        }
        this._mdEditorPanel.getUndoManager().setFocusGained();
    }

    protected void importMetadata() throws JDOMException, SchemaException, IOException {
        DweezilFileFilter filter = new DweezilFileFilter(new String[]{"xml"}, "xml files");
        File file = DweezilFileChooser.askFileNameOpen((Component)this, (String)Messages.getString("uk.ac.reload.editor.metadata.MD_EditorDialog.7"), (FileFilter)filter);
        if (file != null) {
            if (!EditorHandler.MD_EDITORHANDLER.canEditFile(file)) {
                throw new IOException(Messages.getString("uk.ac.reload.editor.metadata.MD_EditorDialog.8"));
            }
            Metadata md = new Metadata(file);
            md = md.createEmbeddedMetadata();
            md.setDirty(true);
            this._mdEditorPanel.setDocument(md);
            this._mdEditorPanel.getUndoManager().setFocusGained();
        }
    }

    protected void exportMetadata() {
        try {
            DweezilFileFilter filter = new DweezilFileFilter(new String[]{"xml"}, "xml files");
            File file = DweezilFileChooser.askFileNameSave((Component)this, (String)Messages.getString("uk.ac.reload.editor.metadata.MD_EditorDialog.9"), (FileFilter)filter, (String)"xml");
            if (file != null) {
                Metadata md = this._mdEditorPanel.getMetadata().createStandaloneMetadata();
                md.saveAsDocument(file);
            }
        }
        catch (IOException ex) {
            ErrorDialogBox.showWarning((String)Messages.getString("uk.ac.reload.editor.metadata.MD_EditorDialog.10"), (String)Messages.getString("uk.ac.reload.editor.metadata.MD_EditorDialog.11"), (Exception)ex);
        }
    }

    public void showDialog() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MD_EditorDialog.this._mdEditorPanel.initView();
            }
        });
        super.setVisible(true);
    }

    protected void finish() {
        Metadata md = this._mdEditorPanel.getMetadata();
        if (md.isDirty()) {
            if (this._existingLomElement != null) {
                this._mdElement.removeContent(this._existingLomElement);
            }
            Metadata md2 = md.createEmbeddedMetadata();
            Element newRoot = md2.getRootElement();
            newRoot.detach();
            this._mdElement.addContent(newRoot);
            this._contentPackage.changedElement(this, this._mdElement);
        }
        this.dispose();
    }

    public void dispose() {
        this.cleanup();
        super.dispose();
    }

    public void cleanup() {
        this._mdEditorPanel.cleanup();
    }

    private DweezilToolBar createToolBar(Menu_Edit editMenu) {
        DweezilToolBar tBar = new DweezilToolBar();
        tBar.add((MenuAction)editMenu.actionUndo);
        tBar.add((MenuAction)editMenu.actionRedo);
        tBar.addSeparator();
        tBar.add((MenuAction)editMenu.actionCut);
        tBar.add((MenuAction)editMenu.actionCopy);
        tBar.add((MenuAction)editMenu.actionPaste);
        tBar.add((MenuAction)editMenu.actionDelete);
        tBar.addSeparator();
        tBar.add((MenuAction)editMenu.actionMoveUp);
        tBar.add((MenuAction)editMenu.actionMoveDown);
        tBar.addSeparator();
        return tBar;
    }

    private class CancelClick
    extends AbstractAction {
        private CancelClick() {
        }

        public void actionPerformed(ActionEvent e) {
            MD_EditorDialog.this.dispose();
        }
    }

    private class OKClick
    extends AbstractAction {
        private OKClick() {
        }

        public void actionPerformed(ActionEvent e) {
            MD_EditorDialog.this.finish();
        }
    }

    private class ImportMetadata
    extends AbstractAction {
        private ImportMetadata() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MD_EditorDialog.this.importMetadata();
            }
            catch (Exception ex) {
                ErrorDialogBox.showWarning((String)Messages.getString("uk.ac.reload.editor.metadata.MD_EditorDialog.10"), (String)Messages.getString("uk.ac.reload.editor.metadata.MD_EditorDialog.12"), (Exception)ex);
            }
        }
    }

    private class ExportMetadata
    extends AbstractAction {
        private ExportMetadata() {
        }

        public void actionPerformed(ActionEvent e) {
            MD_EditorDialog.this.exportMetadata();
        }
    }
}

