/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import uk.ac.reload.dweezil.gui.DweezilComboBox;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.menu.UndoMenuManager;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.menu.Menu_Edit;
import uk.ac.reload.editor.metadata.editor.formPlus.FormPanel;
import uk.ac.reload.editor.metadata.editor.formview.MD_FormPanel;
import uk.ac.reload.editor.metadata.editor.tableview.MD_TablePanel;
import uk.ac.reload.editor.metadata.xml.Metadata;
import uk.ac.reload.editor.properties.EditorProperties;
import uk.ac.reload.moonunit.ProfiledSchemaController;

public class MD_EditorPanel
extends JPanel {
    private Metadata _metadata;
    private MetadataPrefsPanel _prefsPanel;
    private MD_FormPanel _formPanel;
    private FormPanel _newFormPanel;
    private MD_TablePanel _tablePanel;
    private Menu_Edit _editMenu;
    private UndoMenuManager _undoMenuManager;

    public MD_EditorPanel(Menu_Edit editMenu) {
        this._editMenu = editMenu;
        this.setLayout(new BorderLayout());
        this._prefsPanel = new MetadataPrefsPanel();
        this.add((Component)this._prefsPanel, "North");
        this._tablePanel = new MD_TablePanel(editMenu);
        this._formPanel = new MD_FormPanel();
        this._newFormPanel = new FormPanel(editMenu);
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.addTab(Messages.getString("uk.ac.reload.editor.metadata.MD_EditorPanel.0"), null, new JScrollPane((Component)((Object)this._formPanel)), Messages.getString("uk.ac.reload.editor.metadata.MD_EditorPanel.0"));
        tabPane.addTab(Messages.getString("uk.ac.reload.editor.metadata.MD_EditorPanel.1"), null, this._tablePanel, Messages.getString("uk.ac.reload.editor.metadata.MD_EditorPanel.1"));
        tabPane.addTab(Messages.getString("uk.ac.reload.editor.metadata.MD_EditorPanel.4"), null, (Component)((Object)this._newFormPanel), Messages.getString("uk.ac.reload.editor.metadata.MD_EditorPanel.4"));
        this.add((Component)tabPane, "Center");
    }

    public Metadata getMetadata() {
        return this._metadata;
    }

    public void setDocument(Metadata metadata) {
        this._metadata = metadata;
        this._prefsPanel.setDocument(metadata);
        this._formPanel.setDocument(metadata);
        this._newFormPanel.setDocument(metadata);
        this._tablePanel.setDocument(metadata);
        if (this._undoMenuManager != null) {
            this._undoMenuManager.cleanup();
        }
        this._undoMenuManager = new UndoMenuManager((MenuAction)this._editMenu.actionUndo, (MenuAction)this._editMenu.actionRedo);
        metadata.setUndoHandler(this._undoMenuManager.getUndoHandler());
    }

    public void initView() {
        this._tablePanel.initView();
    }

    public UndoMenuManager getUndoManager() {
        return this._undoMenuManager;
    }

    public MetadataPrefsPanel getPrefsPanel() {
        return this._prefsPanel;
    }

    public void cleanup() {
        try {
            if (this._undoMenuManager != null) {
                this._undoMenuManager.cleanup();
            }
            if (this._formPanel != null) {
                this._formPanel.cleanup();
            }
            if (this._newFormPanel != null) {
                this._newFormPanel.destroy();
            }
            if (this._tablePanel != null) {
                this._tablePanel.cleanup();
            }
            if (this._metadata != null) {
                this._metadata.destroy();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public MD_TablePanel getMD_TablePanel() {
        return this._tablePanel;
    }

    class MetadataPrefsPanel
    extends JPanel {
        DweezilComboBox profileCombobox;
        ComboBoxListener listener;

        MetadataPrefsPanel() {
            this.setLayout(new FlowLayout(0));
            this.add(new JLabel(Messages.getString("uk.ac.reload.editor.metadata.MD_EditorPanel.2") + ": "));
            this.profileCombobox = new DweezilComboBox(false);
            this.add((Component)this.profileCombobox);
            this.listener = new ComboBoxListener();
        }

        public void setDocument(Metadata metadata) {
            this.profileCombobox.removeActionListener((ActionListener)this.listener);
            Object[] profiles = ((ProfiledSchemaController)metadata.getSchemaController()).getHelperProfileNames();
            this.profileCombobox.setItems(profiles);
            String profile = ((ProfiledSchemaController)metadata.getSchemaController()).getHelperProfile().getProfileName();
            this.profileCombobox.setSelectedItem((Object)profile);
            this.profileCombobox.addActionListener((ActionListener)this.listener);
        }

        class ComboBoxListener
        extends AbstractAction {
            ComboBoxListener() {
            }

            public void actionPerformed(ActionEvent e) {
                String profileName = (String)MetadataPrefsPanel.this.profileCombobox.getSelectedItem();
                try {
                    ((ProfiledSchemaController)MD_EditorPanel.this._metadata.getSchemaController()).loadHelperProfile(profileName);
                }
                catch (Exception ex) {
                    if (EditorProperties.getString("DEBUG").equals("true")) {
                        ex.printStackTrace();
                    }
                    ErrorDialogBox.showWarning((String)Messages.getString("uk.ac.reload.editor.metadata.MD_EditorPanel.2"), (String)(Messages.getString("uk.ac.reload.editor.metadata.MD_EditorPanel.3") + ": " + profileName), (Exception)ex);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MD_EditorPanel.this._formPanel.refresh();
                        MD_EditorPanel.this._tablePanel.refresh();
                    }
                });
            }
        }
    }
}

