/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.editor.formPlus;

import com.brunchboy.util.swing.relativelayout.AttributeConstraint;
import com.brunchboy.util.swing.relativelayout.AttributeType;
import com.brunchboy.util.swing.relativelayout.Constraint;
import com.brunchboy.util.swing.relativelayout.RelativeLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import uk.ac.reload.dweezil.gui.GradientPanel;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.gui.AttributeEditor;
import uk.ac.reload.editor.gui.TipPanel;
import uk.ac.reload.editor.menu.Menu_Edit;
import uk.ac.reload.editor.metadata.editor.formPlus.FormController;
import uk.ac.reload.editor.metadata.editor.formPlus.FormSubPanel;
import uk.ac.reload.editor.metadata.editor.formPlus.widgets.ScrollPanel;
import uk.ac.reload.editor.metadata.xml.Metadata;

public class FormPanel
extends GradientPanel {
    protected FormController controller;
    protected RelativeLayout layout = new RelativeLayout();
    private TipPanel tipPanel;
    private AttributeEditor attrPanel;
    protected FormSubPanel mdPanel;
    private JScrollPane sp;
    private JCheckBox profileCheckBox;

    public FormPanel() {
        this.setLayout((LayoutManager)this.layout);
        this.controller = new FormController();
    }

    public FormPanel(Menu_Edit editMenu) {
        this.setLayout((LayoutManager)this.layout);
        this.controller = new FormController(editMenu);
    }

    public void setDocument(Metadata md) {
        this.destroy();
        this.removeAll();
        this.controller.setMetadata(md, (JPanel)((Object)this));
        this.mdPanel = new FormSubPanel(md.getRootElement(), this.controller);
        this.initPanel();
    }

    protected void initPanel() {
        ScrollPanel wrapper = new ScrollPanel();
        wrapper.add(this.mdPanel);
        this.sp = new JScrollPane(wrapper);
        this.add(this.sp, "main");
        this.layout.addConstraint("main", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 25));
        this.layout.addConstraint("main", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        this.layout.addConstraint("main", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT));
        this.layout.addConstraint("main", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("_container", AttributeType.BOTTOM, -150));
        JPanel filler = new JPanel();
        this.add(filler, "filler");
        this.layout.addConstraint("filler", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP));
        this.layout.addConstraint("filler", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        this.layout.addConstraint("filler", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT, -150));
        this.layout.addConstraint("filler", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("main", AttributeType.TOP));
        this.profileCheckBox = new JCheckBox(Messages.getString("FormPanel.12"));
        this.profileCheckBox.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                JCheckBox cb = (JCheckBox)evt.getSource();
                boolean isSel = cb.isSelected();
                if (isSel) {
                    FormPanel.this.controller.populateWithProfileElements();
                    FormPanel.this.disableCheckBox();
                }
            }
        });
        this.add(this.profileCheckBox, "profilCheckBox");
        this.layout.addConstraint("profilCheckBox", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP));
        this.layout.addConstraint("profilCheckBox", AttributeType.LEFT, (Constraint)new AttributeConstraint("filler", AttributeType.RIGHT));
        this.layout.addConstraint("profilCheckBox", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT));
        this.layout.addConstraint("profilCheckBox", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("main", AttributeType.TOP));
        JLabel optionTip = new JLabel(Messages.getString("FormPanel.11"));
        filler.add(optionTip);
        this.tipPanel = new TipPanel();
        this.add((Component)((Object)this.tipPanel), "tip");
        this.layout.addConstraint("tip", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT, -400));
        this.layout.addConstraint("tip", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT));
        this.layout.addConstraint("tip", AttributeType.TOP, (Constraint)new AttributeConstraint("main", AttributeType.BOTTOM));
        this.layout.addConstraint("tip", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("_container", AttributeType.BOTTOM));
        this.attrPanel = new AttributeEditor();
        this.add(this.attrPanel, "attr");
        this.layout.addConstraint("attr", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        this.layout.addConstraint("attr", AttributeType.RIGHT, (Constraint)new AttributeConstraint("tip", AttributeType.LEFT));
        this.layout.addConstraint("attr", AttributeType.TOP, (Constraint)new AttributeConstraint("main", AttributeType.BOTTOM));
        this.layout.addConstraint("attr", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("_container", AttributeType.BOTTOM));
    }

    protected void disableCheckBox() {
        this.profileCheckBox.setEnabled(false);
    }

    public FormController getController() {
        return this.controller;
    }

    public TipPanel getTipPanel() {
        return this.tipPanel;
    }

    public AttributeEditor getAttrPanel() {
        return this.attrPanel;
    }

    public void destroy() {
        if (this.sp != null) {
            this.layout.removeLayoutComponent((Component)this.sp);
        }
        if (this.controller != null) {
            this.controller.destroy();
        }
        if (this.mdPanel != null) {
            this.mdPanel.destroy();
        }
        if (this.attrPanel != null) {
            this.attrPanel.cleanup();
        }
    }

    public void scrollTo(final Point pt) {
        Runnable scroller = new Runnable(){

            public void run() {
                Rectangle viewRect = FormPanel.this.sp.getViewport().getViewRect();
                viewRect.x = pt.x;
                viewRect.y = pt.y;
                FormPanel.this.sp.getViewport().setViewPosition(new Point(viewRect.x, viewRect.y));
            }
        };
        try {
            SwingUtilities.invokeLater(scroller);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

