/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.editor.formPlus;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import org.jdom.Element;
import uk.ac.reload.dweezil.menu.DweezilMenuEvent;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.menu.ProxyAction;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.datamodel.ElementBinding;
import uk.ac.reload.editor.gui.FormField;
import uk.ac.reload.editor.metadata.editor.formPlus.FormController;
import uk.ac.reload.editor.metadata.editor.formPlus.FormPanel;
import uk.ac.reload.editor.metadata.editor.formPlus.widgets.ElementComboBox;
import uk.ac.reload.editor.metadata.editor.formPlus.widgets.ElementEmptyField;
import uk.ac.reload.editor.metadata.editor.formPlus.widgets.ElementField;
import uk.ac.reload.editor.metadata.editor.formPlus.widgets.ElementTextField;
import uk.ac.reload.editor.metadata.editor.formPlus.widgets.FieldPanel;
import uk.ac.reload.editor.metadata.editor.formPlus.widgets.TableRowHiderButton;
import uk.ac.reload.jdom.XMLPath;
import uk.ac.reload.moonunit.SchemaController;
import uk.ac.reload.moonunit.SchemaDocument;
import uk.ac.reload.moonunit.schema.SchemaElement;
import uk.ac.reload.moonunit.schema.SchemaNode;
import uk.ac.reload.moonunit.vocab.VocabularyList;

public class FormSubPanel
extends JPanel {
    private static int INDENT = 15;
    private static double BORDER = 15.0;
    private static double FILLWIDTH = -1.0;
    private static double PREFDHEIGHT = -2.0;
    private static JPopupMenu popupMenu = new JPopupMenu();
    private static ProxyDeleteHandler _deleteHandler;
    private TableLayout layout;
    protected int lastRow = 1;
    private FormController fc;
    private Element top_el;
    private TableRowHiderButton hider;
    private JLabel panelLbl;

    public FormSubPanel(Element root, FormController controller) {
        this.top_el = root;
        double[][] size = new double[][]{{BORDER, FILLWIDTH, BORDER}, {BORDER, PREFDHEIGHT, BORDER}};
        this.layout = new TableLayout(size);
        this.setLayout(this.layout);
        this.layout.setVGap(1);
        if (this.fc == null) {
            this.fc = controller;
        }
        this.setOpaque(false);
        this.addMouseListener(new PanelMouseListener());
        if (root.isRootElement()) {
            double[][] rootSize = new double[][]{{BORDER, FILLWIDTH, 50.0}, {BORDER, PREFDHEIGHT, 3.0}};
            this.layout = new TableLayout(rootSize);
            this.setLayout(this.layout);
        }
        if (root.getName() != null) {
            this.setLabel(root);
        }
        this.fc.addFormComponent(root.hashCode(), this);
        List children = root.getChildren();
        if (children != null) {
            for (Element child : children) {
                String rowLocn;
                FormSubPanel sp;
                XMLPath cPath = XMLPath.getXMLPathForElement((Element)child);
                SchemaElement schemaNode = (SchemaElement)this.fc.getMetadata().getSchemaController().getSchemaNode(cPath);
                if (schemaNode != null) {
                    if (schemaNode.isEmptyType()) {
                        this.addEmptyValueField(child, schemaNode, ++this.lastRow);
                        continue;
                    }
                    if (child.getName().equals("langstring") && ((SchemaElement)schemaNode.getParent()).getChildCount() == 1) {
                        this.addValueField(child, ++this.lastRow);
                        continue;
                    }
                    if (schemaNode.isComplexType() && schemaNode.getChildCount() == 1 && schemaNode.hasChild("langstring") || schemaNode.isValueType()) {
                        this.addValueField(child, schemaNode, ++this.lastRow);
                        continue;
                    }
                    if (!schemaNode.isComplexType()) continue;
                    sp = new FormSubPanel(child, this.fc);
                    this.layout.insertRow(++this.lastRow, 15.0);
                    rowLocn = "1," + Integer.toString(this.lastRow);
                    this.add((Component)sp, rowLocn);
                    continue;
                }
                if (child.getChildren().size() > 0) {
                    sp = new FormSubPanel(child, this.fc);
                    this.layout.insertRow(++this.lastRow, 15.0);
                    rowLocn = "1," + Integer.toString(this.lastRow);
                    this.add((Component)sp, rowLocn);
                    continue;
                }
                this.addValueField(child, ++this.lastRow);
            }
        }
    }

    public TableRowHiderButton getHider() {
        return this.hider;
    }

    public void destroy() {
    }

    public void setLabel(Element element) {
        this.panelLbl = new JLabel(element.getName());
        XMLPath elPath = XMLPath.getXMLPathForElement((Element)element);
        String fname = this.fc.getMetadata().getSchemaController().getElementFriendlyName(elPath);
        if (fname != null) {
            this.panelLbl.setText(fname);
        }
        if (this.fc.isMandatory(element)) {
            this.panelLbl.setFont(DweezilUIManager.boldFont12);
        }
        this.panelLbl.setOpaque(true);
        this.panelLbl.setBorder(new EmptyBorder(0, 3, 0, 0));
        this.panelLbl.addMouseListener(new LabelListener(element, elPath));
        this.hider = new TableRowHiderButton(this);
        if (!element.isRootElement()) {
            this.add((Component)this.hider, "0,0");
            this.add((Component)this.panelLbl, "1,0, 1, 0");
        } else {
            this.add((Component)this.panelLbl, "0,0, 1, 0");
        }
    }

    public void addValueField(Element child, SchemaElement schemaNode) {
        if (schemaNode.hasChild("langstring") && schemaNode.getChildren().length == 1) {
            this.addStringValueField(child, ++this.lastRow);
        } else {
            this.addValueField(child, ++this.lastRow);
        }
    }

    public void addValueField(Element child, SchemaElement schemaNode, int indx) {
        if (schemaNode.hasChild("langstring") && schemaNode.getChildren().length == 1) {
            this.addStringValueField(child, indx);
        } else {
            this.addValueField(child, indx);
        }
    }

    public void addEmptyValueField(Element child, SchemaElement schemaNode, int indx) {
        XMLPath childPath = XMLPath.getXMLPathForElement((Element)child);
        JLabel lbl = this.createLblComponent(child, childPath);
        ElementEmptyField mdField = new ElementEmptyField(this.fc.getMetadata(), child, schemaNode);
        if (mdField == null) {
            return;
        }
        this.fc.get_fields().add(mdField);
        ((FormField)mdField).getComponent().addFocusListener(new FieldListener(child, childPath));
        FieldPanel fp = new FieldPanel(lbl, (JComponent)((FormField)mdField).getComponent());
        this.fc.addFormComponent(child.hashCode(), fp);
        this.layout.insertRow(indx, PREFDHEIGHT);
        String rowLocn = "1," + Integer.toString(indx);
        this.add((Component)fp, rowLocn);
        this.revalidate();
    }

    public void addValueField(Element child, int indx) {
        XMLPath childPath = XMLPath.getXMLPathForElement((Element)child);
        JLabel lbl = this.createLblComponent(child, childPath);
        ElementField mdField = this.createWidget(child);
        if (mdField == null) {
            return;
        }
        this.fc.get_fields().add(mdField);
        mdField.getComponent().addFocusListener(new FieldListener(child, childPath));
        FieldPanel fp = new FieldPanel(lbl, (JComponent)mdField.getComponent());
        this.fc.addFormComponent(child.hashCode(), fp);
        this.layout.insertRow(indx, PREFDHEIGHT);
        String rowLocn = "1," + Integer.toString(indx);
        this.add((Component)fp, rowLocn);
        this.revalidate();
    }

    public void addStringValueField(Element child, int indx) {
        XMLPath childPath = XMLPath.getXMLPathForElement((Element)child);
        JLabel lbl = this.createLblComponent(child, childPath);
        Element langStringChild = child.getChild("langstring", child.getNamespace());
        if (langStringChild == null) {
            FieldPanel fp = new FieldPanel(lbl);
            this.layout.insertRow(indx, PREFDHEIGHT);
            String rowLocn = "1," + Integer.toString(indx);
            this.add((Component)fp, rowLocn);
            this.fc.addFormComponent(child.hashCode(), fp);
            return;
        }
        ElementField mdField = this.createWidget(langStringChild);
        this.fc.get_fields().add(mdField);
        FieldPanel fp = new FieldPanel(lbl, (JComponent)mdField.getComponent());
        XMLPath lchildPath = XMLPath.getXMLPathForElement((Element)langStringChild);
        mdField.getComponent().addFocusListener(new FieldListener(langStringChild, lchildPath));
        this.layout.insertRow(indx, PREFDHEIGHT);
        this.fc.addFormComponent(child.hashCode(), fp);
        this.fc.addFormComponent(langStringChild.hashCode(), (JComponent)mdField.getComponent());
        String rowLocn = "1," + Integer.toString(indx);
        this.add((Component)fp, rowLocn);
        List children = child.getChildren();
        if (children.size() > 1) {
            for (int i = 1; i < children.size(); ++i) {
                this.appendStringFieldAt((Element)children.get(i), fp, i);
            }
        }
        this.revalidate();
    }

    public JLabel createLblComponent(Element child, XMLPath childPath) {
        JLabel lbl = new JLabel(child.getName());
        lbl.setBorder(new EmptyBorder(0, INDENT, 0, 0));
        String fname = this.fc.getMetadata().getSchemaController().getElementFriendlyName(childPath);
        if (fname != null) {
            lbl.setText(fname);
        }
        if (this.fc.isMandatory(child)) {
            lbl.setFont(DweezilUIManager.boldFont11);
        }
        lbl.addMouseListener(new LabelListener(child, childPath));
        return lbl;
    }

    public void appendStringFieldAt(Element langEl, FieldPanel parentPanel, int indx) {
        XMLPath langchildPath = XMLPath.getXMLPathForElement((Element)langEl);
        ElementField mdField = this.createWidget(langEl);
        if (mdField != null) {
            this.fc.get_fields().add(mdField);
            this.fc.addFormComponent(langEl.hashCode(), (JComponent)mdField.getComponent());
            mdField.getComponent().addFocusListener(new FieldListener(langEl, langchildPath));
            if (indx == 0 && ((Element)langEl.getParent()).getChildren().size() == 1) {
                parentPanel.addFirstRow((JComponent)mdField.getComponent());
                return;
            }
        } else {
            System.err.println("Unable to get field component appendStringFieldAt(Element langEl, FieldPanel parentPanel, int indx)");
            return;
        }
        JLabel dummyLbl = new JLabel("...");
        dummyLbl.setHorizontalAlignment(4);
        dummyLbl.addMouseListener(new LabelListener(langEl, langchildPath));
        parentPanel.addRowAt(dummyLbl, (JComponent)mdField.getComponent(), indx);
    }

    public void addLangStringField(Element child, int indx) {
        JComponent pComp = this.fc.getFormComponent(child.getParent().hashCode());
        if (!(pComp instanceof FieldPanel)) {
            System.err.println("\nUnable to add a field");
            return;
        }
        this.appendStringFieldAt(child, (FieldPanel)pComp, indx);
    }

    public ElementField createWidget(Element el) {
        XMLPath path = new XMLPath(XMLPath.getXMLPathForElement((Element)el));
        SchemaNode schemaNode = this.fc.getMetadata().getSchemaController().getSchemaNode(path);
        if (schemaNode instanceof SchemaElement) {
            return this.createElementWidget((SchemaElement)schemaNode, el);
        }
        if (schemaNode == null && el != null) {
            return new ElementTextField((SchemaDocument)this.fc.getMetadata(), el);
        }
        return null;
    }

    protected ElementField createElementWidget(SchemaElement schemaElement, Element el) {
        SchemaController sc = this.fc.getMetadata().getSchemaController();
        VocabularyList vList = sc.getVocabularyList((SchemaNode)schemaElement);
        if (vList != null) {
            return new ElementComboBox(this.fc.getMetadata(), schemaElement, el, vList);
        }
        return new ElementTextField(this.fc.getMetadata(), el, schemaElement);
    }

    public void setFormController(FormController controller) {
        this.fc = controller;
    }

    public TableLayout getTableLayout() {
        return this.layout;
    }

    protected void checkPopupTrigger(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.updateMenus(this.top_el);
            popupMenu.show(this, e.getX(), e.getY());
        }
    }

    protected synchronized void clearMenus() {
        popupMenu.removeAll();
        this.fc.menu_edit.removeAdditionalItems();
    }

    protected synchronized void updateMenus(Element el) {
        this.clearMenus();
        if (el == null) {
            return;
        }
        _deleteHandler = new ProxyDeleteHandler(this.fc.menu_edit.actionDelete);
        _deleteHandler.update(el);
        popupMenu.add((Action)_deleteHandler.getMenuAction());
        this.fc.menu_edit.addAdditionalItem(new JPopupMenu.Separator());
        XMLPath path = XMLPath.getXMLPathForElement((Element)el);
        SchemaElement schemaElement = (SchemaElement)this.fc.getMetadata().getSchemaController().getSchemaNode(path);
        if (schemaElement != null && schemaElement.hasChildren()) {
            popupMenu.addSeparator();
            SchemaElement[] children = schemaElement.getChildren();
            for (int i = 0; i < children.length; ++i) {
                SchemaElement childSchemaElement = children[i];
                Action_AddChildElement actionAddElement = new Action_AddChildElement(el, childSchemaElement);
                popupMenu.add(actionAddElement);
                this.fc.menu_edit.addAdditionalItem(actionAddElement);
            }
        }
    }

    public JLabel getPanelLbl() {
        return this.panelLbl;
    }

    public FormController getFormController() {
        return this.fc;
    }

    class ProxyDeleteHandler
    extends ProxyAction {
        private Element element;

        ProxyDeleteHandler(MenuAction proxyMenuAction) {
            super(proxyMenuAction);
        }

        public void update(Element elmnt) {
            this.element = elmnt;
            if (FormSubPanel.this.fc.getMetadata().canDeleteElement(this.element)) {
                this.setEnabled(true);
                this.addListener();
            } else {
                this.clear();
            }
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            FormSubPanel.this.fc.getMetadata().deleteElementUndoable(FormSubPanel.this, this.element);
        }
    }

    class Action_AddChildElement
    extends AbstractAction {
        private Element parentElement;
        private SchemaElement childSchemaElement;
        private String name;

        Action_AddChildElement(Element parentElement, SchemaElement childSchemaElement) {
            this.parentElement = parentElement;
            this.childSchemaElement = childSchemaElement;
            this.name = FormSubPanel.this.fc.getMetadata().getSchemaController().getElementFriendlyName(childSchemaElement.getXMLPath());
            if (this.name == null) {
                this.name = childSchemaElement.getName();
            }
            this.putValue("Name", "Add " + this.name);
            this.setEnabled(FormSubPanel.this.fc.getMetadata().canAddElement(parentElement, childSchemaElement));
        }

        public void actionPerformed(ActionEvent e) {
            FormSubPanel.this.fc.getMetadata().addElementBySchemaUndoable(FormSubPanel.this, this.parentElement, this.childSchemaElement, true);
        }
    }

    class FieldListener
    extends FocusAdapter {
        private Element element;
        private XMLPath path;
        private ElementBinding eb;
        private SchemaElement schemaElement;

        FieldListener(Element el, XMLPath path) {
            this.element = el;
            this.path = path;
        }

        public void focusGained(FocusEvent e) {
            this.schemaElement = (SchemaElement)FormSubPanel.this.fc.getMetadata().getSchemaController().getSchemaNode(this.path);
            if (this.schemaElement != null) {
                this.eb = new ElementBinding(this.element, this.schemaElement, FormSubPanel.this.fc.getMetadata());
                ((FormPanel)((Object)FormSubPanel.this.fc.getMainPanel())).getTipPanel().setTip(FormSubPanel.this.fc.getMetadata().getSchemaController(), this.schemaElement);
                ((FormPanel)((Object)FormSubPanel.this.fc.getMainPanel())).getAttrPanel().setElementBinding(this.eb);
                FormSubPanel.this.fc.getMainPanel().repaint();
            }
        }

        public void focusLost(FocusEvent e) {
            ((FormPanel)((Object)FormSubPanel.this.fc.getMainPanel())).getTipPanel().clear();
            FormSubPanel.this.fc.getMainPanel().repaint();
        }
    }

    class LabelListener
    extends MouseAdapter {
        private XMLPath elPath;
        private Element element;
        private ElementBinding eb;

        LabelListener(Element el, XMLPath path) {
            this.elPath = path;
            this.element = el;
        }

        public void mouseEntered(MouseEvent evt) {
            ((JLabel)evt.getSource()).setForeground(Color.blue);
            ((FormPanel)((Object)FormSubPanel.this.fc.getMainPanel())).getTipPanel().setTip(FormSubPanel.this.fc.getMetadata().getSchemaController(), (SchemaElement)FormSubPanel.this.fc.getMetadata().getSchemaController().getSchemaNode(this.elPath));
        }

        public void mouseExited(MouseEvent evt) {
            ((JLabel)evt.getSource()).setForeground(Color.black);
            ((FormPanel)((Object)FormSubPanel.this.fc.getMainPanel())).getTipPanel().clear();
        }

        public void mouseClicked(MouseEvent evt) {
            this.eb = new ElementBinding(this.element, (SchemaElement)FormSubPanel.this.fc.getMetadata().getSchemaController().getSchemaNode(this.elPath), FormSubPanel.this.fc.getMetadata());
            ((FormPanel)((Object)FormSubPanel.this.fc.getMainPanel())).getAttrPanel().setElementBinding(this.eb);
            FormSubPanel.this.fc.getMainPanel().repaint();
        }

        public void mousePressed(MouseEvent evt) {
            this.lblMouseHandler(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            this.lblMouseHandler(evt);
        }

        public void lblMouseHandler(MouseEvent evt) {
            FormSubPanel.this.updateMenus(this.element);
            if (evt.isPopupTrigger()) {
                popupMenu.show((JLabel)evt.getSource(), evt.getX(), evt.getY());
            }
        }
    }

    class PanelMouseListener
    extends MouseAdapter {
        PanelMouseListener() {
        }

        public void mousePressed(MouseEvent evt) {
            FormSubPanel.this.checkPopupTrigger(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            FormSubPanel.this.checkPopupTrigger(evt);
        }
    }
}

