/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.editor.formPlus.widgets;

import java.awt.Color;
import java.awt.Component;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DateFormatter;
import javax.swing.text.JTextComponent;
import org.jdom.Element;
import uk.ac.reload.editor.gui.widgets.NumberFieldWidget;
import uk.ac.reload.editor.gui.widgets.TextAreaWidget;
import uk.ac.reload.editor.gui.widgets.TextFieldWidget;
import uk.ac.reload.editor.gui.widgets.Widget;
import uk.ac.reload.editor.metadata.editor.formPlus.widgets.DateFieldWidget;
import uk.ac.reload.editor.metadata.editor.formPlus.widgets.DateTimeTypes;
import uk.ac.reload.editor.metadata.editor.formPlus.widgets.ElementField;
import uk.ac.reload.editor.metadata.editor.formPlus.widgets.FixedSizeFilter;
import uk.ac.reload.editor.metadata.xml.Metadata;
import uk.ac.reload.editor.valdn.SimpleFieldValidator;
import uk.ac.reload.jdom.XMLDocumentListener;
import uk.ac.reload.jdom.XMLDocumentListenerEvent;
import uk.ac.reload.moonunit.SchemaController;
import uk.ac.reload.moonunit.SchemaDocument;
import uk.ac.reload.moonunit.schema.SchemaElement;
import uk.ac.reload.moonunit.schema.SchemaNode;

public class ElementTextField
extends ElementField
implements DocumentListener {
    private boolean _allowNotification = true;
    private Widget _widget;

    public ElementTextField(Metadata metadata, SchemaElement schemaElement) {
        super((SchemaDocument)metadata, schemaElement);
        this._widget = this.getMetadataTextFieldWidget(schemaElement);
        ((JComponent)((Object)this._widget)).setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.setElement(metadata.getElement(this.getSchemaElement()));
        if (this.getElement() != null) {
            this.setValue(this.getElement().getText());
        }
        this._widget.addDocumentListener(this);
        metadata.addXMLDocumentListener(this);
    }

    public ElementTextField(SchemaDocument metadata, Element element, SchemaElement schemaElement) {
        super(metadata, element, schemaElement);
        this._widget = this.getMetadataTextFieldWidget(schemaElement);
        ((JComponent)((Object)this._widget)).setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.setElement(element);
        String elTxt = this.getElement().getText();
        this.setValue(elTxt);
        this._widget.addDocumentListener(this);
        metadata.addXMLDocumentListener((XMLDocumentListener)this);
    }

    public ElementTextField(SchemaDocument metadata, Element element) {
        super(metadata, element);
        this._widget = this.getDefaultWidget();
        ((JComponent)((Object)this._widget)).setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.setElement(element);
        String elTxt = element.getText();
        this.setValue(elTxt);
        this._widget.addDocumentListener(this);
        metadata.addXMLDocumentListener((XMLDocumentListener)this);
    }

    protected Widget getMetadataTextFieldWidget(SchemaElement schemaElement) {
        String value;
        if (schemaElement == null) {
            return this.getDefaultWidget();
        }
        Widget component = null;
        SchemaController schemaController = this.getSchemaDocument().getSchemaController();
        String widget_type = schemaController.getWidgetType(schemaElement.getXMLPath());
        String fieldType = schemaElement.getTypeName();
        if (schemaElement.getName().equals("vcard")) {
            // empty if block
        }
        if (widget_type != null) {
            if (widget_type.equals("textpane")) {
                TextAreaWidget ta = new TextAreaWidget();
                component = ta;
                ta.setLineWrap(true);
                ta.setColumns(50);
            } else if (widget_type.equals("numberfield")) {
                component = new NumberFieldWidget();
                ((NumberFieldWidget)component).setColumns(30);
            }
        } else if (fieldType != null && (fieldType.startsWith("date") || fieldType.startsWith("time") || fieldType.startsWith("gYear") || fieldType.startsWith("gMonth") || fieldType.startsWith("gDay"))) {
            component = new DateFieldWidget();
            DateFormatter fmt = (DateFormatter)((DateFieldWidget)component).getFormatter();
            DateTimeTypes.setDateTimeType(fmt, fieldType);
        } else if (schemaElement.isStringType()) {
            value = schemaController.getFacetValue((SchemaNode)schemaElement, "maxLength");
            if (value != null && Integer.parseInt(value) > 80) {
                TextAreaWidget ta = new TextAreaWidget();
                component = ta;
                ta.setLineWrap(true);
                ta.setColumns(50);
            } else {
                component = this.getDefaultWidget();
            }
        } else {
            component = this.getDefaultWidget();
        }
        if (schemaElement.isStringType() && (value = schemaController.getFacetValue((SchemaNode)schemaElement, "maxLength")) != null) {
            if (component instanceof TextFieldWidget) {
                ((TextFieldWidget)component).setMaxLength(Integer.parseInt(value));
            } else if (component instanceof TextAreaWidget) {
                ((TextAreaWidget)component).setMaxLength(Integer.parseInt(value));
                AbstractDocument doc = (AbstractDocument)((JTextComponent)((Object)component)).getDocument();
                doc.setDocumentFilter(new FixedSizeFilter(Integer.parseInt(value)));
            }
        }
        return component;
    }

    private Widget getDefaultWidget() {
        TextFieldWidget textField = new TextFieldWidget();
        textField.setColumns(50);
        return textField;
    }

    public void destroy() {
        this._widget.removeDocumentListener(this);
        this.getSchemaDocument().removeXMLDocumentListener((XMLDocumentListener)this);
    }

    public String getValue() {
        return this._widget.getTextValue();
    }

    public void setValue(String value) {
        this._allowNotification = false;
        this._widget.setTextValue(value);
        this._allowNotification = true;
    }

    public Component getComponent() {
        return (Component)((Object)this._widget);
    }

    public void changedUpdate(DocumentEvent e) {
        if (this._allowNotification) {
            this.fireElementChanged();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        if (this._allowNotification) {
            this.fireElementChanged();
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (this._allowNotification) {
            this.fireElementChanged();
        }
    }

    public static CharSequence removeDuplicateWhitespace(CharSequence inputStr) {
        String patternStr = "\\s+";
        String replaceStr = " ";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(inputStr);
        return matcher.replaceAll(replaceStr);
    }

    public void cleanup() {
    }

    public void elementChanged(XMLDocumentListenerEvent event) {
        super.elementChanged(event);
        if (event.getSource() == this) {
            SchemaElement schel = this.getSchemaElement();
            if (schel != null && schel.isValue()) {
                if (SimpleFieldValidator.isValid(this.getSchemaElement(), this.getElement().getText())) {
                    ((JComponent)((Object)this._widget)).setForeground(Color.BLACK);
                } else {
                    ((JComponent)((Object)this._widget)).setForeground(Color.RED);
                }
            }
            return;
        }
    }
}

