/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.xml;

import java.io.File;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import uk.ac.reload.editor.EditorHandler;
import uk.ac.reload.editor.metadata.xml.MD_SchemaController;
import uk.ac.reload.editor.properties.EditorProperties;
import uk.ac.reload.jdom.XMLDocumentClipboard;
import uk.ac.reload.jdom.XMLUtils;
import uk.ac.reload.moonunit.SchemaController;
import uk.ac.reload.moonunit.SchemaDocument;
import uk.ac.reload.moonunit.schema.SchemaElement;
import uk.ac.reload.moonunit.schema.SchemaException;
import uk.ac.reload.moonunit.schema.SchemaModel;

public class Metadata
extends SchemaDocument {
    static final String[] md_comments = new String[]{"This is a Reload version " + EditorProperties.getString("VERSION") + " Metadata document", "Spawned from the Reload Metadata Generator - http://www.reload.ac.uk"};
    private boolean _isStandalone;

    public Metadata(boolean isStandalone, MD_SchemaController controller) {
        this._isStandalone = isStandalone;
        this.setSchemaController((SchemaController)controller);
        this.setDocument(new Document());
        if (this._isStandalone) {
            this.addCommentsToDocument();
        }
        if (controller != null) {
            SchemaModel mdSchema = controller.getSchemaModel();
            Element root = this.addElementBySchema((Object)this, null, mdSchema.getRootElement(), true);
            this.getDocument().setRootElement(root);
            if (this._isStandalone) {
                this.addRootDeclarations();
            }
        }
        this.setDirty(false);
    }

    public Metadata(boolean isStandalone, Document doc) throws JDOMException, SchemaException, IOException {
        if (doc == null) {
            throw new NullPointerException("Document cannot be null in Metadata constructor");
        }
        this.setDocument(doc);
        this.loadSchemaControllerInstance();
        this._isStandalone = isStandalone;
    }

    public Metadata(File file) throws JDOMException, SchemaException, IOException {
        if (file == null) {
            throw new NullPointerException("File cannot be null in Metadata constructor");
        }
        this.setFile(file);
        this.setDocument(XMLUtils.readXMLFile((File)file));
        this.loadSchemaControllerInstance();
        this._isStandalone = true;
    }

    protected void loadSchemaControllerInstance() throws JDOMException, SchemaException, IOException {
        Namespace nameSpace = XMLUtils.getDocumentNamespace((Document)this.getDocument());
        String version = EditorHandler.MD_EDITORHANDLER.getVersion(nameSpace);
        if (version == null) {
            version = EditorHandler.MD_EDITORHANDLER.getDefaultVersion();
        }
        this.setSchemaController(EditorHandler.MD_EDITORHANDLER.getSchemaControllerInstance(version));
    }

    public Metadata createEmbeddedMetadata() {
        Metadata md = new Metadata(false, (MD_SchemaController)this.getSchemaController());
        Document clone = (Document)this.getDocument().clone();
        md.setDocument(clone);
        Element root = clone.getRootElement();
        root.setAttributes(null);
        Namespace ns = root.getNamespace();
        if (ns != null) {
            XMLUtils.replaceNamespaces((Element)root, (Namespace)ns, (Namespace)this.getRootNamespaceEmbedded());
        }
        return md;
    }

    public Metadata createStandaloneMetadata() {
        Metadata md = new Metadata(true, (MD_SchemaController)this.getSchemaController());
        Element root = (Element)this.getDocument().getRootElement().clone();
        Namespace ns = root.getNamespace();
        if (ns != null) {
            XMLUtils.replaceNamespaces((Element)root, (Namespace)ns, (Namespace)Namespace.getNamespace(ns.getURI()));
        }
        md.getDocument().setRootElement(root);
        md.addRootDeclarations();
        return md;
    }

    public String[] getComments() {
        return md_comments;
    }

    protected void addRootDeclarations() {
        Element root = this.getDocument().getRootElement();
        root.addNamespaceDeclaration(XMLUtils.XSI_Namespace);
        SchemaModel mdSchema = this.getSchemaController().getSchemaModel();
        String schemaLocationURI = mdSchema.getTargetNamespaceURI() + " " + mdSchema.getSchemaName();
        root.setAttribute(XMLUtils.XSI_SchemaLocation, schemaLocationURI, XMLUtils.XSI_Namespace);
    }

    public boolean isStandalone() {
        return this._isStandalone;
    }

    public Namespace getRootNamespaceEmbedded() {
        return Namespace.getNamespace("imsmd", this.getRootNamespace().getURI());
    }

    public Element addElementBySchema(Object source, Element parentElement, SchemaElement newSchemaElement, boolean doSelect) {
        Element newElement = super.addElementBySchema(source, parentElement, newSchemaElement, doSelect);
        if (newElement != null && newSchemaElement.hasSchemaAttribute("lang", Namespace.XML_NAMESPACE)) {
            this.addAttributeWithDefaultValue(source, newElement, "xml:lang");
        }
        return newElement;
    }

    public boolean canCopyElement(Element element) {
        if (element == null) {
            return false;
        }
        return !element.isRootElement();
    }

    public boolean canCutElement(Element element) {
        if (element == null) {
            return false;
        }
        return this.canDeleteElement(element);
    }

    public boolean canPasteFromClipboard(Element parentElement) {
        if (parentElement == null) {
            return false;
        }
        Element clipboardElement = XMLDocumentClipboard.getElement();
        if (clipboardElement == null) {
            return false;
        }
        return clipboardElement != null && this.isAllowedChild(parentElement, clipboardElement);
    }
}

