/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.prefs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import uk.ac.reload.diva.prefs.UserPrefs;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.prefs.AppearancePrefsPanel;
import uk.ac.reload.editor.prefs.CP_PrefsPanel;
import uk.ac.reload.editor.prefs.EditorPrefs;
import uk.ac.reload.editor.prefs.General_PrefsPanel;
import uk.ac.reload.editor.prefs.MD_PrefsPanel;

public class PrefsDialog
extends JDialog
implements IIcons {
    private General_PrefsPanel _generalPrefsPanel;
    private CP_PrefsPanel _cpPrefsPanel;
    private MD_PrefsPanel _mdPrefsPanel;
    private UserPrefs _userPrefs;
    private AppearancePrefsPanel _appearancePrefsPanel;
    private static PrefsDialog _instance;

    public static PrefsDialog getSharedInstance() {
        if (_instance == null) {
            _instance = new PrefsDialog();
        }
        return _instance;
    }

    public PrefsDialog() {
        super(EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.prefs.PrefsDialog.0"), true);
        this.setSize(580, 370);
        this.setLocationRelativeTo(EditorFrame.getInstance());
        this.setResizable(false);
        this._generalPrefsPanel = new General_PrefsPanel();
        this._cpPrefsPanel = new CP_PrefsPanel();
        this._mdPrefsPanel = new MD_PrefsPanel();
        this._appearancePrefsPanel = new AppearancePrefsPanel();
        this._userPrefs = EditorPrefs.getInstance();
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.addTab(Messages.getString("uk.ac.reload.editor.prefs.PrefsDialog.1"), DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/app16.gif"), (Component)((Object)this._generalPrefsPanel));
        tabPane.addTab(Messages.getString("uk.ac.reload.editor.prefs.PrefsDialog.2"), DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/cp.gif"), (Component)((Object)this._cpPrefsPanel));
        tabPane.addTab(Messages.getString("uk.ac.reload.editor.prefs.PrefsDialog.3"), DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/md.gif"), (Component)((Object)this._mdPrefsPanel));
        tabPane.addTab(Messages.getString("uk.ac.reload.editor.prefs.PrefsDialog.4"), DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/thread.png"), (Component)((Object)this._appearancePrefsPanel));
        this.getContentPane().add((Component)tabPane, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        JButton btnOK = new JButton(Messages.getString("uk.ac.reload.editor.prefs.PrefsDialog.5"));
        btnOK.addActionListener(new OKClick());
        this.getRootPane().setDefaultButton(btnOK);
        buttonPanel.add(btnOK);
        JButton btnCancel = new JButton(Messages.getString("uk.ac.reload.editor.prefs.PrefsDialog.6"));
        btnCancel.addActionListener(new CancelClick());
        buttonPanel.add(btnCancel);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)buttonPanel, "East");
        this.getContentPane().add((Component)bottomPanel, "South");
    }

    public void showDialog() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PrefsDialog.this._generalPrefsPanel.setFields(PrefsDialog.this._userPrefs);
                PrefsDialog.this._cpPrefsPanel.setFields(PrefsDialog.this._userPrefs);
                PrefsDialog.this._mdPrefsPanel.setFields(PrefsDialog.this._userPrefs);
                PrefsDialog.this._appearancePrefsPanel.setFields(PrefsDialog.this._userPrefs);
            }
        });
        super.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finish() {
        this._generalPrefsPanel.saveToUserPrefs(this._userPrefs);
        this._cpPrefsPanel.saveToUserPrefs(this._userPrefs);
        this._mdPrefsPanel.saveToUserPrefs(this._userPrefs);
        this._appearancePrefsPanel.saveToUserPrefs(this._userPrefs);
        try {
            this._userPrefs.save();
        }
        catch (IOException ex) {
            ErrorDialogBox.showWarning((Component)this, (String)(Messages.getString("uk.ac.reload.editor.prefs.PrefsDialog.7") + ": "), (String)Messages.getString("uk.ac.reload.editor.prefs.PrefsDialog.0"), (Exception)ex);
        }
        finally {
            this.dispose();
        }
    }

    private class CancelClick
    extends AbstractAction {
        private CancelClick() {
        }

        public void actionPerformed(ActionEvent e) {
            PrefsDialog.this._generalPrefsPanel.cancel();
            PrefsDialog.this._cpPrefsPanel.cancel();
            PrefsDialog.this._mdPrefsPanel.cancel();
            PrefsDialog.this._appearancePrefsPanel.cancel();
            PrefsDialog.this.dispose();
        }
    }

    private class OKClick
    extends AbstractAction {
        private OKClick() {
        }

        public void actionPerformed(ActionEvent e) {
            PrefsDialog.this.finish();
        }
    }
}

