/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.scorm.xml.scorm2004;

import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import uk.ac.reload.diva.util.FileUtils;
import uk.ac.reload.editor.EditorHandler;
import uk.ac.reload.editor.contentpackaging.xml.CP_SchemaController;
import uk.ac.reload.editor.contentpackaging.xml.ContentPackage;
import uk.ac.reload.editor.metadata.MD_EditorHandler;
import uk.ac.reload.editor.metadata.xml.MD_IEEE_100_SchemaController;
import uk.ac.reload.editor.metadata.xml.MD_SchemaController;
import uk.ac.reload.editor.properties.EditorProperties;
import uk.ac.reload.editor.scorm.xml.scorm2004.SCORM13Constants;
import uk.ac.reload.editor.scorm.xml.scorm2004.SCORM13_SchemaController;
import uk.ac.reload.jdom.XMLPath;
import uk.ac.reload.jdom.XMLUtils;
import uk.ac.reload.moonunit.SchemaController;
import uk.ac.reload.moonunit.schema.SchemaAttribute;
import uk.ac.reload.moonunit.schema.SchemaElement;
import uk.ac.reload.moonunit.schema.SchemaException;
import uk.ac.reload.moonunit.schema.SchemaNode;
import uk.ac.reload.moonunit.vocab.VocabularyList;

public class SCORM13_Package
extends ContentPackage {
    static final String[] scorm_comments = new String[]{"This is a Reload version " + EditorProperties.getString("VERSION") + " SCORM 2004 Content Package document", "Spawned from the Reload Content Package Generator - http://www.reload.ac.uk"};

    public SCORM13_Package() {
    }

    public SCORM13_Package(File projectFolder, SCORM13_SchemaController scormController, MD_SchemaController mdController) throws IOException {
        this.setSchemaController((SchemaController)scormController);
        scormController.setMD_SchemaController(mdController);
        this.init(projectFolder, scormController);
        this.saveDocument();
        this.setDirty(false);
        scormController.copySchemaFilesToFolder(projectFolder);
        if (mdController.getVersion().equals("IEEE LOM Metadata 1.0")) {
            FileUtils.copyFolder((File)new File(EditorHandler.SCHEMASHIPPEDFOLDER, "lom_10"), (File)projectFolder);
        }
    }

    public SCORM13_Package(File file) throws JDOMException, SchemaException, IOException {
        Namespace nsMD;
        this.setFile(file);
        this.setDocument(XMLUtils.readXMLFile((File)file));
        SCORM13_SchemaController scormController = (SCORM13_SchemaController)EditorHandler.SCORM13_EDITORHANDLER.getSchemaControllerInstance("ADL SCORM 1.3");
        this.setSchemaController((SchemaController)scormController);
        if (this.getDocument().getRootElement() != null && (nsMD = this.getDocument().getRootElement().getNamespace("imsmd")) != null) {
            if (nsMD.equals(MD_EditorHandler.IEEE_NAMESPACE_100)) {
                MD_IEEE_100_SchemaController mdController = new MD_IEEE_100_SchemaController();
                scormController.setMD_SchemaController(mdController);
            } else {
                String version = EditorHandler.MD_EDITORHANDLER.getVersion(nsMD);
                if (version != null) {
                    MD_SchemaController mdController = (MD_SchemaController)EditorHandler.MD_EDITORHANDLER.getSchemaControllerInstance(version);
                    scormController.setMD_SchemaController(mdController);
                }
            }
        }
    }

    protected void init(File projectFolder, CP_SchemaController cpController) {
        super.init(projectFolder, cpController);
        Element root = this.getDocument().getRootElement();
        if (root != null) {
            root.addNamespaceDeclaration(SCORM13Constants.ADLCP_NAMESPACE_13);
            root.addNamespaceDeclaration(SCORM13Constants.IMSSS_NAMESPACE_10);
            root.addNamespaceDeclaration(SCORM13Constants.ADLSEQ_NAMESPACE_13);
            root.addNamespaceDeclaration(SCORM13Constants.ADLNAV_NAMESPACE_13);
            Attribute att = root.getAttribute(XMLUtils.XSI_SchemaLocation, XMLUtils.XSI_Namespace);
            if (att != null) {
                String value = att.getValue();
                if (value == null) {
                    value = "";
                }
                StringBuffer schemaLocationURI = new StringBuffer(value);
                schemaLocationURI.append(" ");
                schemaLocationURI.append(SCORM13Constants.ADLCP_NAMESPACE_13.getURI());
                schemaLocationURI.append(" ");
                schemaLocationURI.append("adlcp_v1p3.xsd");
                schemaLocationURI.append(" ");
                schemaLocationURI.append(SCORM13Constants.IMSSS_NAMESPACE_10.getURI());
                schemaLocationURI.append(" ");
                schemaLocationURI.append("imsss_v1p0.xsd");
                schemaLocationURI.append(" ");
                schemaLocationURI.append(SCORM13Constants.ADLSEQ_NAMESPACE_13.getURI());
                schemaLocationURI.append(" ");
                schemaLocationURI.append("adlseq_v1p3.xsd");
                schemaLocationURI.append(" ");
                schemaLocationURI.append(SCORM13Constants.ADLNAV_NAMESPACE_13.getURI());
                schemaLocationURI.append(" ");
                schemaLocationURI.append("adlnav_v1p3.xsd");
                att.setValue(schemaLocationURI.toString());
            }
        }
    }

    public String[] getComments() {
        return scorm_comments;
    }

    public Element addSSElementBySchema(Object source, Element parentElement, SchemaElement newSchemaElement) {
        int i;
        String nsSchemaPrefix;
        if (newSchemaElement == null) {
            return null;
        }
        Namespace ns = parentElement == null ? this.getTargetNamespace() : ((nsSchemaPrefix = newSchemaElement.getNamespacePrefix()).equals("") ? parentElement.getNamespace() : newSchemaElement.getNamespace());
        Element newElement = new Element(newSchemaElement.getName(), ns);
        String defaultValue = this.getSchemaController().getDefaultValue((SchemaNode)newSchemaElement);
        if (defaultValue != null) {
            newElement.setText(defaultValue);
        }
        if (newSchemaElement.hasSchemaAttributes()) {
            SchemaAttribute[] atts = newSchemaElement.getSchemaAttributes();
            for (i = 0; i < atts.length; ++i) {
                defaultValue = this.getSchemaController().getDefaultValue((SchemaNode)atts[i]);
                String required = atts[i].getUse();
                String attName = atts[i].getName();
                if (attName.equals("identifier") || attName.equalsIgnoreCase("scormType") || attName.equalsIgnoreCase("href") || required == null || parentElement == null || required.indexOf("required") < 0) continue;
                String v = this.getSpecialAttributeValue(parentElement, newSchemaElement, attName);
                if (v != null && v.length() > 0) {
                    Attribute att = atts[i].createAttribute();
                    att.setValue(v);
                    newElement.setAttribute(att);
                    continue;
                }
                this.removeElement(source, newElement);
                return null;
            }
        }
        if (parentElement != null) {
            int index = this.getInsertPositionOfElement(parentElement, newSchemaElement);
            this.addElementAtIndex(source, parentElement, newElement, index, false);
        }
        SchemaElement[] schemaChildren = newSchemaElement.getChildren();
        for (i = 0; i < schemaChildren.length; ++i) {
            Element e;
            SchemaElement child = schemaChildren[i];
            if (child.getMinOccurs() != 1 || (e = this.addElementBySchema(source, newElement, child, false)) != null) continue;
            this.removeElement(source, newElement);
            return null;
        }
        return newElement;
    }

    public String getSpecialAttributeValue(Element parentElement, SchemaElement newSchemaElement, String att) {
        String nsSchemaPrefix;
        String value = null;
        Namespace ns = parentElement == null ? this.getTargetNamespace() : ((nsSchemaPrefix = newSchemaElement.getNamespacePrefix()).equals("") ? parentElement.getNamespace() : newSchemaElement.getNamespace());
        SchemaAttribute attribute = null;
        if (newSchemaElement.hasSchemaAttribute(att) && !newSchemaElement.hasSchemaAttribute("scormType")) {
            attribute = newSchemaElement.getSchemaAttribute(att, ns);
        }
        if (attribute != null) {
            String elementName;
            VocabularyList vl = attribute.getVocabularyList();
            Object[] list = null;
            if (vl != null) {
                list = vl.getList();
            }
            if ((elementName = newSchemaElement.getName()).equalsIgnoreCase("rollupCondition") || elementName.equalsIgnoreCase("rollupAction")) {
                elementName = "rollupRule";
            } else if (elementName.equalsIgnoreCase("ruleCondition") || elementName.equalsIgnoreCase("ruleAction")) {
                elementName = "rollupRule";
            }
            if (list != null) {
                Object object = JOptionPane.showInputDialog(null, "Please select a value for '" + attribute.getName() + "'.\n Otherwise '" + elementName + "' will not be added.\n", "Input", 1, null, list, list[0]);
                if (object == null) {
                    return null;
                }
                value = object.toString();
            } else {
                String object = JOptionPane.showInputDialog(null, "Please select a value for '" + attribute.getName() + "'.\n Otherwise '" + elementName + "' will not be added.\n", "Input", 1);
                if (object == null) {
                    return null;
                }
                value = object.toString();
                value.trim();
            }
        }
        return value;
    }

    public Element addElementBySchema(Object source, Element parentElement, SchemaElement newSchemaElement, boolean doSelect) {
        Element newElement = super.addElementBySchema(source, parentElement, newSchemaElement, doSelect);
        if (newElement != null) {
            String name = newElement.getName();
            if (name.equals("resource")) {
                Attribute att = this.addAttributeWithDefaultValue(source, newElement, "adlcp:scormType");
                if (att != null && att.getValue().equals("")) {
                    att.setValue("asset");
                }
            } else if (name.equals("metadata") && parentElement.getName().equals("manifest")) {
                SchemaElement schemaElement = (SchemaElement)this.getSchemaController().getSchemaNode(new XMLPath("manifest/metadata/schema"));
                if (schemaElement != null) {
                    this.addElementBySchema((Object)this, newElement, schemaElement, false);
                }
                if ((schemaElement = (SchemaElement)this.getSchemaController().getSchemaNode(new XMLPath("manifest/metadata/schemaversion"))) != null) {
                    this.addElementBySchema((Object)this, newElement, schemaElement, false);
                }
            }
        }
        return newElement;
    }
}

