/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.scorm.xml.scorm2004;

import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import uk.ac.reload.diva.util.FileUtils;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.EditorHandler;
import uk.ac.reload.editor.contentpackaging.CP_EditorHandler;
import uk.ac.reload.editor.contentpackaging.xml.CP_SchemaController;
import uk.ac.reload.editor.metadata.xml.MD_IEEE_100_SchemaController;
import uk.ac.reload.editor.metadata.xml.MD_SchemaController;
import uk.ac.reload.editor.prefs.EditorPrefs;
import uk.ac.reload.editor.scorm.xml.scorm2004.SCORM13Constants;
import uk.ac.reload.editor.scorm2004.SCORM13_EditorHandler;
import uk.ac.reload.moonunit.schema.SchemaException;

public class SCORM13_SchemaController
extends CP_SchemaController {
    public static String defaultSCORMProfile = "SCORM 1.3 Default Profile";

    public Icon getLeafIcon(String name, Namespace ns) {
        if (name.equals("manifest")) {
            return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/cp_scorm.gif");
        }
        if (CP_EditorHandler.ADLCP_NAMESPACE_13.equals(ns)) {
            return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/adl.gif");
        }
        return super.getLeafIcon(name, ns);
    }

    public File getProfileFolder() {
        return SCORM13_EditorHandler.PROFILE_FOLDER;
    }

    public File getSchemaHelperFolder() {
        return SCORM13_EditorHandler.SCHEMAHELPER_FOLDER;
    }

    public File getVocabFolder() {
        return SCORM13_EditorHandler.VOCAB_FOLDER;
    }

    public String getDefaultProfileName() {
        String defProfileName = EditorPrefs.getInstance().getValue("default_scorm_profile");
        return defProfileName == null ? defaultSCORMProfile : defProfileName;
    }

    public MD_SchemaController getDefaultMD_SchemaController() throws JDOMException, IOException, SchemaException {
        return new MD_IEEE_100_SchemaController();
    }

    public String getVersion() {
        return "ADL SCORM 1.3";
    }

    public File getSchemaFile() {
        return SCORM13Constants.fileSchemaSCORM1_3_0;
    }

    public void copySchemaFilesToFolder(File projectFolder) throws IOException {
        super.copySchemaFilesToFolder(projectFolder);
        FileUtils.copyFolder((File)new File(EditorHandler.SCHEMASHIPPEDFOLDER, "adlcp_130"), (File)projectFolder);
    }
}

