/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.scorm2004;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.Icon;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.EditorHandler;
import uk.ac.reload.editor.EditorInternalFrame;
import uk.ac.reload.editor.contentpackaging.CP_EditorHandler;
import uk.ac.reload.editor.metadata.xml.MD_SchemaController;
import uk.ac.reload.editor.scorm.xml.scorm2004.SCORM13_Package;
import uk.ac.reload.editor.scorm.xml.scorm2004.SCORM13_SchemaController;
import uk.ac.reload.editor.scorm2004.SCORM13_Editor;
import uk.ac.reload.editor.scorm2004.SCORM13_NewDialog;
import uk.ac.reload.jdom.XMLUtils;
import uk.ac.reload.moonunit.SchemaController;
import uk.ac.reload.moonunit.schema.SchemaException;

public class SCORM13_EditorHandler
extends CP_EditorHandler {
    public static final String ADL_SCORM_1_3 = "ADL SCORM 1.3";
    static Hashtable SUPPORTED_SCORM_NAMESPACES = new Hashtable();
    public static final File HELPER_FOLDER;
    public static final File PROFILE_FOLDER;
    public static final File SCHEMAHELPER_FOLDER;
    public static final File VOCAB_FOLDER;
    public static final File TEMPLATE_FOLDER;

    public boolean canEditFile(File file) {
        Document doc = null;
        try {
            doc = this.getDocument(file);
        }
        catch (Exception ex) {
            return false;
        }
        Namespace nameSpace = XMLUtils.getDocumentNamespace((Document)doc);
        if (nameSpace == null || nameSpace.equals(Namespace.NO_NAMESPACE)) {
            return false;
        }
        Namespace nsSCORM = SCORM13_EditorHandler.getSCORM_Namespace(doc);
        if (nsSCORM == null) {
            return false;
        }
        if (!SUPPORTED_SCORM_NAMESPACES.containsKey(nsSCORM)) {
            return false;
        }
        return SUPPORTED_CP_NAMESPACES.containsKey(nameSpace);
    }

    public EditorInternalFrame editFile(File file) throws JDOMException, SchemaException, IOException {
        if (file.getName().toLowerCase().endsWith(".zip")) {
            File manifest = this.unzipManifest(file);
            if (manifest != null) {
                file = manifest;
            } else {
                throw new IOException("No manifest file");
            }
        }
        SCORM13_Package sp = new SCORM13_Package(file);
        return new SCORM13_Editor(sp);
    }

    public EditorInternalFrame newDocument() throws JDOMException, SchemaException, IOException {
        SCORM13_NewDialog dialog = new SCORM13_NewDialog("Select Folder for New SCORM 2004 Package");
        File cpFolder = dialog.showDialog();
        if (cpFolder == null) {
            return null;
        }
        String versionSCORM = ADL_SCORM_1_3;
        SCORM13_SchemaController scormController = (SCORM13_SchemaController)this.getSchemaControllerInstance(versionSCORM);
        MD_SchemaController mdController = (MD_SchemaController)EditorHandler.MD_EDITORHANDLER.getSchemaControllerInstance("IEEE LOM Metadata 1.0");
        SCORM13_Package sp = new SCORM13_Package(cpFolder, scormController, mdController);
        return new SCORM13_Editor(sp);
    }

    public String getName() {
        return "ADL SCORM 2004 Package";
    }

    public Icon getIcon() {
        return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/cp_scorm.gif");
    }

    public String getDefaultVersion() {
        return "IMS Content Packaging 1.1.2";
    }

    public String getDefaultMDVersion() {
        return "IEEE LOM Metadata 1.0";
    }

    public String[] getSupportedVersions() {
        return new String[]{ADL_SCORM_1_3};
    }

    public String getVersion(Namespace ns) {
        if (ns == null) {
            return null;
        }
        return "ADL SCORM 1.3, " + (String)SUPPORTED_CP_NAMESPACES.get(ns);
    }

    public SchemaController getSchemaControllerInstance(String version) throws JDOMException, SchemaException, IOException {
        SCORM13_SchemaController schemaController = null;
        if (ADL_SCORM_1_3.equals(version)) {
            schemaController = new SCORM13_SchemaController();
        }
        return schemaController;
    }

    static {
        SUPPORTED_SCORM_NAMESPACES.put(ADLCP_NAMESPACE_13, ADL_SCORM_1_3);
        HELPER_FOLDER = new File(EditorHandler.HELPERFOLDER, "scorm");
        PROFILE_FOLDER = new File(HELPER_FOLDER, "profile");
        SCHEMAHELPER_FOLDER = new File(HELPER_FOLDER, "schemahelper");
        VOCAB_FOLDER = new File(HELPER_FOLDER, "vocab");
        TEMPLATE_FOLDER = new File(HELPER_FOLDER, "LSAL_Templates");
    }
}

