/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.simplesequencing.scormgui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import org.jdom.Element;
import uk.ac.reload.editor.contentpackaging.xml.ContentPackage;
import uk.ac.reload.editor.simplesequencing.SS_SchemaController;
import uk.ac.reload.editor.simplesequencing.scormgui.InnerTable;
import uk.ac.reload.editor.simplesequencing.scormgui.SSTableModel;
import uk.ac.reload.moonunit.schema.SchemaElement;

public class SSAddMapInfoListener
extends AbstractAction {
    private InnerTable _innerTable;
    private ArrayList _mapInfoObjects;
    private SSTableModel _outerTable;
    private ContentPackage _contentPackage;
    private Element _parentElement;
    private SchemaElement _schemaElement;
    private int count;

    public SSAddMapInfoListener() {
    }

    public SSAddMapInfoListener(InnerTable table, SSTableModel outerTable, ArrayList objects, ContentPackage contentPackage, Element parentElement, SchemaElement schemaElement) {
        this._innerTable = table;
        this._mapInfoObjects = objects;
        this._outerTable = outerTable;
        this._contentPackage = contentPackage;
        this._parentElement = parentElement;
        this._schemaElement = schemaElement;
    }

    public void actionPerformed(ActionEvent event) {
        Element _mapInfo = new Element("mapInfo", this._schemaElement.getNamespace());
        this.count = this._innerTable.getRowCount() + 1;
        boolean emptyRowFound = false;
        if (this.count == 2 && ((String)this._innerTable.getValueAt(0, 0) == null || ((String)this._innerTable.getValueAt(0, 0)).indexOf("1.") < 0)) {
            this.count = 1;
            emptyRowFound = true;
        }
        Integer integer = new Integer(this.count);
        String mapInfo = integer.toString() + ".  ";
        for (int j = 0; j < this._mapInfoObjects.size(); ++j) {
            String value;
            Object o = this._mapInfoObjects.get(j);
            if (!((Component)o).isEnabled()) {
                mapInfo = " ";
                continue;
            }
            if (o instanceof JTextArea) {
                if (((JTextArea)o).getText().trim() != null && ((JTextArea)o).getText().trim().length() > 0) {
                    mapInfo = mapInfo + ((JTextArea)o).getText().trim() + "\n";
                    _mapInfo.setAttribute("targetObjectiveID", ((JTextArea)o).getText().trim());
                    continue;
                }
                JOptionPane.showMessageDialog(null, "<html>A <b>Target Objective ID</b> is required to map info. Please enter a <b>Target Objective ID</b> then add info.</html>");
                return;
            }
            if (((JCheckBox)o).isSelected()) {
                mapInfo = mapInfo + "       " + ((JCheckBox)o).getText().trim() + "\n";
                value = SS_SchemaController.getFriendlyName(((JCheckBox)o).getText().trim());
                if (value != null) {
                    // empty if block
                }
                _mapInfo.setAttribute(value, "true");
                continue;
            }
            if (((JCheckBox)o).isSelected()) continue;
            value = SS_SchemaController.getFriendlyName(((JCheckBox)o).getText().trim());
            if (value != null) {
                // empty if block
            }
            _mapInfo.setAttribute(value, "false");
        }
        if (mapInfo.length() > 3) {
            if (emptyRowFound) {
                this._innerTable.setValueAt(mapInfo, 0, 0);
            } else {
                ((DefaultTableModel)this._innerTable.getModel()).addRow(new Object[]{mapInfo});
            }
            int row = this._innerTable.getRowCount() - 1;
            int lineCount = 2;
            int found = mapInfo.indexOf("\n", 0);
            String sub = mapInfo.substring(0, found);
            int subLen = sub.length();
            int subLineCount = (int)Math.ceil((double)subLen / 20.0);
            lineCount = subLineCount >= lineCount ? (lineCount += subLineCount + 1) : (lineCount += subLineCount);
            for (int k = 0; k < mapInfo.length(); ++k) {
                found = mapInfo.indexOf("\n", k);
                if (found < 0) continue;
                ++lineCount;
                k = found + 2;
            }
            if (this._innerTable.getRowCount() == 1) {
                if (lineCount * 12 > SSTableModel.ROWHEIGHT) {
                    this._innerTable.setRowHeight(lineCount * 12);
                } else {
                    this._innerTable.setRowHeight(SSTableModel.ROWHEIGHT);
                }
            } else {
                this._innerTable.setRowHeight(row, lineCount * 12);
            }
            if (this._outerTable != null) {
                this._outerTable.moveColumn(3, 3);
            }
            this._contentPackage.addElement(this, this._parentElement, _mapInfo, false);
        }
    }
}

