/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.simplesequencing.scormgui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.jdom.Element;
import uk.ac.reload.editor.contentpackaging.xml.ContentPackage;
import uk.ac.reload.editor.simplesequencing.SS_SchemaController;
import uk.ac.reload.editor.simplesequencing.scormgui.InnerTable;
import uk.ac.reload.editor.simplesequencing.scormgui.SSAddMapInfoListener;
import uk.ac.reload.editor.simplesequencing.scormgui.SSTableModel;
import uk.ac.reload.editor.simplesequencing.scormgui.SSTableModelListener;
import uk.ac.reload.editor.simplesequencing.scormgui.SimpleSequencingTabsPane;
import uk.ac.reload.moonunit.schema.SchemaElement;

public class SSPrimaryObjectiveTableListener
extends SSTableModelListener {
    private static Object[] _tableOccupants;
    private Object[] _tempTableOccupants;
    private ArrayList mapInfoObjects;
    private JButton _addMapInfo;
    private InnerTable innerTable;
    private JScrollPane scroll;
    private Element _objective;
    private Element _minNormalizedMeasure;
    private Element _mapInfo;

    public SSPrimaryObjectiveTableListener(JTable tableModel, Object[] tableOccupants) {
        _tableOccupants = tableOccupants;
        this._SSTableModel = tableModel;
    }

    public void passContentPackageEtc(ContentPackage contentPackage, Element element, SchemaElement schemaElement) {
        super.passContentPackageEtc(contentPackage, element, schemaElement);
    }

    public void actionPerformed(ActionEvent event) {
        if (((DefaultTableModel)this._SSTableModel.getModel()).getRowCount() >= 1) {
            JOptionPane.showMessageDialog(null, "<html>Only one <b>Primary Objective</b> is allowed. To add a new <b>Primary Objective</b>, please delete the one currently in the table.<br>Multiple <b>Objectives</b> via the adjacent <b>Objective</b> tab are allowed.</html>");
            return;
        }
        this._objective = new Element("primaryObjective", this._schemaElement.getNamespace());
        this._minNormalizedMeasure = new Element("minNormalizedMeasure", this._schemaElement.getNamespace());
        this._mapInfo = new Element("mapInfo", this._schemaElement.getNamespace());
        boolean mapping = false;
        this._tempTableOccupants = new Object[_tableOccupants.length + 2];
        for (int i = 0; i < _tableOccupants.length; ++i) {
            this._tempTableOccupants[i] = _tableOccupants[i];
            if (this._tempTableOccupants[i] instanceof JComboBox) {
                JComboBox comboBox = (JComboBox)this._tempTableOccupants[i];
                this._tempTableOccupants[i] = comboBox.getSelectedItem().toString().trim();
                continue;
            }
            if (this._tempTableOccupants[i] instanceof JCheckBox) {
                this._tempTableOccupants[i] = ((JCheckBox)this._tempTableOccupants[i]).isSelected() ? "true" : "false";
                if (i != 1) continue;
                this._objective.setAttribute("satisfiedByMeasure", this._tempTableOccupants[i].toString());
                continue;
            }
            if (this._tempTableOccupants[i] instanceof JTextArea) {
                JTextArea textArea = (JTextArea)this._tempTableOccupants[i];
                this._tempTableOccupants[i] = textArea.isEnabled() ? textArea.getText().trim() : null;
                if (!textArea.isEnabled() || i != 2 || this._tempTableOccupants[i] != null && ((String)this._tempTableOccupants[i]).length() > 0) continue;
                JOptionPane.showMessageDialog(null, "<html>A <b>Minimum Satisfaction Measure</b> is required for the <b>Objective</b> to be <b>Satisfied by Measure</b>.<br>Either deSelect <b>Objective Satisfied by Measure</b> or supply a value for <b>Minimum Satisfaction Measure</b></html>");
                return;
            }
            if (this._tempTableOccupants[i] instanceof String || !(this._tempTableOccupants[i] instanceof ArrayList)) continue;
            this.mapInfoObjects = (ArrayList)this._tempTableOccupants[i];
            ArrayList a = (ArrayList)this._tempTableOccupants[i];
            String mapInfo = "1.  ";
            for (int j = 0; j < a.size(); ++j) {
                String value;
                Object o = a.get(j);
                if (!((Component)o).isEnabled()) {
                    mapInfo = " ";
                    continue;
                }
                if (o instanceof JTextArea) {
                    if (((JTextArea)o).getText().trim() != null && ((JTextArea)o).getText().trim().length() > 0) {
                        mapInfo = mapInfo + ((JTextArea)o).getText().trim() + "\n";
                        this._mapInfo.setAttribute("targetObjectiveID", ((JTextArea)o).getText().trim());
                        continue;
                    }
                    JOptionPane.showMessageDialog(null, "<html>A <b>Target Objective ID</b> is required to map info. Please enter a <b>Target Objective ID</b> then add info.</html>");
                    return;
                }
                if (((JCheckBox)o).isSelected()) {
                    mapping = true;
                    mapInfo = mapInfo + "       " + ((JCheckBox)o).getText().trim() + "\n";
                    value = SS_SchemaController.getFriendlyName(((JCheckBox)o).getText().trim());
                    if (value != null) {
                        // empty if block
                    }
                    this._mapInfo.setAttribute(value, "true");
                    continue;
                }
                if (((JCheckBox)o).isSelected()) continue;
                value = SS_SchemaController.getFriendlyName(((JCheckBox)o).getText().trim());
                if (value != null) {
                    // empty if block
                }
                this._mapInfo.setAttribute(value, "false");
            }
            this.innerTable = new InnerTable(1, 1);
            TableColumn col = this.innerTable.getColumnModel().getColumn(0);
            col.setCellRenderer(new DefaultTableCellRenderer());
            this.innerTable.setValueAt(mapInfo, 0, 0);
            int lineCount = 2;
            int found = mapInfo.indexOf("\n", 0);
            if (found >= 0) {
                String sub = mapInfo.substring(0, found);
                int subLen = sub.length();
                int subLineCount = (int)Math.ceil((double)subLen / 20.0);
                lineCount = subLineCount >= lineCount ? (lineCount += subLineCount + 1) : (lineCount += subLineCount);
                for (int k = 0; k < mapInfo.length(); ++k) {
                    found = mapInfo.indexOf("\n", k);
                    if (found < 0) continue;
                    ++lineCount;
                    k = found + 2;
                }
                if (lineCount * 12 > this._SSTableModel.getRowHeight()) {
                    this.innerTable.setRowHeight(lineCount * 12);
                } else {
                    this.innerTable.setRowHeight(this._SSTableModel.getRowHeight());
                }
            } else {
                this.innerTable.setRowHeight(this._SSTableModel.getRowHeight());
            }
            JTableHeader innerTableHeader = new JTableHeader();
            innerTableHeader.setPreferredSize(new Dimension(0, 0));
            this.innerTable.setTableHeader(innerTableHeader);
            this.scroll = new JScrollPane(this.innerTable);
            this._tempTableOccupants[i] = this.scroll;
        }
        if ((this._tempTableOccupants[0] == null || ((String)this._tempTableOccupants[0]).length() <= 0) && mapping) {
            JOptionPane.showMessageDialog(null, "<html>An <b>Objective ID</b> is required to add this <b>Objective</b>. Please enter an <b>Objective ID</b> then <b>Add Rule</b>.");
            return;
        }
        this._objective.setAttribute("objectiveID", this._tempTableOccupants[0].toString());
        if (this._tempTableOccupants[2] != null && ((String)this._tempTableOccupants[2]).length() > 0) {
            Double value = new Double(0.0);
            try {
                value = new Double(Double.parseDouble((String)this._tempTableOccupants[2]));
            }
            catch (NumberFormatException NFE) {
                JOptionPane.showMessageDialog(null, "<html><b>Minimum Satisfaction Measure</b> is invalid. Please select a value for this measure that is in the range [-1, 1] then <b>Add Rule.</b></html>");
                return;
            }
            Double lowerLimit = new Double(-1.0);
            Double upperLimit = new Double(1.0);
            if (value.compareTo(upperLimit) > 0 || value.compareTo(lowerLimit) < 0) {
                JOptionPane.showMessageDialog(null, "<html><b>Minimum Satisfaction Measure</b> is invalid. Please select a value for this measure that is in the range [-1, 1] then <b>Add Rule.</b></html>");
                return;
            }
            this._minNormalizedMeasure.addContent((String)this._tempTableOccupants[2]);
        }
        this.addRule();
        this._deleteButton = new JButton("Delete");
        this._deleteButton.addActionListener(new SSTableModelListener.SSTableRemoveRowListener(this, this._objective, ((DefaultTableModel)this._SSTableModel.getModel()).getRowCount()));
        this._addMapInfo = new JButton("<html>Add<br> MapInfo</html>");
        this._addMapInfo.addActionListener(new SSAddMapInfoListener(this.innerTable, (SSTableModel)this._SSTableModel, this.mapInfoObjects, this._contentPackage, this._objective, this._schemaElement));
        this._tempTableOccupants[this._tempTableOccupants.length - 1] = this._deleteButton;
        this._tempTableOccupants[this._tempTableOccupants.length - 2] = this._addMapInfo;
        ((DefaultTableModel)this._SSTableModel.getModel()).addRow(this._tempTableOccupants);
    }

    private void addRule() {
        String targObjID;
        String minNormMeasure = this._minNormalizedMeasure.getText();
        if (minNormMeasure != null && minNormMeasure.length() > 0) {
            this._objective.addContent(this._minNormalizedMeasure);
        }
        if ((targObjID = this._mapInfo.getAttributeValue("targetObjectiveID")) != null && targObjID.length() > 0) {
            this._objective.addContent(this._mapInfo);
        }
        Element _objectives = new Element("objectives", this._schemaElement.getNamespace());
        Element sequencingElement = SimpleSequencingTabsPane.findSequencingElement(this._element);
        if (sequencingElement != null) {
            Element potentialParent = sequencingElement.getChild("objectives", this._schemaElement.getNamespace());
            if (potentialParent != null) {
                this._contentPackage.addElement(this, potentialParent, this._objective, false);
            } else {
                _objectives.addContent(this._objective);
                this._contentPackage.addElement(this, sequencingElement, _objectives, false);
            }
        } else {
            Element _sequencing = new Element("sequencing", this._schemaElement.getNamespace());
            _objectives.addContent(this._objective);
            _sequencing.addContent(_objectives);
            this._contentPackage.addElement(this, this._element, _sequencing, false);
        }
    }
}

