/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.transform;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jdom.JDOMException;
import uk.ac.reload.editor.transform.StylesheetCache;

public class XSLTransfomer {
    public static File transform(File inputFile, File xslFile, File outFile, boolean useCache) throws JDOMException, IOException {
        try {
            Transformer transformer = StylesheetCache.newTransformer(xslFile, useCache);
            transformer.transform(new StreamSource(inputFile), new StreamResult(new FileOutputStream(outFile)));
        }
        catch (TransformerConfigurationException te) {
            System.err.println("transformer error " + te.toString());
            return null;
        }
        catch (TransformerException te) {
            System.err.println("transformer exception " + te.toString());
            return null;
        }
        catch (IOException ioe) {
            System.err.println("IO error " + ioe.toString());
            return null;
        }
        return outFile;
    }
}

