/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.transform.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.ac.reload.dweezil.gui.layout.RelativeLayoutManager;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.transform.gui.ModRelLayoutManager;
import uk.ac.reload.editor.transform.helper.ListFilePatterns;

public class FileFilterDialog
extends JDialog {
    int width = 430;
    int heightMin = 100;
    int heightMax = 280;
    private JPanel bottomOKPanel;
    private JButton cancelButton;
    private JPanel centPanel;
    private JPanel fileLstPanel;
    private JList filesList;
    private JScrollPane filesScrollPane;
    private JTextField filterTextField;
    private JLabel foundLabel;
    private JPanel mainPanel;
    private JButton okButton;
    private JLabel selectLabel;
    private JPanel topPanel;
    private JButton xformButton;
    private JButton xformCancelButton;
    private File sourceDir = null;
    private ArrayList fileLst;

    public FileFilterDialog() {
        this.initComponents();
        this.centPanel.setVisible(false);
        this.setSize(new Dimension(this.width, this.heightMin));
        this.repaint();
        this.setDefaultCloseOperation(2);
    }

    public FileFilterDialog(File sourceDir) {
        super(EditorFrame.getInstance(), Messages.getString("FileFilterDialog.0"), true);
        this.initComponents();
        this.sourceDir = sourceDir;
        this.centPanel.setVisible(false);
        this.setSize(new Dimension(this.width, this.heightMin));
        this.repaint();
        this.setLocationRelativeTo(EditorFrame.getInstance());
        this.setDefaultCloseOperation(2);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.topPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.filterTextField = new JTextField();
        this.selectLabel = new JLabel();
        this.centPanel = new JPanel();
        this.bottomOKPanel = new JPanel();
        this.xformButton = new JButton();
        this.xformCancelButton = new JButton();
        this.fileLstPanel = new JPanel();
        this.fileLstPanel.setBorder(new EtchedBorder());
        this.foundLabel = new JLabel();
        this.filesScrollPane = new JScrollPane();
        this.filesList = new JList();
        this.filesList.setSelectionMode(2);
        this.filesList.getSelectionModel().addListSelectionListener(new FileListSelectionHandler());
        this.mainPanel.setLayout(new BorderLayout());
        ModRelLayoutManager topPnlLayoutMngr = new ModRelLayoutManager(this.topPanel);
        this.okButton.setText(Messages.getString("FileFilterDialog.1"));
        this.okButton.setName("OKBtn");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileFilterDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText(Messages.getString("FileFilterDialog.3"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileFilterDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        topPnlLayoutMngr.addFromRightEdge(this.cancelButton, "cancelButton", "filterTextField", 1, 2, -2);
        topPnlLayoutMngr.addFromLeftEdgeComponent(this.okButton, "okButton", "filterTextField", "cancelButton", 1, 2, -1);
        JLabel patternLbl = new JLabel(Messages.getString("FileFilterDialog.4"));
        topPnlLayoutMngr.addFromLeftEdge(patternLbl, "patternLbl", "filterTextField", 1, 5, 5);
        this.filterTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
            }
        });
        this.filterTextField.setPreferredSize(new Dimension(300, 20));
        this.filterTextField.setToolTipText(Messages.getString("FileFilterDialog.4"));
        topPnlLayoutMngr.addFromRightEdgeComponent(this.filterTextField, "filterTextField", "selectLabel", 2, 2, 2);
        this.selectLabel.setText(Messages.getString("FileFilterDialog.2"));
        topPnlLayoutMngr.addFromLeftEdge(this.selectLabel, "selectLabel", "_container", 2, 5, 5);
        RelativeLayoutManager cenLayoutManager = new RelativeLayoutManager((Container)this.centPanel);
        ModRelLayoutManager fileLstPanelLayoutMngr = new ModRelLayoutManager(this.fileLstPanel);
        this.foundLabel.setText(Messages.getString("FileFilterDialog.12"));
        fileLstPanelLayoutMngr.addFromLeftToRightEdges(this.foundLabel, "foundLabel", "_container", 2, 1, 1);
        this.filesScrollPane.setViewportView(this.filesList);
        fileLstPanelLayoutMngr.addFromLeftToRightEdges(this.filesScrollPane, "filesScrollPane", "foundLabel", 1, 0, 0);
        ModRelLayoutManager bottomPnlLayoutMngr = new ModRelLayoutManager(this.bottomOKPanel);
        this.xformButton.setText(Messages.getString("FileFilterDialog.16"));
        this.xformButton.setPreferredSize(new Dimension(150, 25));
        this.xformButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileFilterDialog.this.xformButtonActionPerformed(evt);
            }
        });
        bottomPnlLayoutMngr.addFromLeftEdgeComponent(this.xformButton, "xformButton", "_container", "xformCancelButton", 2, 0, 0);
        this.xformCancelButton.setText(Messages.getString("FileFilterDialog.19"));
        this.xformCancelButton.setPreferredSize(new Dimension(80, 25));
        this.xformCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileFilterDialog.this.xformCancelButtonActionPerformed(evt);
            }
        });
        bottomPnlLayoutMngr.addFromRightEdge(this.xformCancelButton, "xformCancelButton", "_container", 2, 0, 0);
        cenLayoutManager.addFromLeftToRightEdges((JComponent)this.fileLstPanel, "fileLstPanel", "_container", 2, 0, 0);
        cenLayoutManager.addFromLeftToRightEdges((JComponent)this.bottomOKPanel, "bottomOKPanel", "fileLstPanel", 1, 0, 0);
        this.mainPanel.add((Component)this.topPanel, "North");
        this.mainPanel.add((Component)this.centPanel, "Center");
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.pack();
    }

    private void xformCancelButtonActionPerformed(ActionEvent evt) {
        this.fileLst = null;
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.fileLst = null;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.updateFileList();
        this.centPanel.setVisible(true);
        this.setSize(this.width, this.heightMax);
        this.validate();
    }

    private void xformButtonActionPerformed(ActionEvent evt) {
        if (this.fileLst == null) {
            return;
        }
        this.filesList.setListData(this.fileLst.toArray());
        this.filesList.clearSelection();
        this.dispose();
    }

    private void updateFileList() {
        String filePattern = this.filterTextField.getText();
        if (filePattern != null && !"".equals(filePattern) && this.sourceDir != null) {
            this.fileLst = ListFilePatterns.listFiles(this.sourceDir, filePattern, this.filesList);
            this.filesList.repaint();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new FileFilterDialog().setVisible(true);
            }
        });
    }

    public ArrayList getFileLst() {
        return this.fileLst;
    }

    public ArrayList showDialog() {
        this.setVisible(true);
        return this.fileLst;
    }

    class FileListSelectionHandler
    implements ListSelectionListener {
        FileListSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                FileFilterDialog.this.fileLst.clear();
                FileFilterDialog.this.fileLst = new ArrayList();
                int minIndex = lsm.getMinSelectionIndex();
                int maxIndex = lsm.getMaxSelectionIndex();
                for (int i = minIndex; i <= maxIndex; ++i) {
                    if (!lsm.isSelectedIndex(i)) continue;
                    FileFilterDialog.this.fileLst.add(FileFilterDialog.this.filesList.getModel().getElementAt(i));
                }
            }
        }
    }
}

