/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.transform.gui;

import com.brunchboy.util.swing.relativelayout.AttributeConstraint;
import com.brunchboy.util.swing.relativelayout.AttributeType;
import com.brunchboy.util.swing.relativelayout.Constraint;
import com.brunchboy.util.swing.relativelayout.RelativeLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.transform.ScriptLoader;

public class SourceTargetDialog
extends JDialog {
    private String schemaSName = null;
    private String schemaTName = null;
    private Document ctDoc;
    private JList sSchemaList;
    private DefaultListModel sModel;
    private JList tSchemaList;
    private DefaultListModel tModel;
    private JScrollPane sSchemaLstSP;
    private JScrollPane tSchemaLstSP;
    private JTextField selTTxtField;
    private JTextField selSTxtField;
    private ScriptLoader sl;

    public SourceTargetDialog(JFrame parent, String ver) throws JDOMException, IOException, FileNotFoundException {
        super(parent, Messages.getString("SourceTargetDialog.0"), true);
        this.setSize(420, 400);
        this.setResizable(false);
        this.sModel = new DefaultListModel();
        this.sSchemaList = new JList(this.sModel);
        this.sSchemaList.addListSelectionListener(new slistSelListener());
        this.tModel = new DefaultListModel();
        this.tSchemaList = new JList(this.tModel);
        this.tSchemaList.addListSelectionListener(new tlistSelListener());
        if (ver == null) {
            this.loadXSLList();
        } else {
            this.filterTargetSchemaList(ver);
        }
        RelativeLayout ourLayout = new RelativeLayout();
        this.getContentPane().setLayout((LayoutManager)ourLayout);
        JLabel title = new JLabel(Messages.getString("SourceTargetDialog.1"));
        title.setFont(title.getFont().deriveFont(14.0f));
        this.getContentPane().add((Component)title, "title");
        ourLayout.addConstraint("title", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 10));
        ourLayout.addConstraint("title", AttributeType.HORIZONTAL_CENTER, (Constraint)new AttributeConstraint("_container", AttributeType.HORIZONTAL_CENTER));
        JLabel lblSchema = new JLabel(Messages.getString("SourceTargetDialog.2"));
        this.getContentPane().add((Component)lblSchema, "lblSchema");
        ourLayout.addConstraint("lblSchema", AttributeType.TOP, (Constraint)new AttributeConstraint("title", AttributeType.BOTTOM, 8));
        ourLayout.addConstraint("lblSchema", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 20));
        JLabel lbltchema = new JLabel(Messages.getString("SourceTargetDialog.3"));
        this.getContentPane().add((Component)lbltchema, "lbltchema");
        ourLayout.addConstraint("lbltchema", AttributeType.TOP, (Constraint)new AttributeConstraint("lblSchema", AttributeType.TOP));
        ourLayout.addConstraint("lbltchema", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 200));
        this.sSchemaLstSP = new JScrollPane();
        this.sSchemaLstSP.setViewportView(this.sSchemaList);
        this.getContentPane().add((Component)this.sSchemaLstSP, "sSchemaLstSP");
        ourLayout.addConstraint("sSchemaLstSP", AttributeType.LEFT, (Constraint)new AttributeConstraint("lblSchema", AttributeType.LEFT));
        ourLayout.addConstraint("sSchemaLstSP", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 200));
        ourLayout.addConstraint("sSchemaLstSP", AttributeType.TOP, (Constraint)new AttributeConstraint("lblSchema", AttributeType.BOTTOM, 4));
        ourLayout.addConstraint("sSchemaLstSP", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("btnOK", AttributeType.TOP, -40));
        this.tSchemaLstSP = new JScrollPane();
        this.tSchemaLstSP.setViewportView(this.tSchemaList);
        this.getContentPane().add((Component)this.tSchemaLstSP, "tSchemaLstSP");
        ourLayout.addConstraint("tSchemaLstSP", AttributeType.LEFT, (Constraint)new AttributeConstraint("sSchemaLstSP", AttributeType.RIGHT));
        ourLayout.addConstraint("tSchemaLstSP", AttributeType.RIGHT, (Constraint)new AttributeConstraint("sSchemaLstSP", AttributeType.RIGHT, 200));
        ourLayout.addConstraint("tSchemaLstSP", AttributeType.TOP, (Constraint)new AttributeConstraint("lbltchema", AttributeType.BOTTOM, 4));
        ourLayout.addConstraint("tSchemaLstSP", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("btnOK", AttributeType.TOP, -40));
        JLabel selSLbl = new JLabel(Messages.getString("SourceTargetDialog.4"));
        this.selSTxtField = new JTextField("");
        this.selSTxtField.setEditable(false);
        this.getContentPane().add((Component)selSLbl, "selSLbl");
        ourLayout.addConstraint("selSLbl", AttributeType.LEFT, (Constraint)new AttributeConstraint("sSchemaLstSP", AttributeType.LEFT));
        ourLayout.addConstraint("selSLbl", AttributeType.RIGHT, (Constraint)new AttributeConstraint("sSchemaLstSP", AttributeType.RIGHT));
        ourLayout.addConstraint("selSLbl", AttributeType.TOP, (Constraint)new AttributeConstraint("sSchemaLstSP", AttributeType.BOTTOM));
        ourLayout.addConstraint("selSLbl", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("sSchemaLstSP", AttributeType.BOTTOM, 20));
        this.getContentPane().add((Component)this.selSTxtField, "selSTxtField");
        ourLayout.addConstraint("selSTxtField", AttributeType.LEFT, (Constraint)new AttributeConstraint("selSLbl", AttributeType.LEFT));
        ourLayout.addConstraint("selSTxtField", AttributeType.RIGHT, (Constraint)new AttributeConstraint("selSLbl", AttributeType.RIGHT));
        ourLayout.addConstraint("selSTxtField", AttributeType.TOP, (Constraint)new AttributeConstraint("selSLbl", AttributeType.BOTTOM));
        ourLayout.addConstraint("selSTxtField", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("selSLbl", AttributeType.BOTTOM, 20));
        JLabel selTLbl = new JLabel(Messages.getString("SourceTargetDialog.5"));
        this.selTTxtField = new JTextField("");
        this.selTTxtField.setEditable(false);
        this.getContentPane().add((Component)selTLbl, "selTLbl");
        ourLayout.addConstraint("selTLbl", AttributeType.LEFT, (Constraint)new AttributeConstraint("tSchemaLstSP", AttributeType.LEFT));
        ourLayout.addConstraint("selTLbl", AttributeType.RIGHT, (Constraint)new AttributeConstraint("tSchemaLstSP", AttributeType.RIGHT));
        ourLayout.addConstraint("selTLbl", AttributeType.TOP, (Constraint)new AttributeConstraint("tSchemaLstSP", AttributeType.BOTTOM));
        ourLayout.addConstraint("selTLbl", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("tSchemaLstSP", AttributeType.BOTTOM, 20));
        this.getContentPane().add((Component)this.selTTxtField, "selTTxtField");
        ourLayout.addConstraint("selTTxtField", AttributeType.LEFT, (Constraint)new AttributeConstraint("selTLbl", AttributeType.LEFT));
        ourLayout.addConstraint("selTTxtField", AttributeType.RIGHT, (Constraint)new AttributeConstraint("selTLbl", AttributeType.RIGHT));
        ourLayout.addConstraint("selTTxtField", AttributeType.TOP, (Constraint)new AttributeConstraint("selTLbl", AttributeType.BOTTOM));
        ourLayout.addConstraint("selTTxtField", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("selTLbl", AttributeType.BOTTOM, 20));
        JButton btnCancel = new JButton(Messages.getString("SourceTargetDialog.7"));
        btnCancel.addActionListener(new CancelClick());
        this.getContentPane().add((Component)btnCancel, "btnCancel");
        ourLayout.addConstraint("btnCancel", AttributeType.RIGHT, (Constraint)new AttributeConstraint("selTTxtField", AttributeType.RIGHT));
        ourLayout.addConstraint("btnCancel", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("_container", AttributeType.BOTTOM, -5));
        JButton btnOK = new JButton(Messages.getString("SourceTargetDialog.6"));
        btnOK.addActionListener(new OKClick());
        this.getContentPane().add((Component)btnOK, "btnOK");
        ourLayout.addConstraint("btnOK", AttributeType.RIGHT, (Constraint)new AttributeConstraint("btnCancel", AttributeType.LEFT, -5));
        ourLayout.addConstraint("btnOK", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("_container", AttributeType.BOTTOM, -5));
        this.setLocationRelativeTo(EditorFrame.getInstance());
    }

    public String showDialog() {
        this.setVisible(true);
        return this.schemaSName;
    }

    public void loadXSLList() throws JDOMException, IOException, FileNotFoundException {
        this.sl = ScriptLoader.getScriptLoader();
        this.ctDoc = this.sl.getCtXRef();
        List sSchemas = this.ctDoc.getRootElement().getChildren("sourceSchema");
        Iterator sIter = sSchemas.iterator();
        int indx = 0;
        int indx1 = 0;
        while (sIter.hasNext()) {
            Element sSchema = (Element)sIter.next();
            if (sSchema.getTextTrim().indexOf("adl") == -1 && sSchema.getTextTrim().indexOf("imscp") == -1) continue;
            this.sModel.add(indx++, sSchema.getChild("sourceSchemaLabel").getTextTrim());
            for (Element tSchema : sSchema.getChildren("targetSchema")) {
                this.tModel.add(indx1++, tSchema.getChild("targetSchemaLabel").getTextTrim());
            }
        }
    }

    public void updateTargetSchemaList(String sSchemaLbl) {
        List sSchemas = this.ctDoc.getRootElement().getChildren("sourceSchema");
        Iterator sIter = sSchemas.iterator();
        int indx = 0;
        while (sIter.hasNext()) {
            Element sSchema = (Element)sIter.next();
            if (!sSchema.getChild("sourceSchemaLabel").getTextTrim().equalsIgnoreCase(sSchemaLbl)) continue;
            for (Element tSchema : sSchema.getChildren("targetSchema")) {
                this.tModel.add(indx++, tSchema.getChild("targetSchemaLabel").getTextTrim());
            }
        }
    }

    public void filterTargetSchemaList(String schemaVer) throws JDOMException, IOException, FileNotFoundException {
        this.sl = ScriptLoader.getScriptLoader();
        this.ctDoc = this.sl.getCtXRef();
        List sSchemas = this.ctDoc.getRootElement().getChildren("sourceSchema");
        Iterator sIter = sSchemas.iterator();
        int indx = 0;
        int indx1 = 0;
        String[] result = schemaVer.split("&");
        while (sIter.hasNext()) {
            Element sSchema = (Element)sIter.next();
            if (result.length == 1) {
                if (!sSchema.getChild("sourceSchemaLabel").getTextTrim().equalsIgnoreCase(schemaVer)) continue;
                this.sModel.add(indx, sSchema.getChild("sourceSchemaLabel").getTextTrim());
                for (Element tSchema : sSchema.getChildren("targetSchema")) {
                    this.tModel.add(indx1++, tSchema.getChild("targetSchemaLabel").getTextTrim());
                }
                continue;
            }
            if (sSchema.getTextTrim().indexOf(result[0].trim()) != -1 || sSchema.getTextTrim().indexOf(result[1].trim()) != -1) continue;
            this.sModel.add(indx, sSchema.getChild("sourceSchemaLabel").getTextTrim());
            for (Element tSchema : sSchema.getChildren("targetSchema")) {
                this.tModel.add(indx1++, tSchema.getChild("targetSchemaLabel").getTextTrim());
            }
        }
    }

    public String getSchemaSName() {
        return this.schemaSName;
    }

    public String getSchemaTName() {
        return this.schemaTName;
    }

    public Document getCtDoc() {
        return this.ctDoc;
    }

    public ScriptLoader getSl() {
        return this.sl;
    }

    private class tlistSelListener
    implements ListSelectionListener {
        private tlistSelListener() {
        }

        public void valueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting()) {
                SourceTargetDialog.this.selTTxtField.setText((String)SourceTargetDialog.this.tSchemaList.getSelectedValue());
            }
        }
    }

    private class slistSelListener
    implements ListSelectionListener {
        private slistSelListener() {
        }

        public void valueChanged(ListSelectionEvent event) {
            SourceTargetDialog.this.tModel.removeAllElements();
            if (!event.getValueIsAdjusting()) {
                SourceTargetDialog.this.schemaSName = (String)SourceTargetDialog.this.sSchemaList.getSelectedValue();
                SourceTargetDialog.this.updateTargetSchemaList(SourceTargetDialog.this.schemaSName);
                SourceTargetDialog.this.selSTxtField.setText(SourceTargetDialog.this.schemaSName);
            }
        }
    }

    private class CancelClick
    extends AbstractAction {
        private CancelClick() {
        }

        public void actionPerformed(ActionEvent e) {
            SourceTargetDialog.this.schemaSName = null;
            SourceTargetDialog.this.dispose();
        }
    }

    private class OKClick
    extends AbstractAction {
        private OKClick() {
        }

        public void actionPerformed(ActionEvent e) {
            SourceTargetDialog.this.schemaSName = SourceTargetDialog.this.selSTxtField.getText();
            SourceTargetDialog.this.schemaTName = SourceTargetDialog.this.selTTxtField.getText();
            SourceTargetDialog.this.dispose();
        }
    }
}

