/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.transform.helper;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JList;

public class ListFilePatterns {
    static void listPath(File path, FileFilter filter, List lst) {
        Object[] files = path.listFiles(filter);
        Arrays.sort(files);
        int n = files.length;
        for (int i = 0; i < n; ++i) {
            if (((File)files[i]).isDirectory()) {
                ListFilePatterns.listPath((File)files[i], filter, lst);
                continue;
            }
            lst.add(files[i]);
        }
    }

    public static ArrayList listFiles(File dir, String filePattern, JList lst) {
        PatternFileFilter filter = new PatternFileFilter(filePattern);
        ArrayList list = new ArrayList();
        ListFilePatterns.listPath(dir, filter, list);
        lst.setListData(list.toArray());
        return list;
    }

    static class PatternFileFilter
    implements FileFilter {
        Pattern pattern;

        public PatternFileFilter(String pattern) {
            pattern = pattern.replaceAll("\\*", ".*");
            this.pattern = Pattern.compile(pattern);
        }

        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                return true;
            }
            return this.pattern.matcher(pathname.getName()).matches();
        }
    }
}

