/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.transform.helper;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import uk.ac.reload.editor.Messages;

public class ListFiles {
    private String suff = ".xml";

    public ListFiles(String prefix) {
        this.suff = prefix + this.suff;
    }

    public List getFileListing(String startingDir) throws FileNotFoundException {
        return this.getFileListing(new File(startingDir));
    }

    public List getFileListing(File aStartingDir) throws FileNotFoundException {
        ListFiles.validateDirectory(aStartingDir);
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = aStartingDir.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        Iterator<File> filesIter = filesDirs.iterator();
        File file = null;
        while (filesIter.hasNext()) {
            file = filesIter.next();
            if (file.isFile() && file.getName().equalsIgnoreCase(this.suff)) {
                result.add(file);
                continue;
            }
            if (file.isFile()) continue;
            List deeperList = this.getFileListing(file);
            result.addAll(deeperList);
        }
        Collections.sort(result);
        return result;
    }

    private static void validateDirectory(File aDirectory) throws FileNotFoundException {
        if (aDirectory == null) {
            throw new IllegalArgumentException(Messages.getString("ListFiles.1"));
        }
        if (!aDirectory.exists()) {
            throw new FileNotFoundException(Messages.getString("ListFiles.2") + aDirectory);
        }
        if (!aDirectory.isDirectory()) {
            throw new IllegalArgumentException(Messages.getString("ListFiles.3") + aDirectory);
        }
        if (!aDirectory.canRead()) {
            throw new IllegalArgumentException(Messages.getString("ListFiles.4") + aDirectory);
        }
    }
}

