/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.valdn;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.reload.dweezil.util.NativeLauncher;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.EditorHandler;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.transform.XSLTransfomer;
import uk.ac.reload.editor.valdn.StringUtils;
import uk.ac.reload.jdom.XMLUtils;
import uk.ac.reload.moonunit.SchemaDocument;

public class DocValidator {
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static File scmtXSLPath = new File(EditorHandler.SCHEMAROOTFOLDER.getAbsolutePath(), "schematron");

    public static String validateWithJava(String instanceFile, String[] schemafiles) {
        if (instanceFile == null) {
            return Messages.getString("CVDocValidator.13");
        }
        String valResult = Messages.getString("CVDocValidator.8");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        factory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        factory.setAttribute(JAXP_SCHEMA_SOURCE, schemafiles);
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
            return "Invalid Document\n " + e1.getMessage();
        }
        ValidatorErrorHandler handler = new ValidatorErrorHandler();
        docBuilder.setErrorHandler(handler);
        try {
            docBuilder.parse(new File(instanceFile));
        }
        catch (SAXException e) {
            valResult = e.getMessage();
        }
        catch (IOException e) {
            valResult = e.getMessage();
        }
        if (handler.validationError) {
            valResult = "Parser_Error:\n " + handler.saxParseException.getMessage();
        } else if (handler.validationWarning) {
            valResult = "Parser_Warning:\n " + handler.saxParseException.getMessage();
        }
        return valResult;
    }

    public static void validateWithJava(SchemaDocument reloadDoc) {
        String valMessage = Messages.getString("CVDocValidator.0");
        String schemaLocn = "";
        if (reloadDoc.getSchemaController().getSchemaFile() != null) {
            schemaLocn = reloadDoc.getSchemaController().getSchemaFile().getAbsolutePath();
        }
        String[] schemaLocns = new String[]{schemaLocn};
        String schLocnStr = reloadDoc.getDocument().getRootElement().getAttributeValue(XMLUtils.XSI_SchemaLocation, XMLUtils.XSI_Namespace);
        String baseFolder = "";
        if (reloadDoc.getFile() != null) {
            baseFolder = reloadDoc.getFile().getParent();
        }
        if (schLocnStr != null && !"".equals(schLocnStr)) {
            StringTokenizer parser = new StringTokenizer(schLocnStr);
            int noOfLocn = parser.countTokens() / 2;
            String[] locns = new String[noOfLocn];
            while (parser.hasMoreTokens()) {
                parser.nextToken();
                String schemaLoc = parser.nextToken();
                if (schemaLoc.indexOf("http") == -1) {
                    schemaLoc = baseFolder + File.separator + schemaLoc;
                }
                locns[--noOfLocn] = schemaLoc;
            }
            schemaLocns = locns;
        }
        if ((valMessage = DocValidator.validateWithJava(reloadDoc.getFile().getAbsolutePath(), schemaLocns)).length() > 60) {
            valMessage = StringUtils.breakLongWords(valMessage, 60);
        }
        if (!valMessage.startsWith("Parser_Error:")) {
            JOptionPane.showMessageDialog(EditorFrame.getInstance(), valMessage);
        } else {
            JOptionPane.showMessageDialog(EditorFrame.getInstance(), valMessage, Messages.getString("CVDocValidator.6"), 0);
        }
    }

    public static void validateWithSchematron(String targetInstance, String scmtronRuleFile) {
        File schematronReport = new File(scmtXSLPath, "schematron-report.xsl");
        File verbid = new File(scmtXSLPath, "verbid.xml");
        String xslpath = scmtXSLPath.getAbsolutePath();
        String outPath = xslpath + File.separator + "schematron-out.html";
        boolean exists = new File(outPath).exists();
        if (exists) {
            new File("filename").delete();
        }
        int errorId = 0;
        try {
            String interPath = xslpath + File.separator + "intermediate.xsl";
            XSLTransfomer.transform(new File(scmtronRuleFile), schematronReport, new File(interPath), false);
            errorId = 1;
            String errorPath = xslpath + File.separator + "schematron-errors.html";
            XSLTransfomer.transform(new File(targetInstance), new File(interPath), new File(errorPath), false);
            errorId = 2;
            XSLTransfomer.transform(new File(targetInstance), verbid, new File(outPath), false);
            errorId = 3;
            exists = new File(outPath).exists();
            if (exists) {
                NativeLauncher.launchFile((File)new File(xslpath, "schematron-frame.html"));
            } else {
                JOptionPane.showMessageDialog(EditorFrame.getInstance(), "Error in executing the schematron constraint file.\n", "Schematron validation Error", 0);
            }
        }
        catch (IOException e) {
            String msg = "";
            if (errorId == 0) {
                msg = "IOException in opening file " + schematronReport.getAbsoluteFile() + " or writing to directory. Make sure you have write access to directory";
            } else if (errorId == 1 || errorId == 2) {
                msg = "IOException in openning target instance - " + targetInstance + " or writing to directory. Make sure you have write access to directory";
            }
            JOptionPane.showMessageDialog(EditorFrame.getInstance(), "Error executing the constraint specification.\n" + msg + ":\n" + e.getMessage(), msg, 0);
        }
        catch (Exception e) {
            String msg = "";
            msg = errorId == 3 ? "Invalid pointer to browser executable file." : "Unknown exception.";
            JOptionPane.showMessageDialog(EditorFrame.getInstance(), "Error executing the constraint specification.\n" + msg + ":\n" + e.getMessage(), msg, 0);
        }
    }

    static class ValidatorErrorHandler
    extends DefaultHandler {
        public boolean validationError = false;
        public boolean validationWarning = false;
        public SAXParseException saxParseException = null;

        ValidatorErrorHandler() {
        }

        public void error(SAXParseException exception) throws SAXException {
            this.validationError = true;
            this.saxParseException = exception;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.validationError = true;
            this.saxParseException = exception;
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.validationWarning = true;
            this.saxParseException = exception;
        }
    }
}

